/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.cast.js.ssa;

import com.ibm.wala.cast.js.ssa.JSInstructionFactory;
import com.ibm.wala.cast.js.ssa.JSInstructionVisitor;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SSAInstructionFactory;
import com.ibm.wala.ssa.SymbolTable;

public class SetPrototype
extends SSAInstruction {
    private final int object;
    private final int prototype;

    public SetPrototype(int iindex, int object, int prototype) {
        super(iindex);
        this.object = object;
        this.prototype = prototype;
    }

    public int getNumberOfUses() {
        return 2;
    }

    public int getUse(int j) throws UnsupportedOperationException {
        assert (j >= 0 && j <= 1);
        return j == 0 ? this.object : this.prototype;
    }

    public SSAInstruction copyForSSA(SSAInstructionFactory insts, int[] defs, int[] uses) {
        return ((JSInstructionFactory)insts).SetPrototype(this.iindex, uses != null ? uses[0] : this.object, uses != null ? uses[1] : this.prototype);
    }

    public String toString(SymbolTable symbolTable) {
        return "set_prototype(" + this.getValueString(symbolTable, this.object) + ", " + this.getValueString(symbolTable, this.prototype) + ")";
    }

    public void visit(SSAInstruction.IVisitor v) {
        ((JSInstructionVisitor)v).visitSetPrototype(this);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.object;
        result = 31 * result + this.prototype;
        return result;
    }

    public boolean isFallThrough() {
        return true;
    }
}

