/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.frameworks.analyzers.javaee;

import com.ibm.appscan.frameworks.analyzers.generic.CodeProcessor;
import com.ibm.appscan.frameworks.analyzers.generic.StringConstantFlow;
import com.ibm.appscan.frameworks.analyzers.javaee.BeanScope;
import com.ibm.appscan.frameworks.analyzers.javaee.BeanSeed;
import com.ibm.appscan.frameworks.util.WalaUtil;
import com.ibm.appscan.taint.util.logging.TaintLogger;
import com.ibm.wala.analysis.typeInference.TypeAbstraction;
import com.ibm.wala.classLoader.CallSiteReference;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IClassLoader;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.ssa.DefUse;
import com.ibm.wala.ssa.IR;
import com.ibm.wala.ssa.SSAAbstractInvokeInstruction;
import com.ibm.wala.ssa.SSACheckCastInstruction;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.collections.HashSetFactory;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import org.apache.log4j.Logger;

public class SetGetAttributeUsageExtractor {
    private static final Logger logger = TaintLogger.i().getLogger();
    private static final AttributeAccessMethod[] attrAccessMethods = new AttributeAccessMethod[]{AttributeAccessMethod.make("javax.servlet.jsp.PageContext.setAttribute(Ljava/lang/String;Ljava/lang/Object;)V", 1, 2, BeanScope.Page), AttributeAccessMethod.make("javax.servlet.jsp.PageContext.setAttribute(Ljava/lang/String;Ljava/lang/Object;I)V", 1, 2, BeanScope.Page), AttributeAccessMethod.make("javax.servlet.jsp.PageContext.getAttribute(Ljava/lang/String;I)Ljava/lang/Object;", 1, -1, BeanScope.Page), AttributeAccessMethod.make("javax.servlet.jsp.PageContext.getAttribute(Ljava/lang/String;)Ljava/lang/Object;", 1, -1, BeanScope.Page), AttributeAccessMethod.make("javax.servlet.ServletRequest.setAttribute(Ljava/lang/String;Ljava/lang/Object;)V", 1, 2, BeanScope.Request), AttributeAccessMethod.make("javax.servlet.ServletRequest.getAttribute(Ljava/lang/String;)Ljava/lang/Object;", 1, -1, BeanScope.Request), AttributeAccessMethod.make("javax.servlet.http.HttpSession.setAttribute(Ljava/lang/String;Ljava/lang/Object;)V", 1, 2, BeanScope.Session), AttributeAccessMethod.make("javax.servlet.http.HttpSession.getAttribute(Ljava/lang/String;)Ljava/lang/Object;", 1, -1, BeanScope.Session), AttributeAccessMethod.make("javax.servlet.ServletContext.setAttribute(Ljava/lang/String;Ljava/lang/Object;)V", 1, 2, BeanScope.Session), AttributeAccessMethod.make("javax.servlet.ServletContext.getAttribute(Ljava/lang/String;)Ljava/lang/Object;", 1, -1, BeanScope.Session), AttributeAccessMethod.makeIgnored("javax.servlet.jsp.tagext.TagData.getAttributeString(Ljava/lang/String;)Ljava/lang/String;"), AttributeAccessMethod.makeIgnored("com.ibm.bg.services.BGServices.getAttributeResults(Ljava/lang/String;[Lorg/eclipse/emf/ecore/EClass;[Lorg/eclipse/emf/ecore/EStructuralFeature;[Lorg/eclipse/emf/ecore/EStructuralFeature;[Ljava/lang/String;[Ljava/lang/String;[Ljava/lang/String;Ljava/util/List;Ljava/util/List;Ljava/util/Date;Lcom/unicorn/ontology/util/tools/DebugTimer;)Ljava/util/List;"), AttributeAccessMethod.makeIgnored("com.telus.frameworkslight.utils.WebUtils.getAttribute(Ljavax/servlet/http/HttpServletRequest;ILjava/lang/String;)Ljava/lang/Object;"), AttributeAccessMethod.makeIgnored("com.unicorn.webapp.utils.UTagUtils.getAttribute(Ljavax/servlet/jsp/PageContext;Ljava/lang/String;Ljava/lang/String;)Ljava/lang/Object;"), AttributeAccessMethod.makeIgnored("com.telus.frameworkslight.utils.WebUtils.setAttribute(Ljavax/servlet/http/HttpServletRequest;ILjava/lang/String;Ljava/lang/Object;)V"), AttributeAccessMethod.makeIgnored("javax.naming.directory.DirContext.getAttributes(Ljava/lang/String;[Ljava/lang/String;)Ljavax/naming/directory/Attributes;"), AttributeAccessMethod.makeIgnored("javax.naming.directory.SearchResult.getAttributes()Ljavax/naming/directory/Attributes;")};
    private Set<BeanSeed> seeds = HashSetFactory.make();

    public SetGetAttributeUsageExtractor(final IClassHierarchy cha, CodeProcessor callProcessor) {
        callProcessor.addVisitor(new CodeProcessor.ICodeVisitor(){
            private AttributeAccessMethod matchedAccessMethod = null;

            public void visitCallSite(IMethod m, IR ir, DefUse du, TypeAbstraction[] types, CallSiteReference callSiteRef, SSAAbstractInvokeInstruction invoke, CodeProcessor.ICallSiteInfo callInfo) {
                assert (this.matchedAccessMethod != null) : "m=" + m + " callSiteRef=" + callSiteRef;
                assert (!this.matchedAccessMethod.shouldIgnore);
                int attrNameVn = WalaUtil.paramIndexToVn(invoke, this.matchedAccessMethod.attrNameParamIndex);
                StringConstantFlow constantFlow = StringConstantFlow.makeIntraproc((IR)ir, (DefUse)du);
                Collection attrNames = constantFlow.findIntraprocStringsFlowingToVar(attrNameVn);
                if (attrNames.isEmpty()) {
                    // empty if block
                }
                for (String attrName : attrNames) {
                    int objectVn = WalaUtil.paramIndexToVn(invoke, this.matchedAccessMethod.objectParamIndex);
                    TypeReference type = SetGetAttributeUsageExtractor.this.getApproximatedType(du, types, objectVn);
                    SetGetAttributeUsageExtractor.this.seeds.add(new BeanSeed(m, callSiteRef, this.matchedAccessMethod.objectParamIndex, this.matchedAccessMethod.beanScope, attrName, null, type, WalaUtil.getSourceLine(m, callSiteRef)));
                }
            }

            public boolean accepts(IMethod m) {
                return true;
            }

            public boolean accepts(IClass c) {
                return true;
            }

            public boolean accepts(IClassLoader loader) {
                return cha.getScope().isApplicationLoader(loader);
            }

            public boolean accepts(IMethod m, CallSiteReference callSiteRef, CodeProcessor.ICallSiteInfo callInfo) {
                this.matchedAccessMethod = null;
                for (AttributeAccessMethod miniFeature : attrAccessMethods) {
                    if (!callInfo.overrides(miniFeature.sig)) continue;
                    if (!miniFeature.shouldIgnore) {
                        this.matchedAccessMethod = miniFeature;
                        return true;
                    }
                    return false;
                }
                if (callSiteRef.toString().contains("setAttribute") || callSiteRef.toString().contains("getAttribute")) {
                    logger.warn((Object)("Found a suspicious call that is not mapped: " + callSiteRef.getDeclaredTarget().getSignature() + " at " + m));
                }
                return false;
            }

            public void visitMethod(IMethod m, IR ir, DefUse du, TypeAbstraction[] type) {
                throw new UnsupportedOperationException();
            }

            public boolean visitsCallSites() {
                return true;
            }
        });
    }

    protected TypeReference getApproximatedType(DefUse du, TypeAbstraction[] types, int vn) {
        TypeAbstraction typeAbstraction = types[vn];
        TypeReference ret = typeAbstraction.getTypeReference();
        if (ret == null || ret.equals((Object)TypeReference.JavaLangObject)) {
            Iterator iter = du.getUses(vn);
            while (iter.hasNext()) {
                SSAInstruction instruction = (SSAInstruction)iter.next();
                if (!(instruction instanceof SSACheckCastInstruction)) continue;
                ret = ((SSACheckCastInstruction)instruction).getDeclaredResultTypes()[0];
            }
        }
        return ret;
    }

    public Set<BeanSeed> getBeanSeeds() {
        return this.seeds;
    }

    private static class AttributeAccessMethod {
        public final String sig;
        public final int attrNameParamIndex;
        public final int objectParamIndex;
        public final BeanScope beanScope;
        public final boolean shouldIgnore;

        static AttributeAccessMethod make(String sig, int attrNameParamIndex, int objectParamIndex, BeanScope beanScope) {
            return new AttributeAccessMethod(sig, attrNameParamIndex, objectParamIndex, beanScope, false);
        }

        static AttributeAccessMethod makeIgnored(String sig) {
            return new AttributeAccessMethod(sig, -2, -2, null, true);
        }

        private AttributeAccessMethod(String sig, int attrNameParamIndex, int objectParamIndex, BeanScope beanScope, boolean shouldIgnore) {
            this.sig = sig;
            this.attrNameParamIndex = attrNameParamIndex;
            this.objectParamIndex = objectParamIndex;
            this.beanScope = beanScope;
            this.shouldIgnore = shouldIgnore;
        }
    }
}

