/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.frameworks.analyzers.spring;

import com.ibm.appscan.frameworks.analyzers.generic.LangIndependentWalaUtil;
import com.ibm.appscan.frameworks.analyzers.spring.SpringConfigFileInfo;
import com.ibm.appscan.taint.util.logging.TaintLogger;
import com.ibm.wala.classLoader.CallSiteReference;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.ipa.callgraph.AnalysisCache;
import com.ibm.wala.ssa.DefUse;
import com.ibm.wala.ssa.IR;
import com.ibm.wala.ssa.SSAAbstractInvokeInstruction;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.types.MethodReference;
import com.ibm.wala.types.Selector;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.collections.Iterator2Iterable;
import java.util.Iterator;

public class SpringBeanUtil {
    public static String getPropValFromInfoOrConstructor(String propertyName, TypeReference propertyType, SpringConfigFileInfo.SpringBeanInfo beanInfo, IClass klass, DefToPropValFun convertDef2PropVal, AnalysisCache cache) {
        Object valueFromBeanInfo = beanInfo.getProperties().get(propertyName);
        if (valueFromBeanInfo != null) {
            return (String)valueFromBeanInfo;
        }
        Selector initSelector = Selector.make((String)"<init>()V");
        for (IMethod m : klass.getDeclaredMethods()) {
            if (!m.getSelector().equals((Object)initSelector)) continue;
            return SpringBeanUtil.searchForSetterValue(propertyName, propertyType, m, convertDef2PropVal, cache);
        }
        return null;
    }

    private static String searchForSetterValue(String propertyName, TypeReference propertyType, IMethod m, DefToPropValFun convertDef2PropVal, AnalysisCache cache) {
        IR ir = LangIndependentWalaUtil.getIR((IMethod)m, (AnalysisCache)cache);
        assert (ir != null);
        DefUse du = LangIndependentWalaUtil.getDU((IR)ir, (AnalysisCache)cache);
        Selector setterSelector = SpringBeanUtil.buildSetterSelector(propertyName, propertyType);
        IMethod setterMethod = m.getClassHierarchy().resolveMethod(MethodReference.findOrCreate((TypeReference)m.getDeclaringClass().getReference(), (Selector)setterSelector));
        if (setterMethod == null) {
            TaintLogger.i().getLogger().info((Object)("could not resolve setter method for property " + propertyName));
            return null;
        }
        for (SSAInstruction instruction : Iterator2Iterable.make((Iterator)ir.iterateNormalInstructions())) {
            if (!(instruction instanceof SSAAbstractInvokeInstruction)) continue;
            SSAAbstractInvokeInstruction invoke = (SSAAbstractInvokeInstruction)instruction;
            CallSiteReference callSite = invoke.getCallSite();
            MethodReference declaredTarget = callSite.getDeclaredTarget();
            IMethod resolvedTarget = m.getClassHierarchy().resolveMethod(declaredTarget);
            if (resolvedTarget == null || !resolvedTarget.equals(setterMethod)) continue;
            int argToSetter = invoke.getUse(1);
            return convertDef2PropVal.apply(ir, du, argToSetter);
        }
        return null;
    }

    private static Selector buildSetterSelector(String propertyName, TypeReference propertyType) {
        StringBuilder selectorStr = new StringBuilder();
        selectorStr.append("set").append(Character.toUpperCase(propertyName.charAt(0))).append(propertyName.substring(1)).append("(");
        selectorStr.append(propertyType.getName().toString());
        if (!propertyType.isPrimitiveType()) {
            selectorStr.append(";");
        }
        selectorStr.append(")V");
        return Selector.make((String)selectorStr.toString());
    }

    public static interface DefToPropValFun {
        public String apply(IR var1, DefUse var2, int var3);
    }
}

