/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.frameworks.analyzers.struts1;

import com.ibm.appscan.frameworks.parsers.strutsParser.IStrutsInfo;
import com.ibm.appscan.frameworks.util.WalaUtil;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.collections.HashSetFactory;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class StrutsRequestProcessorInfo {
    private static final String STRUTS_REQUEST_PROCESSOR_CLASS_NAME = "org.apache.struts.action.RequestProcessor";

    public static Set<String> getRequestProcessorEntrypoints(Collection<IStrutsInfo> parsers, IClassHierarchy cha) {
        String requestProcessorClass = StrutsRequestProcessorInfo.getRequestProcessorClass(parsers);
        if (requestProcessorClass == null) {
            return Collections.emptySet();
        }
        return StrutsRequestProcessorInfo.getReqProcEntrypointsForClass(requestProcessorClass, cha);
    }

    private static Set<String> getReqProcEntrypointsForClass(String requestProcessorClass, IClassHierarchy cha) {
        IClass klass = cha.lookupClass(WalaUtil.createTypeRefForJavaClassName(requestProcessorClass));
        IClass strutsRequestProcessorKlass = cha.lookupClass(WalaUtil.createTypeRefForJavaClassName(STRUTS_REQUEST_PROCESSOR_CLASS_NAME));
        if (klass == null || strutsRequestProcessorKlass == null) {
            return Collections.emptySet();
        }
        HashSet result = HashSetFactory.make();
        for (IMethod m : klass.getDeclaredMethods()) {
            if (m.isStatic() || strutsRequestProcessorKlass.getMethod(m.getSelector()) == null) continue;
            for (int i = 0; i < m.getNumberOfParameters(); ++i) {
                TypeReference parameterType = m.getParameterType(i);
                if (!parameterType.getName().toString().equals("Ljavax/servlet/http/HttpServletRequest")) continue;
                result.add(m.getSignature());
            }
        }
        return result;
    }

    private static String getRequestProcessorClass(Collection<IStrutsInfo> parsers) {
        for (IStrutsInfo parser : parsers) {
            String processorClass = parser.getControllerProperties().get("processorClass");
            if (processorClass == null) continue;
            return processorClass;
        }
        return null;
    }
}

