/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.frameworks.parsers.deploymentDescriptorParser;

import com.ibm.appscan.frameworks.parsers.deploymentDescriptorParser.IJavaEEDeploymentDescriptorInfo;
import com.ibm.appscan.frameworks.util.DOMParserWithLineNumbers;
import com.ibm.appscan.frameworks.util.PreNamespaceContext;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.collections.MapUtil;
import com.ibm.wala.util.collections.Pair;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.NamespaceContext;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class DOMBasedDeploymentDescriptorInfo
implements IJavaEEDeploymentDescriptorInfo {
    private final Map<String, List<String>> servletClassName2ServletNames = HashMapFactory.make();
    private final Map<String, List<String>> filterClassName2FilterNames = HashMapFactory.make();
    private final Map<String, String> jspPathToServletName = HashMapFactory.make();
    private final Map<String, List<String>> servletMappings = HashMapFactory.make();
    private final Map<String, List<String>> filterURLMappings = HashMapFactory.make();
    private final Map<String, List<String>> filterServletNameMappings = HashMapFactory.make();
    private final Map<String, List<Pair<String, String>>> servletName2InitParams = HashMapFactory.make();
    private final Map<String, List<Pair<String, String>>> filterName2InitParams = HashMapFactory.make();
    private final Set<String> servletNames = HashSetFactory.make();
    private final Set<String> filterNames = HashSetFactory.make();
    private final Map<String, String> contextParamNameToValue = HashMapFactory.make();
    private final String namespaceURI;

    public DOMBasedDeploymentDescriptorInfo(String filename) throws IOException, SAXException {
        DOMParserWithLineNumbers parser = new DOMParserWithLineNumbers(filename);
        Document document = parser.getDocument();
        this.namespaceURI = this.getNamespaceURI(document);
        this.populate(document);
    }

    private String getNamespaceURI(Document document) {
        NodeList childNodes = document.getChildNodes();
        Node webAppNode = null;
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node child = childNodes.item(i);
            if (!child.getNodeName().equals("web-app")) continue;
            webAppNode = child;
            break;
        }
        if (webAppNode == null) {
            return null;
        }
        NamedNodeMap attributes = webAppNode.getAttributes();
        if (attributes == null) {
            return null;
        }
        Node nsAttribute = attributes.getNamedItem("xmlns");
        if (nsAttribute == null) {
            return null;
        }
        return nsAttribute.getNodeValue();
    }

    private void populate(Document doc) {
        XPath xpath = this.createXPath();
        try {
            this.handleServlets(doc, xpath);
            this.handleServletMappings(doc, xpath);
            this.handleFilters(doc, xpath);
            this.handleFilterMappings(doc, xpath);
            this.handleContextParams(doc, xpath);
        }
        catch (XPathExpressionException e) {
            e.printStackTrace();
        }
    }

    private void handleContextParams(Document doc, XPath xpath) throws XPathExpressionException {
        NodeList contextParamNodes = (NodeList)xpath.compile(this.adjustForNS("//pre:context-param")).evaluate(doc, XPathConstants.NODESET);
        for (int i = 0; i < contextParamNodes.getLength(); ++i) {
            Node contextParamNode = contextParamNodes.item(i);
            String paramName = xpath.compile(this.adjustForNS("normalize-space(pre:param-name/text())")).evaluate(contextParamNode);
            String paramValue = xpath.compile(this.adjustForNS("normalize-space(pre:param-value/text())")).evaluate(contextParamNode);
            this.contextParamNameToValue.put(paramName, paramValue);
        }
    }

    private void handleServletMappings(Document doc, XPath xpath) throws XPathExpressionException {
        NodeList servletMappingNodes = (NodeList)xpath.compile(this.adjustForNS("//pre:servlet-mapping")).evaluate(doc, XPathConstants.NODESET);
        for (int i = 0; i < servletMappingNodes.getLength(); ++i) {
            Node servletMappingNode = servletMappingNodes.item(i);
            String servletName = xpath.compile(this.adjustForNS("normalize-space(pre:servlet-name/text())")).evaluate(servletMappingNode);
            String urlPattern = xpath.compile(this.adjustForNS("normalize-space(pre:url-pattern/text())")).evaluate(servletMappingNode);
            MapUtil.findOrCreateList(this.servletMappings, (Object)servletName).add(urlPattern);
        }
    }

    private void handleFilterMappings(Document doc, XPath xpath) throws XPathExpressionException {
        NodeList filterMappingNodes = (NodeList)xpath.compile(this.adjustForNS("//pre:filter-mapping")).evaluate(doc, XPathConstants.NODESET);
        for (int i = 0; i < filterMappingNodes.getLength(); ++i) {
            String servletName;
            Node filterMappingNode = filterMappingNodes.item(i);
            String filterName = xpath.compile(this.adjustForNS("normalize-space(pre:filter-name/text())")).evaluate(filterMappingNode);
            String urlPattern = xpath.compile(this.adjustForNS("normalize-space(pre:url-pattern/text())")).evaluate(filterMappingNode);
            if (urlPattern != null && !"".equals(urlPattern)) {
                MapUtil.findOrCreateList(this.filterURLMappings, (Object)filterName).add(urlPattern);
            }
            if ((servletName = xpath.compile(this.adjustForNS("normalize-space(pre:servlet-name/text())")).evaluate(filterMappingNode)) == null || "".equals(servletName)) continue;
            MapUtil.findOrCreateList(this.filterServletNameMappings, (Object)filterName).add(servletName);
        }
    }

    private void handleServlets(Document doc, XPath xpath) throws XPathExpressionException {
        XPathExpression servletExpr = xpath.compile(this.adjustForNS("//pre:servlet"));
        Object result = servletExpr.evaluate(doc, XPathConstants.NODESET);
        NodeList nodes = (NodeList)result;
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node item = nodes.item(i);
            String servletName = xpath.compile(this.adjustForNS("normalize-space(pre:servlet-name/text())")).evaluate(item);
            this.servletNames.add(servletName);
            NodeList initParamList = (NodeList)xpath.compile(this.adjustForNS("pre:init-param")).evaluate(item, XPathConstants.NODESET);
            ArrayList<Pair> initParams = new ArrayList<Pair>(initParamList.getLength());
            for (int j = 0; j < initParamList.getLength(); ++j) {
                Node initParam = initParamList.item(j);
                String paramName = xpath.compile(this.adjustForNS("normalize-space(pre:param-name/text())")).evaluate(initParam);
                String paramValue = xpath.compile(this.adjustForNS("normalize-space(pre:param-value/text())")).evaluate(initParam);
                initParams.add(Pair.make((Object)paramName, (Object)paramValue));
            }
            this.servletName2InitParams.put(servletName, initParams);
            NodeList servletClassList = (NodeList)xpath.compile(this.adjustForNS("pre:servlet-class")).evaluate(item, XPathConstants.NODESET);
            if (servletClassList.getLength() == 0) {
                NodeList jspPathList = (NodeList)xpath.compile(this.adjustForNS("pre:jsp-file")).evaluate(item, XPathConstants.NODESET);
                if (jspPathList.getLength() <= 0) continue;
                String jspPath = this.trimWhitespace(jspPathList.item(0).getTextContent());
                this.jspPathToServletName.put(jspPath, servletName);
                continue;
            }
            String servletClassName = this.trimWhitespace(servletClassList.item(0).getTextContent());
            MapUtil.findOrCreateList(this.servletClassName2ServletNames, (Object)servletClassName).add(servletName);
        }
    }

    private void handleFilters(Document doc, XPath xpath) throws XPathExpressionException {
        XPathExpression filterExpr = xpath.compile(this.adjustForNS("//pre:filter"));
        Object result = filterExpr.evaluate(doc, XPathConstants.NODESET);
        NodeList nodes = (NodeList)result;
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node item = nodes.item(i);
            String filterName = xpath.compile(this.adjustForNS("normalize-space(pre:filter-name/text())")).evaluate(item);
            this.filterNames.add(filterName);
            NodeList initParamList = (NodeList)xpath.compile(this.adjustForNS("pre:init-param")).evaluate(item, XPathConstants.NODESET);
            ArrayList<Pair> initParams = new ArrayList<Pair>(initParamList.getLength());
            for (int j = 0; j < initParamList.getLength(); ++j) {
                Node initParam = initParamList.item(j);
                String paramName = xpath.compile(this.adjustForNS("normalize-space(pre:param-name/text())")).evaluate(initParam);
                String paramValue = xpath.compile(this.adjustForNS("normalize-space(pre:param-value/text())")).evaluate(initParam);
                initParams.add(Pair.make((Object)paramName, (Object)paramValue));
            }
            this.filterName2InitParams.put(filterName, initParams);
            NodeList filterClassList = (NodeList)xpath.compile(this.adjustForNS("pre:filter-class")).evaluate(item, XPathConstants.NODESET);
            if (filterClassList.getLength() != 1) continue;
            String filterClassName = this.trimWhitespace(filterClassList.item(0).getTextContent());
            MapUtil.findOrCreateList(this.filterClassName2FilterNames, (Object)filterClassName).add(filterName);
        }
    }

    private String adjustForNS(String query) {
        return this.namespaceURI != null ? query : query.replaceAll("pre:", "");
    }

    private XPath createXPath() {
        XPathFactory factory = XPathFactory.newInstance();
        XPath xpath = factory.newXPath();
        if (this.namespaceURI != null) {
            xpath.setNamespaceContext((NamespaceContext)new PreNamespaceContext(this.namespaceURI));
        }
        return xpath;
    }

    @Override
    public Collection<String> getAllServletClassNames() {
        return this.servletClassName2ServletNames.keySet();
    }

    @Override
    public Map<String, List<String>> getServletMappings() {
        return this.servletMappings;
    }

    @Override
    public Collection<String> getServletNamesForServletClass(String servletClassName) {
        List<String> result = this.servletClassName2ServletNames.get(servletClassName);
        if (result == null) {
            return Collections.emptySet();
        }
        return result;
    }

    @Override
    public List<Pair<String, String>> getInitParamsForServletName(String servletName) throws IllegalArgumentException {
        if (!this.servletNames.contains(servletName)) {
            throw new IllegalArgumentException("unknown servlet name " + servletName);
        }
        List<Pair<String, String>> result = this.servletName2InitParams.get(servletName);
        if (result == null) {
            return Collections.emptyList();
        }
        return result;
    }

    private String trimWhitespace(String str) {
        return str.replaceAll("^\\s+", "").replaceAll("\\s+$", "");
    }

    @Override
    public Collection<String> getMappedJSPPaths() {
        return this.jspPathToServletName.keySet();
    }

    @Override
    public String getServletNameForJSPPath(String jspPath) {
        return this.jspPathToServletName.get(jspPath);
    }

    @Override
    public String getContextParamValue(String contextParamName) {
        return this.contextParamNameToValue.get(contextParamName);
    }

    @Override
    public Collection<String> getFilterNamesForFilterClass(String filterClassName) {
        List<String> result = this.filterClassName2FilterNames.get(filterClassName);
        if (result == null) {
            return Collections.emptySet();
        }
        return result;
    }

    @Override
    public Collection<String> getAllFilterClassNames() {
        return this.filterClassName2FilterNames.keySet();
    }

    @Override
    public Map<String, List<String>> getFilterURLMappings() {
        return this.filterURLMappings;
    }

    public Set<String> getServletNames() {
        return this.servletNames;
    }

    @Override
    public Map<String, List<String>> getFilterServletMappings() {
        return this.filterServletNameMappings;
    }
}

