/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.frameworks.parsers.strutsParser;

import com.ibm.appscan.frameworks.parsers.strutsParser.ActionImpl;
import com.ibm.appscan.frameworks.parsers.strutsParser.FormBeanImpl;
import com.ibm.appscan.frameworks.parsers.strutsParser.FormPropertyImpl;
import com.ibm.appscan.frameworks.parsers.strutsParser.ForwardImpl;
import com.ibm.appscan.frameworks.parsers.strutsParser.IAction;
import com.ibm.appscan.frameworks.parsers.strutsParser.IFormBean;
import com.ibm.appscan.frameworks.parsers.strutsParser.IFormProperty;
import com.ibm.appscan.frameworks.parsers.strutsParser.IForward;
import com.ibm.appscan.frameworks.parsers.strutsParser.IPlugin;
import com.ibm.appscan.frameworks.parsers.strutsParser.IStrutsConfigProperty;
import com.ibm.appscan.frameworks.parsers.strutsParser.IStrutsInfo;
import com.ibm.appscan.frameworks.parsers.strutsParser.ParsedExceptionHandler;
import com.ibm.appscan.frameworks.parsers.strutsParser.PluginImpl;
import com.ibm.appscan.frameworks.parsers.strutsParser.StrutsConfigPropertyImpl;
import com.ibm.appscan.frameworks.parsers.strutsParser.StrutsVersion;
import com.ibm.appscan.frameworks.util.DOMParserWithLineNumbers;
import com.ibm.appscan.frameworks.util.FilePositionInfo;
import com.ibm.appscan.frameworks.util.Messages;
import com.ibm.appscan.taint.util.logging.TaintLogger;
import com.ibm.wala.util.collections.HashMapFactory;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class DOMBasedStrutsInfo
implements IStrutsInfo {
    private static final Logger logger = TaintLogger.i().getLogger();
    public static boolean verbose = false;
    private final List<IAction> actions = new ArrayList<IAction>();
    private final List<IFormBean> formBeans = new ArrayList<IFormBean>();
    private final List<IForward> globalForwards = new ArrayList<IForward>();
    private final List<IPlugin> plugins = new ArrayList<IPlugin>();
    private final List<ParsedExceptionHandler> exceptionHandlers = new ArrayList<ParsedExceptionHandler>();
    private final String fileName;
    private StrutsVersion strutsVersion;
    private final Map<String, String> controllerProperties = HashMapFactory.make();

    protected DOMBasedStrutsInfo(String fileName) throws IOException, SAXException {
        this.fileName = fileName;
        DOMParserWithLineNumbers parser = new DOMParserWithLineNumbers(fileName);
        Document document = parser.getDocument();
        this.populate(document);
        if (verbose) {
            logger.info((Object)("Loaded struts configuration file: " + fileName + "\n" + this.toString()));
        }
    }

    @Override
    public List<IAction> getActions() {
        return this.actions;
    }

    @Override
    public List<IFormBean> getFormBeans() {
        return this.formBeans;
    }

    @Override
    public List<IForward> getGlobalForwards() {
        return this.globalForwards;
    }

    @Override
    public List<IPlugin> getPlugins() {
        return this.plugins;
    }

    public static IStrutsInfo getStrutsParser(String strutsConfigPath) throws IOException, SAXException {
        if (verbose) {
            logger.info((Object)("Finding parser for struts configuration file at " + strutsConfigPath));
        }
        return new DOMBasedStrutsInfo(strutsConfigPath);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Struts Parser for " + (Object)((Object)this.strutsVersion) + "\n");
        sb.append("Actions:" + this.actions.size() + "\n");
        sb.append("FormBeans:" + this.formBeans.size() + "\n");
        sb.append("Global Forwards:" + this.globalForwards.size() + "\n");
        sb.append("Plugins:" + this.plugins.size() + "\n");
        return sb.toString();
    }

    public String toDetailString() {
        StringBuffer sb = new StringBuffer(this.toString());
        sb.append("Actions:\n");
        for (IAction action : this.actions) {
            sb.append(action + "\n");
        }
        sb.append("FormBeans:\n");
        for (IFormBean formBean : this.formBeans) {
            sb.append(formBean + "\n");
        }
        sb.append("GlobalForwards:\n");
        for (IForward forward : this.globalForwards) {
            sb.append(forward + "\n");
        }
        sb.append("Plugins:\n");
        for (IPlugin plugin : this.plugins) {
            sb.append(plugin + "\n");
        }
        return sb.toString();
    }

    private void populate(Document doc) {
        try {
            XPathFactory factory = XPathFactory.newInstance();
            XPath xpath = factory.newXPath();
            this.populateActions(doc, xpath);
            this.populateFormBeans(doc, xpath);
            this.populateGlobalForwards(doc, xpath);
            this.populateStrutsVersion(doc);
            this.populatePlugins(doc, xpath);
            this.populateControllerProperties(doc, xpath);
            this.populateExceptionHandlers(doc, xpath);
        }
        catch (XPathExpressionException e) {
            logger.warn((Object)Messages.getString("framework.handler.exception", e.toString() + Messages.getTraceFromException(e)));
        }
    }

    private void populateExceptionHandlers(Document doc, XPath xpath) throws XPathExpressionException {
        XPathExpression actionMappings = xpath.compile("/struts-config/global-exceptions/*");
        Object result = actionMappings.evaluate(doc, XPathConstants.NODESET);
        NodeList nodes = (NodeList)result;
        for (int i = 0; i < nodes.getLength(); ++i) {
            ParsedExceptionHandler excHandler = this.getExceptionHandler(nodes.item(i));
            if (excHandler == null) continue;
            this.exceptionHandlers.add(excHandler);
        }
    }

    private ParsedExceptionHandler getExceptionHandler(Node item) {
        if (item.getNodeName().equals("exception")) {
            if (item.getAttributes() == null) {
                logger.warn((Object)"Found forward with no attributes");
                return null;
            }
            String key = this.getStringAttrValue(item, "key");
            String type = this.getStringAttrValue(item, "type");
            String handler = this.getStringAttrValue(item, "handler");
            if (type == null || handler == null) {
                return null;
            }
            int lineNumber = Integer.valueOf((String)item.getUserData("startLine"));
            int columnNumber = Integer.valueOf((String)item.getUserData("startColumn"));
            return new ParsedExceptionHandler(key, type, handler, FilePositionInfo.make((String)this.fileName, (int)lineNumber, (int)columnNumber));
        }
        return null;
    }

    private void populateControllerProperties(Document doc, XPath xpath) throws XPathExpressionException {
        XPathExpression pluginsXPath = xpath.compile("/struts-config/controller");
        NodeList nodes = (NodeList)pluginsXPath.evaluate(doc, XPathConstants.NODESET);
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node controllerNode = nodes.item(i);
            this.handlePropertiesForControllerNode(controllerNode, xpath);
        }
    }

    private void handlePropertiesForControllerNode(Node controllerNode, XPath xpath) throws XPathExpressionException {
        NodeList nodes = (NodeList)xpath.compile("set-property").evaluate(controllerNode, XPathConstants.NODESET);
        for (int i = 0; i < nodes.getLength(); ++i) {
            IStrutsConfigProperty property = this.getStrutsConfigProperty(nodes.item(i));
            if (property == null) continue;
            this.controllerProperties.put(property.getProperty(), property.getValue());
        }
    }

    private void populateStrutsVersion(Document doc) {
        DocumentType doctype = doc.getDoctype();
        String publicId = doctype.getPublicId();
        if (publicId != null) {
            this.strutsVersion = StrutsVersion.UNKNOWN_GLOBAL;
            if (publicId.startsWith("-//Apache Software Foundation//DTD Struts Configuration 1.3")) {
                this.strutsVersion = StrutsVersion.DTD1_3;
            }
            if (publicId.startsWith("-//Apache Software Foundation//DTD Struts Configuration 1.2")) {
                this.strutsVersion = StrutsVersion.DTD1_2;
            }
            if (publicId.startsWith("-//Apache Software Foundation//DTD Struts Configuration 1.1")) {
                this.strutsVersion = StrutsVersion.DTD1_1;
            }
            if (publicId.startsWith("-//Apache Software Foundation//DTD Struts Configuration 1.0")) {
                this.strutsVersion = StrutsVersion.DTD1_0;
            }
            if (this.strutsVersion.equals((Object)StrutsVersion.UNKNOWN_GLOBAL)) {
                logger.warn((Object)"Can't detect the struts configuration type of alobal struts configuration");
            }
            return;
        }
        String systemId = doctype.getSystemId();
        if (systemId != null) {
            this.strutsVersion = StrutsVersion.UNKNOWN_LOCAL;
            if (systemId.equals("http://struts.apache.org/dtds/struts-config_1_3.dtd")) {
                this.strutsVersion = StrutsVersion.DTD1_3;
            }
            if (systemId.equals("http://struts.apache.org/dtds/struts-config_1_2.dtd")) {
                this.strutsVersion = StrutsVersion.DTD1_2;
            }
            if (systemId.equals("http://struts.apache.org/dtds/struts-config_1_1.dtd")) {
                this.strutsVersion = StrutsVersion.DTD1_1;
            }
            if (systemId.equals("http://struts.apache.org/dtds/struts-config_1_0.dtd")) {
                this.strutsVersion = StrutsVersion.DTD1_0;
            }
            if (systemId.equals("http://jakarta.apache.org/struts/dtds/struts-config_1_3.dtd")) {
                this.strutsVersion = StrutsVersion.DTD1_3;
            }
            if (systemId.equals("http://jakarta.apache.org/struts/dtds/struts-config_1_2.dtd")) {
                this.strutsVersion = StrutsVersion.DTD1_2;
            }
            if (systemId.equals("http://jakarta.apache.org/struts/dtds/struts-config_1_1.dtd")) {
                this.strutsVersion = StrutsVersion.DTD1_1;
            }
            if (systemId.equals("http://jakarta.apache.org/struts/dtds/struts-config_1_0.dtd")) {
                this.strutsVersion = StrutsVersion.DTD1_0;
            }
        } else {
            this.strutsVersion = StrutsVersion.UNKNOWN;
            logger.warn((Object)"Can't detect the struts configuration type. Public and System keys are missing");
        }
    }

    private void populateFormBeans(Document doc, XPath xpath) throws XPathExpressionException {
        XPathExpression formBeansXPath = xpath.compile("/struts-config/form-beans/*");
        NodeList nodes = (NodeList)formBeansXPath.evaluate(doc, XPathConstants.NODESET);
        for (int i = 0; i < nodes.getLength(); ++i) {
            IFormBean formBean = this.getFormBean(nodes.item(i), xpath);
            if (formBean == null) continue;
            this.formBeans.add(formBean);
        }
    }

    private IFormBean getFormBean(Node item, XPath xpath) throws XPathExpressionException {
        if (item.getNodeName().equals("form-bean")) {
            if (item.getAttributes() == null) {
                logger.warn((Object)"Found form bean with no attributes");
                return null;
            }
            List<IFormProperty> formProperties = this.getFormPropertiesFromBean(item, xpath);
            String name = this.getStringAttrValue(item, "name");
            String type = this.getStringAttrValue(item, "type");
            String className = this.getStringAttrValue(item, "className");
            return new FormBeanImpl(className, formProperties, name, type);
        }
        return null;
    }

    private List<IFormProperty> getFormPropertiesFromBean(Node item, XPath xpath) throws XPathExpressionException {
        ArrayList<IFormProperty> result = new ArrayList<IFormProperty>();
        NodeList nodes = (NodeList)xpath.compile("form-property").evaluate(item, XPathConstants.NODESET);
        for (int i = 0; i < nodes.getLength(); ++i) {
            IFormProperty formProperty = this.getFormProperty(nodes.item(i));
            if (formProperty == null) continue;
            result.add(formProperty);
        }
        return result;
    }

    private IFormProperty getFormProperty(Node item) throws XPathExpressionException {
        if (item.getNodeName().equals("form-property")) {
            if (item.getAttributes() == null) {
                logger.warn((Object)"Found form-property with no attributes");
                return null;
            }
            String name = this.getStringAttrValue(item, "name");
            String type = this.getStringAttrValue(item, "type");
            return new FormPropertyImpl(name, type);
        }
        return null;
    }

    private void populateActions(Document doc, XPath xpath) throws XPathExpressionException {
        XPathExpression actionMappings = xpath.compile("/struts-config/action-mappings/*");
        Object result = actionMappings.evaluate(doc, XPathConstants.NODESET);
        NodeList nodes = (NodeList)result;
        for (int i = 0; i < nodes.getLength(); ++i) {
            IAction action = this.getAction(nodes.item(i), xpath);
            if (action == null) continue;
            this.actions.add(action);
        }
    }

    private IAction getAction(Node item, XPath xpath) throws XPathExpressionException {
        if (item.getNodeName().equals("action")) {
            if (item.getAttributes() == null) {
                logger.warn((Object)"Found action with no attributes");
                return null;
            }
            List<IForward> forwards = this.getForwardsFromAction(item, xpath);
            String name = this.getStringAttrValue(item, "name");
            String path = this.getStringAttrValue(item, "path");
            String scope = this.getStringAttrValue(item, "scope");
            String type = this.getStringAttrValue(item, "type");
            String forwardAttr = this.getStringAttrValue(item, "forward");
            String parameter = this.getStringAttrValue(item, "parameter");
            int lineNumber = Integer.valueOf((String)item.getUserData("startLine"));
            int columnNumber = Integer.valueOf((String)item.getUserData("startColumn"));
            return new ActionImpl(name, path, scope, type, forwards, forwardAttr, parameter, FilePositionInfo.make((String)this.fileName, (int)lineNumber, (int)columnNumber));
        }
        return null;
    }

    private List<IForward> getForwardsFromAction(Node item, XPath xpath) throws XPathExpressionException {
        ArrayList<IForward> result = new ArrayList<IForward>();
        NodeList nodes = (NodeList)xpath.compile("forward").evaluate(item, XPathConstants.NODESET);
        for (int i = 0; i < nodes.getLength(); ++i) {
            IForward forward = this.getForward(nodes.item(i));
            if (forward == null) continue;
            result.add(forward);
        }
        return result;
    }

    private void populateGlobalForwards(Document doc, XPath xpath) throws XPathExpressionException {
        XPathExpression actionMappings = xpath.compile("/struts-config/global-forwards/*");
        Object result = actionMappings.evaluate(doc, XPathConstants.NODESET);
        NodeList nodes = (NodeList)result;
        for (int i = 0; i < nodes.getLength(); ++i) {
            IForward forward = this.getForward(nodes.item(i));
            if (forward == null) continue;
            this.globalForwards.add(forward);
        }
    }

    private IForward getForward(Node item) {
        if (item.getNodeName().equals("forward")) {
            if (item.getAttributes() == null) {
                logger.warn((Object)"Found forward with no attributes");
                return null;
            }
            String name = this.getStringAttrValue(item, "name");
            String path = this.getStringAttrValue(item, "path");
            String redirect = this.getStringAttrValue(item, "redirect");
            return new ForwardImpl(name, path, redirect);
        }
        return null;
    }

    private void populatePlugins(Document doc, XPath xpath) throws XPathExpressionException {
        XPathExpression pluginsXPath = xpath.compile("/struts-config/plug-in");
        NodeList nodes = (NodeList)pluginsXPath.evaluate(doc, XPathConstants.NODESET);
        for (int i = 0; i < nodes.getLength(); ++i) {
            IPlugin plugin = this.getPlugin(nodes.item(i), xpath);
            if (plugin == null) continue;
            this.plugins.add(plugin);
        }
    }

    private IPlugin getPlugin(Node item, XPath xpath) throws XPathExpressionException {
        if (item.getNodeName().equals("plug-in")) {
            if (item.getAttributes() == null) {
                logger.warn((Object)"Found plug-in with no attributes");
                return null;
            }
            List<IStrutsConfigProperty> pluginProperties = this.getPluginProperties(item, xpath);
            String className = this.getStringAttrValue(item, "className");
            return new PluginImpl(className, pluginProperties);
        }
        return null;
    }

    private List<IStrutsConfigProperty> getPluginProperties(Node item, XPath xpath) throws XPathExpressionException {
        ArrayList<IStrutsConfigProperty> result = new ArrayList<IStrutsConfigProperty>();
        NodeList nodes = (NodeList)xpath.compile("set-property").evaluate(item, XPathConstants.NODESET);
        for (int i = 0; i < nodes.getLength(); ++i) {
            IStrutsConfigProperty pluginProperty = this.getStrutsConfigProperty(nodes.item(i));
            if (pluginProperty == null) continue;
            result.add(pluginProperty);
        }
        return result;
    }

    private IStrutsConfigProperty getStrutsConfigProperty(Node item) {
        if (item.getNodeName().equals("set-property")) {
            if (item.getAttributes() == null) {
                logger.warn((Object)"Found plugin set-property with no attributes");
                return null;
            }
            String property = this.getStringAttrValue(item, "property");
            String value = this.getStringAttrValue(item, "value");
            return new StrutsConfigPropertyImpl(property, value);
        }
        return null;
    }

    private String getStringAttrValue(Node item, String attrName) {
        Node value = item.getAttributes().getNamedItem(attrName);
        return value == null ? null : value.getNodeValue();
    }

    @Override
    public StrutsVersion getStrutsVersion() {
        return this.strutsVersion;
    }

    @Override
    public String getTilesConfigurationPath() {
        for (IPlugin plugin : this.plugins) {
            if (!plugin.getClassName().equals("org.apache.struts.tiles.TilesPlugin")) continue;
            List<IStrutsConfigProperty> properties = plugin.getProperties();
            for (IStrutsConfigProperty prop : properties) {
                if (!prop.getProperty().equals("definitions-config")) continue;
                return prop.getValue();
            }
            logger.warn((Object)"Found tiles configuration without path");
        }
        return null;
    }

    @Override
    public List<String> getValidationConfigurationPath() {
        ArrayList<String> result = new ArrayList<String>();
        for (IPlugin plugin : this.plugins) {
            if (!plugin.getClassName().equals("org.apache.struts.validator.ValidatorPlugIn")) continue;
            List<IStrutsConfigProperty> properties = plugin.getProperties();
            for (IStrutsConfigProperty prop : properties) {
                if (!prop.getProperty().equals("pathnames")) continue;
                for (String s : prop.getValue().split(",")) {
                    result.add(s.trim());
                }
                return result;
            }
            logger.warn((Object)"Found tiles configuration without path");
        }
        return result;
    }

    @Override
    public Map<String, String> getControllerProperties() {
        return this.controllerProperties;
    }

    @Override
    public List<ParsedExceptionHandler> getExceptionHandlers() {
        return this.exceptionHandlers;
    }
}

