/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.frameworks.util;

import com.ibm.appscan.frameworks.analyzers.generic.LangIndependentWalaUtil;
import com.ibm.appscan.frameworks.util.MethodAndCallSiteReference;
import com.ibm.appscan.frameworks.util.VDBJavaUtil;
import com.ibm.wala.classLoader.CallSiteReference;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IClassLoader;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.classLoader.JarFileModule;
import com.ibm.wala.classLoader.Module;
import com.ibm.wala.ipa.callgraph.AnalysisCache;
import com.ibm.wala.ipa.callgraph.AnalysisOptions;
import com.ibm.wala.ipa.callgraph.AnalysisScope;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.CallGraph;
import com.ibm.wala.ipa.callgraph.Context;
import com.ibm.wala.ipa.callgraph.impl.AbstractRootMethod;
import com.ibm.wala.ipa.callgraph.impl.DefaultEntrypoint;
import com.ibm.wala.ipa.callgraph.impl.Everywhere;
import com.ibm.wala.ipa.callgraph.impl.ExplicitCallGraph;
import com.ibm.wala.ipa.callgraph.propagation.cfa.DefaultSSAInterpreter;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.ssa.IR;
import com.ibm.wala.ssa.SSAAbstractInvokeInstruction;
import com.ibm.wala.types.ClassLoaderReference;
import com.ibm.wala.types.MethodReference;
import com.ibm.wala.types.Selector;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.CancelException;
import com.ibm.wala.util.Predicate;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.collections.Iterator2Iterable;
import com.ibm.wala.util.collections.Util;
import com.ibm.wala.util.intset.IntSet;
import com.ibm.wala.util.strings.StringStuff;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.jar.JarFile;

public class WalaUtil {
    public static MethodReference getResolvedMethodReference(String className, String selectorStr, IClassHierarchy cha) {
        MethodReference unresolvedMethodRef = WalaUtil.getUnresolvedMethodRef(className, selectorStr);
        return WalaUtil.resolveMethodRef(unresolvedMethodRef, cha);
    }

    public static MethodReference getResolvedMethodReference(String methodSig, IClassHierarchy cha) {
        MethodReference unresolvedMethodRef = StringStuff.makeMethodReference((String)methodSig);
        return WalaUtil.resolveMethodRef(unresolvedMethodRef, cha);
    }

    public static MethodReference getUnresolvedMethodRef(String className, String selectorStr) {
        TypeReference declaringClassRef = WalaUtil.createTypeRefForJavaClassName(className);
        Selector selector = Selector.make((String)selectorStr);
        MethodReference unresolvedMethodRef = MethodReference.findOrCreate((TypeReference)declaringClassRef, (Selector)selector);
        return unresolvedMethodRef;
    }

    public static TypeReference createTypeRefForJavaClassName(String className) {
        return TypeReference.findOrCreate((ClassLoaderReference)ClassLoaderReference.Application, (String)StringStuff.deployment2CanonicalTypeString((String)className));
    }

    public static MethodReference resolveMethodRef(MethodReference methodRef, IClassHierarchy cha) {
        IMethod resolvedMethod = cha.resolveMethod(methodRef);
        if (resolvedMethod == null) {
            throw new IllegalStateException("can't resolve ref to " + methodRef);
        }
        return resolvedMethod.getReference();
    }

    public static TypeReference resolveTypeRef(TypeReference declaringClassRef, IClassHierarchy cha) {
        IClass declaringClass = cha.lookupClass(declaringClassRef);
        if (declaringClass == null) {
            throw new IllegalStateException("Can't resolve reference to " + declaringClassRef);
        }
        TypeReference resolvedDecClassRef = declaringClass.getReference();
        return resolvedDecClassRef;
    }

    public static Collection<MethodAndCallSiteReference> getMatchingCallSites(IClass klass, MethodReference methodsOfInterest, AnalysisCache cache, IClassHierarchy cha) {
        return WalaUtil.getMatchingCallSites(klass, Collections.singleton(methodsOfInterest), cache, cha);
    }

    public static Collection<MethodAndCallSiteReference> getMatchingCallSites(IClass klass, Collection<MethodReference> methodsOfInterest, AnalysisCache cache, IClassHierarchy cha) {
        HashSet result = HashSetFactory.make();
        for (IMethod method : klass.getAllMethods()) {
            IR ir = LangIndependentWalaUtil.getIR((IMethod)method, (AnalysisCache)cache);
            if (ir == null) continue;
            Iterator siteIter = ir.iterateCallSites();
            while (siteIter.hasNext()) {
                CallSiteReference callSite = (CallSiteReference)siteIter.next();
                MethodReference declaredTarget = callSite.getDeclaredTarget();
                if (!WalaUtil.containsMethodWithSignature(methodsOfInterest, declaredTarget.getSignature())) continue;
                result.add(new MethodAndCallSiteReference(method, callSite));
            }
        }
        return result;
    }

    private static boolean containsMethodWithSignature(Collection<MethodReference> methods, final String signature) {
        return Util.forSome(methods, (Predicate)new Predicate<MethodReference>(){

            public boolean test(MethodReference t) {
                return t.getSignature().equals(signature);
            }
        });
    }

    public static MethodReference getResolvedTarget(CallSiteReference callSite, IClassHierarchy cha) {
        MethodReference declaredTarget = callSite.getDeclaredTarget();
        TypeReference resolvedDecClassRef = WalaUtil.resolveTypeRef(declaredTarget.getDeclaringClass(), cha);
        return MethodReference.findOrCreate((TypeReference)resolvedDecClassRef, (Selector)declaredTarget.getSelector());
    }

    public static SSAAbstractInvokeInstruction getSingleInstructionForCallSite(CallSiteReference site, IR ir) {
        IntSet callInstructionIndices = ir.getCallInstructionIndices(site);
        assert (callInstructionIndices.size() == 1);
        int callInstIndex = callInstructionIndices.intIterator().next();
        return (SSAAbstractInvokeInstruction)ir.getInstructions()[callInstIndex];
    }

    public static int paramIndexToVn(SSAAbstractInvokeInstruction invoke, int paramIndex) {
        if (paramIndex == -1) {
            return invoke.getDef();
        }
        return invoke.getUse(paramIndex);
    }

    public static boolean isApplicationClassLoader(IClassLoader loader, IClassHierarchy cha) {
        return cha.getScope().isApplicationLoader(loader);
    }

    public static Set<String> getApplicationClassesNames(IClassHierarchy cha) {
        HashSet result = HashSetFactory.make();
        for (IClassLoader loader : cha.getLoaders()) {
            if (!loader.getReference().equals((Object)ClassLoaderReference.Application)) continue;
            Iterator iter = loader.iterateAllClasses();
            while (iter.hasNext()) {
                IClass klass = (IClass)iter.next();
                result.add(StringStuff.jvmToReadableType((String)klass.getName().toString()));
            }
        }
        return result;
    }

    public static int getSourceLine(IMethod m, CallSiteReference callSiteRef) {
        return m.getLineNumber(callSiteRef.getProgramCounter());
    }

    public static InputStream getResource(AnalysisScope r, String name) throws IOException {
        String resourceName = name;
        if (name.startsWith("/")) {
            resourceName = name.substring(1);
        }
        for (Module M : r.getModules(r.getExtensionLoader())) {
            JarFile JF;
            if (!(M instanceof JarFileModule) || (JF = ((JarFileModule)M).getJarFile()).getEntry(resourceName) == null) continue;
            return JF.getInputStream(JF.getEntry(resourceName));
        }
        return null;
    }

    public static CallGraph buildCallGraphForClass(IClass klass, AnalysisOptions options, AnalysisCache cache) {
        ExplicitCallGraph result;
        IClassHierarchy cha;
        block7: {
            cha = klass.getClassHierarchy();
            result = new ExplicitCallGraph(cha, options, cache);
            result.setInterpreter((Object)new DefaultSSAInterpreter(options, cache));
            try {
                result.init();
            }
            catch (CancelException e) {
                if ($assertionsDisabled) break block7;
                throw new AssertionError();
            }
        }
        HashSet entrypoints = HashSetFactory.make();
        for (IMethod m : klass.getDeclaredMethods()) {
            IR ir;
            ExplicitCallGraph.ExplicitNode node = WalaUtil.getCGNode(result, m);
            if (m.isPublic()) {
                result.registerEntrypoint((CGNode)node);
                entrypoints.add(m);
            }
            if ((ir = LangIndependentWalaUtil.getIR((IMethod)m, (AnalysisCache)cache)) == null) continue;
            for (CallSiteReference site : Iterator2Iterable.make((Iterator)ir.iterateCallSites())) {
                MethodReference declaredTarget = site.getDeclaredTarget();
                for (IMethod target : cha.getPossibleTargets(declaredTarget)) {
                    if (!target.getDeclaringClass().equals(klass)) continue;
                    ExplicitCallGraph.ExplicitNode targetNode = WalaUtil.getCGNode(result, target);
                    node.addTarget(site, (CGNode)targetNode);
                }
            }
        }
        for (IMethod entry : entrypoints) {
            ExplicitCallGraph.ExplicitNode entryNode = WalaUtil.getCGNode(result, entry);
            DefaultEntrypoint entrypoint = new DefaultEntrypoint(entry, cha);
            ExplicitCallGraph.ExplicitNode fakeRootNode = (ExplicitCallGraph.ExplicitNode)result.getFakeRootNode();
            SSAAbstractInvokeInstruction call = entrypoint.addCall((AbstractRootMethod)fakeRootNode.getMethod());
            fakeRootNode.addTarget(call.getCallSite(), (CGNode)entryNode);
        }
        return result;
    }

    private static ExplicitCallGraph.ExplicitNode getCGNode(ExplicitCallGraph result, IMethod m) {
        ExplicitCallGraph.ExplicitNode node;
        block2: {
            node = null;
            try {
                node = (ExplicitCallGraph.ExplicitNode)result.findOrCreateNode(m, (Context)Everywhere.EVERYWHERE);
            }
            catch (CancelException e) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError();
            }
        }
        return node;
    }

    public static String method2ResolvedVDBSignature(IMethod m) {
        return VDBJavaUtil.jvmToVDBSignature(m.getSignature());
    }

    public static MethodReference getMethodRefFromVDBSig(String vdbMethodSig) {
        return StringStuff.makeMethodReference((String)VDBJavaUtil.vdb2JVMSignature(vdbMethodSig));
    }
}

