/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.shrike.cg;

import com.ibm.wala.shrike.cg.Runtime;
import com.ibm.wala.shrikeBT.ConstantInstruction;
import com.ibm.wala.shrikeBT.Disassembler;
import com.ibm.wala.shrikeBT.IInvokeInstruction;
import com.ibm.wala.shrikeBT.LoadInstruction;
import com.ibm.wala.shrikeBT.MethodData;
import com.ibm.wala.shrikeBT.MethodEditor;
import com.ibm.wala.shrikeBT.ReturnInstruction;
import com.ibm.wala.shrikeBT.ThrowInstruction;
import com.ibm.wala.shrikeBT.Util;
import com.ibm.wala.shrikeBT.analysis.Analyzer;
import com.ibm.wala.shrikeBT.analysis.ClassHierarchyStore;
import com.ibm.wala.shrikeBT.analysis.Verifier;
import com.ibm.wala.shrikeBT.shrikeCT.CTUtils;
import com.ibm.wala.shrikeBT.shrikeCT.ClassInstrumenter;
import com.ibm.wala.shrikeBT.shrikeCT.OfflineInstrumenter;
import com.ibm.wala.shrikeCT.ClassReader;
import com.ibm.wala.shrikeCT.ClassWriter;
import com.ibm.wala.shrikeCT.ConstantPoolParser;
import com.ibm.wala.shrikeCT.InvalidClassFileException;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.config.FileOfClasses;
import com.ibm.wala.util.config.SetOfClasses;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.lang.reflect.Modifier;
import java.util.Map;

public class OfflineDynamicCallGraph {
    private static final boolean disasm = true;
    private static final boolean verify = true;
    private static boolean patchExits = true;
    private static boolean patchCalls = false;
    private static Class<?> runtime = Runtime.class;
    private static SetOfClasses filter;
    private static ClassHierarchyStore cha;

    public static void main(String[] args) throws IOException, ClassNotFoundException, InvalidClassFileException, Analyzer.FailureException {
        ClassInstrumenter ci;
        BufferedWriter w = new BufferedWriter(new FileWriter("report", false));
        for (int i = 0; i < args.length - 1; ++i) {
            if ("--runtime".equals(args[i])) {
                runtime = Class.forName(args[i + 1]);
                continue;
            }
            if ("--exclusions".equals(args[i])) {
                filter = new FileOfClasses((InputStream)new FileInputStream(args[i + 1]));
                continue;
            }
            if ("--dont-patch-exits".equals(args[i])) {
                patchExits = false;
                continue;
            }
            if ("--patch-calls".equals(args[i])) {
                patchCalls = true;
                continue;
            }
            if (!"--rt-jar".equals(args[i])) continue;
            System.err.println("using " + args[i + 1] + " as stdlib");
            OfflineInstrumenter libReader = new OfflineInstrumenter(true);
            libReader.addInputJar(new File(args[i + 1]));
            while ((ci = libReader.nextClass()) != null) {
                CTUtils.addClassToHierarchy(cha, ci.getReader());
            }
        }
        OfflineInstrumenter instrumenter = new OfflineInstrumenter(true);
        args = instrumenter.parseStandardArgs(args);
        instrumenter.setPassUnmodifiedClasses(true);
        instrumenter.beginTraversal();
        while ((ci = instrumenter.nextClass()) != null) {
            CTUtils.addClassToHierarchy(cha, ci.getReader());
        }
        instrumenter.setClassHierarchyProvider(cha);
        instrumenter.beginTraversal();
        while ((ci = instrumenter.nextClass()) != null) {
            ClassWriter cw = OfflineDynamicCallGraph.doClass(ci, w);
            if (cw == null) continue;
            instrumenter.outputModifiedClass(ci, cw);
        }
        instrumenter.close();
    }

    static ClassWriter doClass(ClassInstrumenter ci, Writer w) throws InvalidClassFileException, IOException, Analyzer.FailureException {
        String className = ci.getReader().getName();
        if (filter != null && filter.contains(className)) {
            return null;
        }
        w.write("Class: " + className + "\n");
        w.flush();
        final ClassReader r = ci.getReader();
        for (int m = 0; m < ci.getReader().getMethodCount(); ++m) {
            MethodData d = ci.visitMethod(m);
            if (d == null) continue;
            if (filter != null && filter.contains(className + "." + ci.getReader().getMethodName(m))) {
                return null;
            }
            w.write("Instrumenting " + ci.getReader().getMethodName(m) + " " + ci.getReader().getMethodType(m) + ":\n");
            w.write("Initial ShrikeBT code:\n");
            new Disassembler(d).disassembleTo(w);
            w.flush();
            Verifier v = new Verifier(d);
            v.verify();
            MethodEditor me = new MethodEditor(d);
            me.beginPass();
            final String theClass = r.getName();
            final String theMethod = r.getMethodName(m).concat(r.getMethodType(m));
            final boolean isConstructor = theMethod.contains("<init>");
            final boolean nonStatic = !Modifier.isStatic(r.getMethodAccessFlags(m));
            me.insertAtStart(new MethodEditor.Patch(){

                @Override
                public void emitTo(MethodEditor.Output w) {
                    w.emit(ConstantInstruction.makeString(theClass));
                    w.emit(ConstantInstruction.makeString(theMethod));
                    if (nonStatic && !isConstructor) {
                        w.emit(LoadInstruction.make("Ljava/lang/Object;", 0));
                    } else {
                        w.emit(Util.makeGet(runtime, "NULL_TAG"));
                    }
                    w.emit(Util.makeInvoke(runtime, "execution", new Class[]{String.class, String.class, Object.class}));
                }
            });
            if (patchExits) {
                me.addMethodExceptionHandler(null, new MethodEditor.Patch(){

                    @Override
                    public void emitTo(MethodEditor.Output w) {
                        w.emit(ConstantInstruction.makeString(theClass));
                        w.emit(ConstantInstruction.makeString(theMethod));
                        w.emit(Util.makeGet(runtime, "NULL_TAG"));
                        w.emit(ConstantInstruction.make(1));
                        w.emit(Util.makeInvoke(runtime, "termination", new Class[]{String.class, String.class, Object.class, Boolean.TYPE}));
                        w.emit(ThrowInstruction.make(false));
                    }
                });
                me.visitInstructions(new MethodEditor.Visitor(){

                    @Override
                    public void visitReturn(ReturnInstruction instruction) {
                        this.insertBefore(new MethodEditor.Patch(){

                            @Override
                            public void emitTo(MethodEditor.Output w) {
                                w.emit(ConstantInstruction.makeString(theClass));
                                w.emit(ConstantInstruction.makeString(theMethod));
                                if (nonStatic) {
                                    w.emit(LoadInstruction.make("Ljava/lang/Object;", 0));
                                } else {
                                    w.emit(Util.makeGet(runtime, "NULL_TAG"));
                                }
                                w.emit(ConstantInstruction.make(0));
                                w.emit(Util.makeInvoke(runtime, "termination", new Class[]{String.class, String.class, Object.class, Boolean.TYPE}));
                            }
                        });
                    }
                });
            }
            if (patchCalls) {
                me.visitInstructions(new MethodEditor.Visitor(){

                    @Override
                    public void visitThrow(ThrowInstruction instruction) {
                        this.insertBefore(new MethodEditor.Patch(){

                            @Override
                            public void emitTo(MethodEditor.Output w) {
                                w.emit(ConstantInstruction.makeString(theClass));
                                w.emit(ConstantInstruction.makeString(theMethod));
                                if (nonStatic) {
                                    w.emit(LoadInstruction.make("Ljava/lang/Object;", 0));
                                } else {
                                    w.emit(Util.makeGet(runtime, "NULL_TAG"));
                                }
                                w.emit(ConstantInstruction.make(1));
                                w.emit(Util.makeInvoke(runtime, "termination", new Class[]{String.class, String.class, Object.class, Boolean.TYPE}));
                            }
                        });
                    }

                    @Override
                    public void visitInvoke(IInvokeInstruction inv) {
                        final String calleeClass = inv.getClassType();
                        final String calleeMethod = inv.getMethodName() + inv.getMethodSignature();
                        this.addInstructionExceptionHandler(null, new MethodEditor.Patch(){

                            @Override
                            public void emitTo(MethodEditor.Output w) {
                                w.emit(ConstantInstruction.makeString(calleeClass));
                                w.emit(ConstantInstruction.makeString(calleeMethod));
                                w.emit(Util.makeInvoke(runtime, "pop", new Class[]{String.class, String.class}));
                                w.emit(ThrowInstruction.make(true));
                            }
                        });
                        this.insertBefore(new MethodEditor.Patch(){

                            @Override
                            public void emitTo(MethodEditor.Output w) {
                                w.emit(ConstantInstruction.makeString(calleeClass));
                                w.emit(ConstantInstruction.makeString(calleeMethod));
                                w.emit(Util.makeGet(runtime, "NULL_TAG"));
                                w.emit(Util.makeInvoke(runtime, "addToCallStack", new Class[]{String.class, String.class, Object.class}));
                            }
                        });
                        this.insertAfter(new MethodEditor.Patch(){

                            @Override
                            public void emitTo(MethodEditor.Output w) {
                                w.emit(ConstantInstruction.makeString(calleeClass));
                                w.emit(ConstantInstruction.makeString(calleeMethod));
                                w.emit(Util.makeInvoke(runtime, "pop", new Class[]{String.class, String.class}));
                            }
                        });
                    }
                });
            }
            me.applyPatches();
            w.write("Final ShrikeBT code:\n");
            new Disassembler(d).disassembleTo(w);
            w.flush();
            Verifier v2 = new Verifier(d);
            v2.verify();
        }
        if (ci.isChanged()) {
            ClassWriter cw = new ClassWriter(){
                private final Map<Object, Integer> entries = HashMapFactory.make();
                {
                    ConstantPoolParser p = r.getCP();
                    block9: for (int i = 1; i < p.getItemCount(); ++i) {
                        switch (p.getItemType(i)) {
                            case 3: {
                                this.entries.put(new Integer(p.getCPInt(i)), i);
                                continue block9;
                            }
                            case 5: {
                                this.entries.put(new Long(p.getCPLong(i)), i);
                                continue block9;
                            }
                            case 4: {
                                this.entries.put(new Float(p.getCPFloat(i)), i);
                                continue block9;
                            }
                            case 6: {
                                this.entries.put(new Double(p.getCPDouble(i)), i);
                                continue block9;
                            }
                            case 1: {
                                this.entries.put(p.getCPUtf8(i), i);
                                continue block9;
                            }
                            case 8: {
                                this.entries.put(new ClassWriter.CWStringItem(p.getCPString(i), 8), i);
                                continue block9;
                            }
                            case 7: {
                                this.entries.put(new ClassWriter.CWStringItem(p.getCPClass(i), 7), i);
                                continue block9;
                            }
                        }
                    }
                }

                private int findExistingEntry(Object o) {
                    if (this.entries.containsKey(o)) {
                        return this.entries.get(o);
                    }
                    return -1;
                }

                @Override
                protected int addCPEntry(Object o, int size) {
                    int entry = this.findExistingEntry(o);
                    if (entry != -1) {
                        return entry;
                    }
                    return super.addCPEntry(o, size);
                }
            };
            ci.emitClass(cw);
            return cw;
        }
        return null;
    }

    static {
        cha = new ClassHierarchyStore();
    }
}

