/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.shrikeBT.shrikeCT;

import com.ibm.wala.shrikeBT.Util;
import com.ibm.wala.shrikeBT.shrikeCT.ClassInstrumenter;
import com.ibm.wala.shrikeBT.tools.OfflineInstrumenterBase;
import com.ibm.wala.shrikeCT.ClassWriter;
import com.ibm.wala.shrikeCT.InvalidClassFileException;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.OutputStream;

public final class OfflineInstrumenter
extends OfflineInstrumenterBase {
    private final boolean reuseStackMaps;

    public OfflineInstrumenter(boolean reuseStackMaps) {
        this.reuseStackMaps = reuseStackMaps;
    }

    @Override
    protected Object makeClassFromStream(String inputName, BufferedInputStream s) throws IOException {
        byte[] bytes = new byte[s.available()];
        Util.readFully(s, bytes);
        try {
            return new ClassInstrumenter(inputName, bytes, this.cha, this.reuseStackMaps);
        }
        catch (InvalidClassFileException e) {
            throw new IOException("Class is invalid: " + e.getMessage());
        }
    }

    @Override
    protected String getClassName(Object cl) {
        try {
            return ((ClassInstrumenter)cl).getReader().getName().replace('/', '.');
        }
        catch (InvalidClassFileException e) {
            return null;
        }
    }

    @Override
    protected void writeClassTo(Object cl, Object mods, OutputStream s) throws IOException {
        ClassInstrumenter ci = (ClassInstrumenter)cl;
        ClassWriter cw = (ClassWriter)mods;
        if (cw == null) {
            s.write(ci.getReader().getBytes());
        } else {
            s.write(cw.makeBytes());
        }
    }

    public ClassInstrumenter nextClass() throws IOException {
        return (ClassInstrumenter)this.internalNextClass();
    }

    public void outputModifiedClass(ClassInstrumenter out, ClassWriter code) throws IllegalStateException, IOException {
        this.internalOutputModifiedClass(out, out.getInputName(), code);
    }

    public void outputModifiedClass(ClassInstrumenter out) throws IllegalArgumentException, IOException {
        if (out == null) {
            throw new IllegalArgumentException();
        }
        try {
            this.internalOutputModifiedClass(out, out.getInputName(), out.emitClass());
        }
        catch (InvalidClassFileException e) {
            e.printStackTrace();
            throw new IOException("Invalid class file");
        }
    }
}

