/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.util.collections;

import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.collections.MultiMap;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;

abstract class AbstractMultiMap<K, V>
implements MultiMap<K, V> {
    protected final Map<K, Set<V>> map = HashMapFactory.make();
    protected final boolean create;

    protected AbstractMultiMap(boolean create) {
        this.create = create;
    }

    protected abstract Set<V> createSet();

    protected Set<V> emptySet() {
        return Collections.emptySet();
    }

    @Override
    public Set<V> get(K key) {
        Set<V> ret = this.map.get(key);
        if (ret == null) {
            if (this.create) {
                ret = this.createSet();
                this.map.put(key, ret);
            } else {
                ret = this.emptySet();
            }
        }
        return ret;
    }

    @Override
    public boolean put(K key, V val) {
        Set<V> vals = this.map.get(key);
        if (vals == null) {
            vals = this.createSet();
            this.map.put(key, vals);
        }
        return vals.add(val);
    }

    @Override
    public boolean remove(K key, V val) {
        Set<V> elems = this.map.get(key);
        if (elems == null) {
            return false;
        }
        boolean ret = elems.remove(val);
        if (elems.isEmpty()) {
            this.map.remove(key);
        }
        return ret;
    }

    @Override
    public Set<V> removeAll(K key) {
        return this.map.remove(key);
    }

    @Override
    public Set<K> keySet() {
        return this.map.keySet();
    }

    @Override
    public boolean containsKey(K key) {
        return this.map.containsKey(key);
    }

    @Override
    public int size() {
        int ret = 0;
        for (K key : this.keySet()) {
            ret += this.get(key).size();
        }
        return ret;
    }

    @Override
    public String toString() {
        return this.map.toString();
    }

    @Override
    public boolean putAll(K key, Collection<? extends V> vals) {
        Set<V> edges = this.map.get(key);
        if (edges == null) {
            edges = this.createSet();
            this.map.put(key, edges);
        }
        return edges.addAll(vals);
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }
}

