/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.util.collections;

import com.ibm.wala.util.collections.IVector;
import java.util.ArrayList;
import java.util.Iterator;

public class SimpleVector<T>
implements IVector<T> {
    private static final int MAX_SIZE = 0x1FFFFFFF;
    private static final double GROWTH_FACTOR = 1.5;
    Object[] store = new Object[1];
    int maxIndex = -1;

    @Override
    public T get(int x) {
        if (x < 0) {
            throw new IllegalArgumentException("illegal x: " + x);
        }
        if (x < this.store.length) {
            return (T)this.store[x];
        }
        return null;
    }

    @Override
    public void set(int x, T value) {
        if (x < 0) {
            throw new IllegalArgumentException("illegal x value " + x);
        }
        if (x > 0x1FFFFFFF) {
            throw new IllegalArgumentException("x is too big: " + x);
        }
        this.maxIndex = Math.max(this.maxIndex, x);
        if (value == null) {
            if (x >= this.store.length) {
                return;
            }
            this.store[x] = null;
        } else {
            this.ensureCapacity(x);
            this.store[x] = value;
        }
    }

    private void ensureCapacity(int capacity) {
        if (capacity >= this.store.length) {
            Object[] old = this.store;
            this.store = new Object[1 + (int)(1.5 * (double)capacity)];
            System.arraycopy(old, 0, this.store, 0, old.length);
        }
    }

    @Override
    public void performVerboseAction() {
        System.err.println("size:       " + this.store.length);
        System.err.println("occupancy:  " + this.computeOccupancy());
    }

    private double computeOccupancy() {
        int count = 0;
        for (int i = 0; i < this.store.length; ++i) {
            if (this.store[i] == null) continue;
            ++count;
        }
        return (double)count / (double)this.store.length;
    }

    @Override
    public Iterator<T> iterator() {
        ArrayList<Object> result = new ArrayList<Object>();
        for (int i = 0; i <= this.maxIndex; ++i) {
            result.add(this.store[i]);
        }
        return result.iterator();
    }

    @Override
    public int getMaxIndex() {
        return this.maxIndex;
    }
}

