/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.util.graph;

import com.ibm.wala.util.intset.SimpleIntVector;

public class Path
extends SimpleIntVector {
    final int size;

    private Path(int defaultValue, int size) {
        super(defaultValue, size);
        this.size = size;
    }

    public static Path make(int value) {
        return new Path(value, 1);
    }

    public static Path prepend(int x, Path p) {
        if (p == null) {
            throw new IllegalArgumentException("null p");
        }
        Path result = new Path(0, p.size + 1);
        result.set(0, x);
        for (int i = 0; i < p.size; ++i) {
            result.set(i + 1, p.get(i));
        }
        return result;
    }

    public int hashCode() {
        int result = 7;
        for (int i = 0; i < this.size; ++i) {
            result += 31 * (this.get(i) + 1);
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Path) {
            Path other = (Path)obj;
            if (this.size == other.size) {
                for (int i = 0; i < this.size; ++i) {
                    if (this.get(i) == other.get(i)) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
        return false;
    }

    public int size() {
        return this.size;
    }

    public String toString() {
        StringBuffer result = new StringBuffer("[");
        for (int i = 0; i < this.size; ++i) {
            result.append(this.get(i));
            if (i >= this.size - 1) continue;
            result.append(",");
        }
        result.append("]");
        return result.toString();
    }
}

