/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.util.graph.traverse;

import com.ibm.wala.util.Predicate;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.collections.NonNullSingletonIterator;
import com.ibm.wala.util.graph.Graph;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class BFSPathFinder<T> {
    private final boolean DEBUG = false;
    private final Graph<T> G;
    private final Predicate<T> filter;
    private final Iterator<T> roots;

    public BFSPathFinder(Graph<T> G, T N, Predicate<T> f) {
        if (G == null) {
            throw new IllegalArgumentException("G is null");
        }
        if (f == null) {
            throw new IllegalArgumentException("null f");
        }
        this.G = G;
        this.roots = new NonNullSingletonIterator<T>(N);
        this.filter = f;
    }

    public BFSPathFinder(Graph<T> G, T src, final T target) throws IllegalArgumentException {
        if (G == null) {
            throw new IllegalArgumentException("G is null");
        }
        this.G = G;
        this.roots = new NonNullSingletonIterator<T>(src);
        if (!G.containsNode(src)) {
            throw new IllegalArgumentException("src is not in graph " + src);
        }
        this.filter = new Predicate<T>(){

            @Override
            public boolean test(T o) {
                return target.equals(o);
            }
        };
    }

    public BFSPathFinder(Graph<T> G, T src, Iterator<T> targets) {
        if (targets == null) {
            throw new IllegalArgumentException("targets is null");
        }
        final HashSet ts = HashSetFactory.make();
        while (targets.hasNext()) {
            ts.add(targets.next());
        }
        this.G = G;
        this.roots = new NonNullSingletonIterator<T>(src);
        this.filter = new Predicate<T>(){

            @Override
            public boolean test(T o) {
                return ts.contains(o);
            }
        };
    }

    public BFSPathFinder(Graph<T> G, Iterator<T> sources, final T target) {
        if (G == null) {
            throw new IllegalArgumentException("G is null");
        }
        if (sources == null) {
            throw new IllegalArgumentException("sources is null");
        }
        this.G = G;
        this.roots = sources;
        this.filter = new Predicate<T>(){

            @Override
            public boolean test(T o) {
                return target.equals(o);
            }
        };
    }

    public BFSPathFinder(Graph<T> G, Iterator<T> nodes, Predicate<T> f) {
        this.G = G;
        this.roots = nodes;
        this.filter = f;
        if (G == null) {
            throw new IllegalArgumentException("G is null");
        }
        if (this.roots == null) {
            throw new IllegalArgumentException("roots is null");
        }
    }

    public List<T> find() {
        LinkedList<Object> Q = new LinkedList<Object>();
        HashMap history = HashMapFactory.make();
        while (this.roots.hasNext()) {
            T next = this.roots.next();
            Q.addLast(next);
            history.put(next, null);
        }
        while (!Q.isEmpty()) {
            Object N = Q.removeFirst();
            if (this.filter.test(N)) {
                return this.makePath(N, history);
            }
            Iterator children = this.getConnected(N);
            while (children.hasNext()) {
                Object c = children.next();
                if (history.containsKey(c)) continue;
                Q.addLast(c);
                history.put(c, N);
            }
        }
        return null;
    }

    private List<T> makePath(T node, Map<Object, T> history) {
        ArrayList<T> result = new ArrayList<T>();
        T n = node;
        result.add(n);
        T parent;
        while ((parent = history.get(n)) != null) {
            result.add(parent);
            n = parent;
        }
        return result;
    }

    protected Iterator<? extends T> getConnected(T n) {
        return this.G.getSuccNodes(n);
    }
}

