/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.util.heapTrace;

import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.collections.Pair;
import com.ibm.wala.util.debug.Assertions;
import java.io.File;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.TreeSet;

public class HeapTracer {
    private static final boolean DEBUG = false;
    private static final String[] rootClasses = HeapTracer.generateRootClassesFromWorkspace();
    private final Collection<?> rootInstances;
    private final Stack<Object> scalarWorkList = new Stack();
    private final Stack<Object> arrayWorkList = new Stack();
    private static final int BYTES_IN_HEADER = 12;
    private final boolean traceStatics;
    private final HashMap<Class<?>, Integer> sizeMap = HashMapFactory.make();
    private static final Object DUMMY = new Object();
    private static final HashSet<Class<?>> internalClasses = HashSetFactory.make();
    private final Object OK = new Object();
    private final Object BAD = new Object();
    private final HashMap<Package, Object> packageStatus = HashMapFactory.make();
    private final HashMap<Class<?>, Field[]> allReferenceFieldsCache = HashMapFactory.make();

    HeapTracer(boolean traceStatics) {
        this.rootInstances = Collections.emptySet();
        this.traceStatics = traceStatics;
    }

    public HeapTracer(Collection<?> c, boolean traceStatics) {
        this.rootInstances = c;
        this.traceStatics = traceStatics;
    }

    public static void main(String[] args) {
        try {
            Result r = new HeapTracer(true).perform();
            System.err.println(r.toString());
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    private static String[] generateRootClassesFromWorkspace() {
        String classpath = System.getProperty("java.class.path");
        Object[] binDirectories = HeapTracer.extractBinDirectories(classpath);
        HashSet classFileNames = HashSetFactory.make();
        for (int i = 0; i < binDirectories.length; ++i) {
            String dir = (String)binDirectories[i];
            File fdir = new File(dir);
            classFileNames.addAll(HeapTracer.findClassNames(dir, fdir));
        }
        String[] result = new String[classFileNames.size()];
        Iterator it = classFileNames.iterator();
        for (int i = 0; i < result.length; ++i) {
            result[i] = (String)it.next();
        }
        return result;
    }

    private static Collection<String> findClassNames(String rootDir, File f) {
        HashSet<String> result = HashSetFactory.make();
        if (f.isDirectory()) {
            File[] files = f.listFiles();
            for (int i = 0; i < files.length; ++i) {
                result.addAll(HeapTracer.findClassNames(rootDir, files[i]));
            }
        } else if (f.getName().indexOf(".class") > 0) {
            String p = f.getAbsolutePath();
            p = p.substring(rootDir.length() + 1);
            p = p.substring(0, p.length() - 6);
            p = p.replace('\\', '.');
            return Collections.singleton(p);
        }
        return result;
    }

    private static Object[] extractBinDirectories(String classpath) {
        StringTokenizer t = new StringTokenizer(classpath, ";");
        HashSet result = HashSetFactory.make();
        while (t.hasMoreTokens()) {
            String n = t.nextToken();
            if (n.indexOf("bin") <= 0) continue;
            result.add(n);
        }
        return result.toArray();
    }

    public Result perform() throws ClassNotFoundException, IllegalArgumentException, IllegalAccessException {
        Result result = new Result();
        IdentityHashMap<Object, Object> objectsVisited = new IdentityHashMap<Object, Object>();
        if (this.traceStatics) {
            for (int i = 0; i < rootClasses.length; ++i) {
                Class<?> c = Class.forName(rootClasses[i]);
                Field[] fields = c.getDeclaredFields();
                for (int j = 0; j < fields.length; ++j) {
                    if (!HeapTracer.isStatic(fields[j])) continue;
                    this.traverse(fields[j], result, objectsVisited);
                }
            }
        }
        for (Object instance : this.rootInstances) {
            Class<?> c = instance.getClass();
            HashSet<Field> fields = HeapTracer.getAllInstanceFields(c);
            for (Field f : fields) {
                this.traverse(f, instance, result, objectsVisited);
            }
        }
        return result;
    }

    private static int computeSizeOf(Object o) {
        int result = 12;
        Class<?> c = o.getClass();
        if (c.isArray()) {
            Class<?> elementType = c.getComponentType();
            int length = Array.getLength(o);
            result += length * HeapTracer.sizeOfSlot(elementType);
        } else {
            if (c.isPrimitive()) {
                throw new Error();
            }
            HashSet<Field> fields = HeapTracer.getAllInstanceFields(c);
            for (Field f : fields) {
                result += HeapTracer.sizeOfSlot(f.getType());
            }
        }
        return result;
    }

    private int sizeOf(Object o) {
        Class<?> c = o.getClass();
        if (c.isArray()) {
            return HeapTracer.computeSizeOf(o);
        }
        Integer S = this.sizeMap.get(c);
        if (S == null) {
            S = new Integer(HeapTracer.computeSizeOf(o));
            this.sizeMap.put(c, S);
        }
        return S;
    }

    private static int sizeOfSlot(Class<?> c) {
        if (!c.isPrimitive()) {
            return 4;
        }
        if (c.equals(Boolean.TYPE) || c.equals(Character.TYPE) || c.equals(Byte.TYPE)) {
            return 1;
        }
        if (c.equals(Short.TYPE)) {
            return 2;
        }
        if (c.equals(Integer.TYPE) || c.equals(Float.TYPE)) {
            return 4;
        }
        if (c.equals(Long.TYPE) || c.equals(Double.TYPE)) {
            return 8;
        }
        throw new Error();
    }

    private void traverse(Field root, Result result, IdentityHashMap<Object, Object> objectsVisited) throws IllegalArgumentException, IllegalAccessException {
        root.setAccessible(true);
        Pair<Field, Object> contents = root.get(null);
        if (contents != null && objectsVisited.get(contents) == null) {
            objectsVisited.put(contents, DUMMY);
            Class<?> c = contents.getClass();
            if (c.isArray()) {
                result.registerReachedFrom(root, root, contents);
                this.arrayWorkList.push(Pair.make(root, contents));
            } else {
                result.registerReachedFrom(root, root, contents);
                if (internalClasses.contains(c)) {
                    contents = Pair.make(root, contents);
                }
                this.scalarWorkList.push(contents);
            }
        }
        this.drainWorkLists(root, result, objectsVisited);
    }

    private void traverse(Field root, Object instance, Result result, IdentityHashMap<Object, Object> objectsVisited) throws IllegalArgumentException, IllegalAccessException {
        this.traverseFieldOfScalar(root, root, instance, null, objectsVisited, result);
        this.drainWorkLists(root, result, objectsVisited);
    }

    private void drainWorkLists(Field root, Result result, IdentityHashMap<Object, Object> objectsVisited) throws IllegalAccessException {
        while (!this.scalarWorkList.isEmpty() || !this.arrayWorkList.isEmpty()) {
            if (!this.scalarWorkList.isEmpty()) {
                Object scalar = this.scalarWorkList.pop();
                if (scalar instanceof Pair) {
                    Pair p = (Pair)scalar;
                    this.traverseScalar(root, p.snd, p.fst, result, objectsVisited);
                } else {
                    this.traverseScalar(root, scalar, null, result, objectsVisited);
                }
            }
            if (this.arrayWorkList.isEmpty()) continue;
            Pair p = (Pair)this.arrayWorkList.pop();
            this.traverseArray(root, p.snd, p.fst, result, objectsVisited);
        }
    }

    private void traverseArray(Field root, Object array, Object container, Result result, IdentityHashMap<Object, Object> objectsVisited) throws IllegalArgumentException {
        Class<?> elementKlass = array.getClass().getComponentType();
        if (elementKlass.isPrimitive()) {
            return;
        }
        assert (container != null);
        int length = Array.getLength(array);
        for (int i = 0; i < length; ++i) {
            Pair<Object, Object> contents = Array.get(array, i);
            if (contents == null || objectsVisited.get(contents) != null) continue;
            objectsVisited.put(contents, DUMMY);
            Class<?> klass = contents.getClass();
            if (klass.isArray()) {
                result.registerReachedFrom(root, container, contents);
                contents = Pair.make(container, contents);
                this.arrayWorkList.push(contents);
                continue;
            }
            result.registerReachedFrom(root, container, contents);
            contents = Pair.make(container, contents);
            this.scalarWorkList.push(contents);
        }
    }

    private void traverseScalar(Field root, Object scalar, Object container, Result result, IdentityHashMap<Object, Object> objectsVisited) throws IllegalArgumentException, IllegalAccessException {
        Class<?> c = scalar.getClass();
        Field[] fields = this.getAllReferenceInstanceFields(c);
        for (int i = 0; i < fields.length; ++i) {
            this.traverseFieldOfScalar(root, fields[i], scalar, container, objectsVisited, result);
        }
    }

    private final boolean isInBadPackage(Class<?> c) {
        Package p = c.getPackage();
        if (p == null) {
            return false;
        }
        Object status = this.packageStatus.get(p);
        if (status == this.OK) {
            return false;
        }
        if (status == this.BAD) {
            return true;
        }
        if (p.getName() != null && p.getName().indexOf("sun.reflect") != -1) {
            this.packageStatus.put(p, this.BAD);
            return true;
        }
        this.packageStatus.put(p, this.OK);
        return false;
    }

    private void traverseFieldOfScalar(Field root, Field f, Object scalar, Object container, IdentityHashMap<Object, Object> objectsVisited, Result result) throws IllegalArgumentException, IllegalAccessException {
        if (this.isInBadPackage(f.getType())) {
            return;
        }
        if (container == null) {
            container = f;
        }
        f.setAccessible(true);
        Pair<Object, Object> contents = f.get(scalar);
        if (contents != null && objectsVisited.get(contents) == null) {
            try {
                objectsVisited.put(contents, DUMMY);
            }
            catch (Exception e) {
                e.printStackTrace();
                return;
            }
            Class<?> klass = contents.getClass();
            if (klass.isArray()) {
                result.registerReachedFrom(root, container, contents);
                contents = Pair.make(container, contents);
                this.arrayWorkList.push(contents);
            } else {
                result.registerReachedFrom(root, container, contents);
                if (internalClasses.contains(klass)) {
                    contents = Pair.make(container, contents);
                }
                this.scalarWorkList.push(contents);
            }
        }
    }

    private static HashSet<Field> getAllInstanceFields(Class<?> c) {
        HashSet<Field> result = HashSetFactory.make();
        for (Class<?> klass = c; klass != null; klass = klass.getSuperclass()) {
            Field[] fields = klass.getDeclaredFields();
            for (int i = 0; i < fields.length; ++i) {
                if (HeapTracer.isStatic(fields[i])) continue;
                result.add(fields[i]);
            }
        }
        return result;
    }

    private Field[] getAllReferenceInstanceFields(Class<?> c) {
        if (this.allReferenceFieldsCache.containsKey(c)) {
            return this.allReferenceFieldsCache.get(c);
        }
        HashSet s = HashSetFactory.make();
        for (Class<?> klass = c; klass != null; klass = klass.getSuperclass()) {
            Field[] fields = klass.getDeclaredFields();
            for (int i = 0; i < fields.length; ++i) {
                Class<?> fc;
                if (HeapTracer.isStatic(fields[i]) || (fc = fields[i].getType()).isPrimitive()) continue;
                s.add(fields[i]);
            }
        }
        Field[] result = new Field[s.size()];
        Object[] temp = s.toArray();
        for (int i = 0; i < result.length; ++i) {
            result[i] = (Field)temp[i];
        }
        this.allReferenceFieldsCache.put(c, result);
        return result;
    }

    private static boolean isStatic(Field field) {
        return Modifier.isStatic(field.getModifiers());
    }

    public static void analyzeLeaks() {
        HeapTracer.analyzeLeaks(true);
    }

    public static void analyzeLeaks(boolean traceStatics) {
        try {
            System.gc();
            System.gc();
            System.gc();
            System.gc();
            System.gc();
            long t = Runtime.getRuntime().totalMemory();
            long f = Runtime.getRuntime().freeMemory();
            System.err.println("Total Memory:     " + t);
            System.err.println("Occupied Memory:  " + (t - f));
            Result r = new HeapTracer(traceStatics).perform();
            System.err.println("HeapTracer Analysis:");
            System.err.println(r.toString());
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    public static Result traceHeap(Collection<?> instances, boolean traceStatics) {
        try {
            System.gc();
            System.gc();
            System.gc();
            System.gc();
            System.gc();
            long t = Runtime.getRuntime().totalMemory();
            long f = Runtime.getRuntime().freeMemory();
            System.err.println("Total Memory:     " + t);
            System.err.println("Occupied Memory:  " + (t - f));
            Result r = new HeapTracer(instances, traceStatics).perform();
            System.err.println("HeapTracer Analysis:");
            System.err.println(r.toString());
            return r;
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return null;
    }

    static {
        try {
            internalClasses.add(Class.forName("java.lang.String"));
            internalClasses.add(Class.forName("java.util.HashMap$Entry"));
            internalClasses.add(Class.forName("java.util.HashMap"));
            internalClasses.add(Class.forName("java.util.HashSet"));
            internalClasses.add(Class.forName("java.util.Vector"));
            internalClasses.add(Class.forName("com.ibm.wala.util.collections.SmallMap"));
            internalClasses.add(Class.forName("com.ibm.wala.util.collections.SimpleVector"));
            internalClasses.add(Class.forName("com.ibm.wala.util.intset.SimpleIntVector"));
            internalClasses.add(Class.forName("com.ibm.wala.util.intset.BasicNaturalRelation"));
            internalClasses.add(Class.forName("com.ibm.wala.util.intset.SparseIntSet"));
            internalClasses.add(Class.forName("com.ibm.wala.util.collections.SparseVector"));
            internalClasses.add(Class.forName("com.ibm.wala.util.intset.MutableSharedBitVectorIntSet"));
            internalClasses.add(Class.forName("com.ibm.wala.util.intset.MutableSparseIntSet"));
            internalClasses.add(Class.forName("com.ibm.wala.util.collections.TwoLevelVector"));
            internalClasses.add(Class.forName("com.ibm.wala.util.graph.impl.DelegatingNumberedNodeManager"));
            internalClasses.add(Class.forName("com.ibm.wala.util.graph.impl.SparseNumberedEdgeManager"));
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            Assertions.UNREACHABLE();
        }
    }

    public class Result {
        private final HashMap<Field, Demographics> roots = HashMapFactory.make();

        private Demographics findOrCreateDemographics(Field root) {
            Demographics d = this.roots.get(root);
            if (d == null) {
                d = new Demographics();
                this.roots.put(root, d);
            }
            return d;
        }

        public void registerReachedFrom(Field root, Object predecessor, Object contents) {
            Demographics d = this.findOrCreateDemographics(root);
            d.registerObject(Pair.make(predecessor, contents.getClass()), contents);
        }

        public int getTotalSize() {
            int totalSize = 0;
            for (Demographics d : this.roots.values()) {
                totalSize += d.getTotalSize();
            }
            return totalSize;
        }

        public String toString() {
            StringBuffer result = new StringBuffer();
            result.append("Assuming 12 header bytes per object\n");
            int totalInstances = 0;
            int totalSize = 0;
            for (Demographics d : this.roots.values()) {
                totalInstances += d.getTotalInstances();
                totalSize += d.getTotalSize();
            }
            result.append("Total instances: " + totalInstances + "\n");
            result.append("Total size(bytes): " + totalSize + "\n");
            TreeSet<Field> sortedDemo = new TreeSet<Field>(new SizeComparator());
            sortedDemo.addAll(this.roots.keySet());
            for (Field root : sortedDemo) {
                Demographics d = this.roots.get(root);
                if (d.getTotalSize() <= 10000) continue;
                result.append(" root: ").append(root).append("\n");
                result.append(d);
            }
            return result.toString();
        }

        private class SizeComparator
        implements Comparator<Field> {
            private SizeComparator() {
            }

            @Override
            public int compare(Field o1, Field o2) {
                Demographics d1 = (Demographics)Result.this.roots.get(o1);
                Demographics d2 = (Demographics)Result.this.roots.get(o2);
                return d2.getTotalSize() - d1.getTotalSize();
            }
        }
    }

    class Demographics {
        private final HashMap<Object, Integer> instanceCount = HashMapFactory.make();
        private final HashMap<Object, Integer> sizeCount = HashMapFactory.make();
        private int totalInstances = 0;
        private int totalSize = 0;

        Demographics() {
        }

        public void registerObject(Object key, Object o) {
            Integer I = this.instanceCount.get(key);
            int newCount = I == null ? 1 : I + 1;
            this.instanceCount.put(key, new Integer(newCount));
            ++this.totalInstances;
            I = this.sizeCount.get(key);
            int s = HeapTracer.this.sizeOf(o);
            int newSizeCount = I == null ? s : I + s;
            this.sizeCount.put(key, new Integer(newSizeCount));
            this.totalSize += s;
        }

        public String toString() {
            StringBuffer result = new StringBuffer();
            result.append("Totals: " + this.totalInstances + " " + this.totalSize + "\n");
            TreeSet<Object> sorted = new TreeSet<Object>(new SizeComparator());
            sorted.addAll(this.instanceCount.keySet());
            for (Object key : sorted) {
                Integer I = this.instanceCount.get(key);
                Integer bytes = this.sizeCount.get(key);
                result.append("  ").append(I).append("   ").append(bytes).append("   ");
                result.append(bytes / I).append("   ");
                result.append(key);
                result.append("\n");
            }
            return result.toString();
        }

        public int getTotalSize() {
            return this.totalSize;
        }

        public int getTotalInstances() {
            return this.totalInstances;
        }

        private class SizeComparator
        implements Comparator<Object> {
            private SizeComparator() {
            }

            @Override
            public int compare(Object o1, Object o2) {
                Integer i1 = (Integer)Demographics.this.sizeCount.get(o1);
                Integer i2 = (Integer)Demographics.this.sizeCount.get(o2);
                return i2 - i1;
            }
        }
    }
}

