/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.util.io;

import com.ibm.wala.util.Predicate;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.functions.VoidFunction;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.regex.Pattern;

public class FileUtil {
    public static Collection<File> listFiles(String dir, String regex, boolean recurse) {
        if (dir == null) {
            throw new IllegalArgumentException("dir is null");
        }
        File d = new File(dir);
        Pattern p = null;
        if (regex != null) {
            p = Pattern.compile(regex);
        }
        return FileUtil.listFiles(d, recurse, p);
    }

    private static Collection<File> listFiles(File directory, boolean recurse, Pattern p) {
        File[] files = directory.listFiles();
        if (files == null) {
            return Collections.emptyList();
        }
        HashSet<File> result = HashSetFactory.make();
        for (int i = 0; i < files.length; ++i) {
            if (p == null || p.matcher(files[i].getAbsolutePath()).matches()) {
                result.add(files[i]);
            }
            if (!recurse || !files[i].isDirectory()) continue;
            result.addAll(FileUtil.listFiles(files[i], recurse, p));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(String srcFileName, String destFileName) throws IOException {
        if (srcFileName == null) {
            throw new IllegalArgumentException("srcFileName is null");
        }
        if (destFileName == null) {
            throw new IllegalArgumentException("destFileName is null");
        }
        FileChannel src = null;
        AbstractInterruptibleChannel dest = null;
        try {
            src = new FileInputStream(srcFileName).getChannel();
            dest = new FileOutputStream(destFileName).getChannel();
            long n = src.size();
            MappedByteBuffer buf = src.map(FileChannel.MapMode.READ_ONLY, 0L, n);
            ((FileChannel)dest).write(buf);
        }
        finally {
            if (dest != null) {
                try {
                    dest.close();
                }
                catch (IOException iOException) {}
            }
            if (src != null) {
                try {
                    src.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static void deleteContents(String directory) throws IOException {
        File f = new File(directory);
        if (!f.exists()) {
            return;
        }
        if (!f.isDirectory()) {
            throw new IOException(directory + " is not a vaid directory");
        }
        for (String s : f.list()) {
            FileUtil.deleteRecursively(new File(f, s));
        }
    }

    private static void deleteRecursively(File f) throws IOException {
        boolean b;
        if (f.isDirectory()) {
            for (String s : f.list()) {
                FileUtil.deleteRecursively(new File(f, s));
            }
        }
        if (!(b = f.delete())) {
            throw new IOException("failed to delete " + f);
        }
    }

    public static final FileOutputStream createFile(String fileName) throws IOException {
        boolean result;
        if (fileName == null) {
            throw new IllegalArgumentException("null file");
        }
        File f = new File(fileName);
        if (f.getParentFile() != null && !f.getParentFile().exists() && !(result = f.getParentFile().mkdirs())) {
            throw new IOException("failed to create " + f.getParentFile());
        }
        if (f.exists()) {
            f.delete();
        }
        if (!(result = f.createNewFile())) {
            throw new IOException("failed to create " + f);
        }
        return new FileOutputStream(f);
    }

    public static byte[] readBytes(InputStream s) throws IOException {
        if (s == null) {
            throw new IllegalArgumentException("null s");
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte[] b = new byte[1024];
        int n = s.read(b);
        while (n != -1) {
            out.write(b, 0, n);
            n = s.read(b);
        }
        byte[] bb = out.toByteArray();
        out.close();
        return bb;
    }

    public static void writeFile(File f, String content) throws IOException {
        FileWriter fw = new FileWriter(f);
        fw.append(content);
        fw.close();
    }

    public static void recurseFiles(VoidFunction<File> action, final Predicate<File> filter, File top) {
        if (top.isDirectory()) {
            for (File f : top.listFiles(new FileFilter(){

                @Override
                public boolean accept(File file) {
                    return filter.test(file) || file.isDirectory();
                }
            })) {
                FileUtil.recurseFiles(action, filter, f);
            }
        } else {
            action.apply(top);
        }
    }
}

