/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.util.graph.traverse;

import com.ibm.wala.util.collections.EmptyIterator;
import com.ibm.wala.util.debug.UnimplementedError;
import com.ibm.wala.util.graph.Graph;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Stack;

public abstract class DFSFinishTimeIterator<T>
extends Stack<T>
implements Iterator<T> {
    private T theNextElement;
    private Iterator<? extends T> roots;
    private Graph<T> G;

    protected void init(Graph<T> G, Iterator<? extends T> nodes) {
        this.G = G;
        this.roots = nodes;
        if (this.roots.hasNext()) {
            this.theNextElement = this.roots.next();
        }
    }

    @Override
    public boolean hasNext() {
        return !this.empty() || this.theNextElement != null && this.getPendingChildren(this.theNextElement) == null;
    }

    abstract Iterator<T> getPendingChildren(T var1);

    abstract void setPendingChildren(T var1, Iterator<T> var2);

    @Override
    public T next() throws NoSuchElementException {
        Object v;
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        if (this.empty()) {
            v = this.theNextElement;
            this.setPendingChildren(v, this.getConnected(v));
            this.push(v);
        }
        block0: while (!this.empty()) {
            Iterator<T> pc;
            v = this.peek();
            Iterator<T> e = pc = this.getPendingChildren(v);
            while (e.hasNext()) {
                T n = e.next();
                assert (n != null) : "null node in pc";
                Iterator<T> nChildren = this.getPendingChildren(n);
                if (nChildren != null) continue;
                this.setPendingChildren(n, this.getConnected(n));
                this.push(n);
                continue block0;
            }
            this.setPendingChildren(v, EmptyIterator.instance());
            while (this.getPendingChildren(this.theNextElement) != null && this.roots.hasNext()) {
                this.theNextElement = this.roots.next();
            }
            return (T)this.pop();
        }
        return null;
    }

    protected Iterator<T> getConnected(T n) {
        return this.G.getSuccNodes(n);
    }

    @Override
    public void remove() throws UnimplementedError {
        throw new UnimplementedError();
    }
}

