/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.util.intset;

import com.ibm.wala.util.intset.IntVector;
import com.ibm.wala.util.intset.NumberUtility;
import java.util.Arrays;

public class MultiModalIntVector
implements IntVector {
    private static final float INITIAL_GROWTH_FACTOR = 1.5f;
    private static final float MINIMUM_GROWTH_FACTOR = 1.1f;
    private static final float DIFF_GROWTH_FACTOR = 0.39999998f;
    private float CURRENT_GROWTH_RATE = 1.5f;
    private static final int MAX_SIZE = 10000;
    private static final int INITIAL_SIZE = 1;
    int maxIndex = -1;
    private int[] intStore = new int[0];
    private short[] shortStore = new short[0];
    private byte[] byteStore = new byte[0];
    final int defaultValue;

    public MultiModalIntVector(int defaultValue) {
        this.defaultValue = defaultValue;
        this.init(this.getInitialSize(), defaultValue);
    }

    private void init(int initialSize, int defaultValue) {
        if (NumberUtility.isByte(defaultValue)) {
            this.byteStore = new byte[initialSize];
            this.byteStore[0] = (byte)defaultValue;
        } else if (NumberUtility.isShort(defaultValue)) {
            this.shortStore = new short[initialSize];
            this.shortStore[0] = (short)defaultValue;
        } else {
            this.intStore = new int[initialSize];
            this.intStore[0] = defaultValue;
        }
    }

    public MultiModalIntVector(int defaultValue, int initialSize) {
        if (initialSize <= 0) {
            throw new IllegalArgumentException("invalid initialSize: " + initialSize);
        }
        this.defaultValue = defaultValue;
        this.init(initialSize, defaultValue);
    }

    int getInitialSize() {
        return 1;
    }

    float getGrowthFactor() {
        return 1.5f;
    }

    float getGrowthFactor(int size) {
        if (this.CURRENT_GROWTH_RATE >= 1.1f) {
            float val = (float)(1.0 / (1.0 + Math.pow(Math.E, -1.0 * ((double)(size / 10000) * 12.0 - 6.0))));
            this.CURRENT_GROWTH_RATE = 1.5f - 0.39999998f * val;
        }
        return this.CURRENT_GROWTH_RATE;
    }

    @Override
    public int get(int x) {
        if (x < 0) {
            throw new IllegalArgumentException("illegal x: " + x);
        }
        int index = x;
        if (index < this.byteStore.length) {
            return this.byteStore[index];
        }
        if ((index -= this.byteStore.length) < this.shortStore.length) {
            return this.shortStore[index];
        }
        if ((index -= this.shortStore.length) < this.intStore.length) {
            return this.intStore[index];
        }
        return this.defaultValue;
    }

    private int getStoreLength() {
        return this.shortStore.length + this.byteStore.length + this.intStore.length;
    }

    @Override
    public void set(int x, int value) {
        if (x < 0) {
            throw new IllegalArgumentException("illegal x: " + x);
        }
        if (x > 10000) {
            throw new IllegalArgumentException("x is too big: " + x);
        }
        this.maxIndex = Math.max(this.maxIndex, x);
        this.handleMorph(x, value);
        if (value == this.defaultValue) {
            int length = this.getStoreLength();
            if (x >= length) {
                return;
            }
            this.add(value, x);
        } else {
            this.ensureCapacity(x, value);
            this.add(value, x);
        }
    }

    private void add(int value, int index) {
        if (this.byteStore.length > index) {
            this.byteStore[index] = (byte)value;
        } else if (this.shortStore.length > (index -= this.byteStore.length)) {
            this.shortStore[index] = (short)value;
        } else {
            this.intStore[index -= this.shortStore.length] = value;
        }
    }

    private void handleMorph(int index, int value) {
        if (NumberUtility.isShort(value)) {
            if (index < this.byteStore.length) {
                int newShortSize = this.byteStore.length - index + this.shortStore.length;
                short[] newShortStore = new short[newShortSize];
                byte[] newByteStore = new byte[index];
                for (int i = index; i < this.byteStore.length; ++i) {
                    newShortStore[i - index] = this.byteStore[i];
                }
                System.arraycopy(this.byteStore, 0, newByteStore, 0, index);
                System.arraycopy(this.shortStore, 0, newShortStore, this.byteStore.length - index, this.shortStore.length);
                this.byteStore = newByteStore;
                this.shortStore = newShortStore;
            }
        } else if (!NumberUtility.isByte(value)) {
            if (index < this.byteStore.length) {
                int newShortSize = this.byteStore.length - index + this.intStore.length;
                int[] newIntStore = new int[newShortSize];
                for (int i = index; i < this.byteStore.length; ++i) {
                    newIntStore[i - index] = this.byteStore[i];
                }
                byte[] newByteStore = new byte[index];
                System.arraycopy(this.byteStore, 0, newByteStore, 0, index);
                for (int i = 0; i < this.shortStore.length; ++i) {
                    newIntStore[this.byteStore.length - 1 + i] = this.shortStore[i];
                }
                System.arraycopy(this.intStore, 0, newIntStore, this.byteStore.length + this.shortStore.length - index, this.intStore.length);
                this.intStore = newIntStore;
                this.byteStore = newByteStore;
                this.shortStore = new short[0];
            } else {
                int newindex = index - this.byteStore.length;
                if (newindex < this.shortStore.length) {
                    int newIntSize = this.shortStore.length - newindex + this.intStore.length;
                    int[] newIntStore = new int[newIntSize];
                    for (int i = newindex; i < this.shortStore.length; ++i) {
                        newIntStore[i - newindex] = this.shortStore[i];
                    }
                    short[] newShortStore = new short[newindex];
                    System.arraycopy(this.shortStore, 0, newShortStore, 0, newindex);
                    System.arraycopy(this.intStore, 0, newIntStore, this.shortStore.length - newindex, this.intStore.length);
                    this.intStore = newIntStore;
                    this.shortStore = newShortStore;
                }
            }
        }
    }

    private void ensureCapacity(int capacity, int value) {
        int length = this.getStoreLength();
        if (this.intStore.length > 0 || !NumberUtility.isShort(value) && !NumberUtility.isByte(value)) {
            if (capacity >= length) {
                int[] old = this.intStore;
                int newSize = 1 + (int)(this.getGrowthFactor(length) * (float)capacity) - this.byteStore.length - this.shortStore.length;
                int[] newData = new int[newSize];
                Arrays.fill(newData, this.defaultValue);
                System.arraycopy(old, 0, newData, 0, old.length);
                this.intStore = newData;
            }
        } else if (this.shortStore.length > 0 || NumberUtility.isShort(value)) {
            if (capacity >= length) {
                short[] old = this.shortStore;
                int newSize = 1 + (int)(this.getGrowthFactor(length) * (float)capacity) - this.byteStore.length;
                short[] newData = new short[newSize];
                Arrays.fill(newData, (short)this.defaultValue);
                System.arraycopy(old, 0, newData, 0, old.length);
                this.shortStore = newData;
            }
        } else if (capacity >= length) {
            byte[] old = this.byteStore;
            int newSize = 1 + (int)(this.getGrowthFactor(length) * (float)capacity);
            byte[] newData = new byte[newSize];
            Arrays.fill(newData, (byte)this.defaultValue);
            System.arraycopy(old, 0, newData, 0, old.length);
            this.byteStore = newData;
        }
    }

    @Override
    public int getMaxIndex() {
        return this.maxIndex;
    }

    public void print() {
        int i;
        String str = "";
        for (i = 0; i < this.byteStore.length; ++i) {
            str = str + this.byteStore[i] + ",";
        }
        for (i = 0; i < this.shortStore.length; ++i) {
            str = str + this.shortStore[i] + ",";
        }
        for (i = 0; i < this.intStore.length; ++i) {
            str = str + this.intStore[i] + ",";
        }
        System.out.println(str);
    }
}

