/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.util.intset;

import com.ibm.wala.util.intset.IntSet;
import com.ibm.wala.util.intset.MutableIntSetFactory;
import com.ibm.wala.util.intset.SemiSparseMutableIntSet;
import com.ibm.wala.util.intset.SparseIntSet;
import java.util.TreeSet;

public class SemiSparseMutableIntSetFactory
implements MutableIntSetFactory<SemiSparseMutableIntSet> {
    @Override
    public SemiSparseMutableIntSet make(int[] set) {
        if (set == null) {
            throw new IllegalArgumentException("set is null");
        }
        if (set.length == 0) {
            return this.make();
        }
        TreeSet<Integer> T = new TreeSet<Integer>();
        for (int i = 0; i < set.length; ++i) {
            T.add(set[i]);
        }
        SemiSparseMutableIntSet result = new SemiSparseMutableIntSet();
        for (Integer I : T) {
            result.add(I);
        }
        return result;
    }

    @Override
    public SemiSparseMutableIntSet parse(String string) throws NumberFormatException {
        int[] data = SparseIntSet.parseIntArray(string);
        SemiSparseMutableIntSet result = new SemiSparseMutableIntSet();
        for (int i = 0; i < data.length; ++i) {
            result.add(data[i]);
        }
        return result;
    }

    @Override
    public SemiSparseMutableIntSet makeCopy(IntSet x) {
        SemiSparseMutableIntSet y = new SemiSparseMutableIntSet();
        y.copySet(x);
        return y;
    }

    @Override
    public SemiSparseMutableIntSet make() {
        return new SemiSparseMutableIntSet();
    }
}

