/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.internal.discovery.jee;

import com.ibm.appscan.common.model.IScan;
import com.ibm.appscan.common.utils.ArchiveUtil;
import com.ibm.appscan.common.utils.SystemUtil;
import com.ibm.appscan.discovery.IStrategyFactory;
import com.ibm.appscan.discovery.IStrategyFactoryRegistry;
import com.ibm.appscan.discovery.Strategy;
import com.ibm.appscan.internal.discovery.java.stage.JavaStagerStrategy;
import com.ibm.appscan.internal.discovery.jee.RARStrategy;
import java.io.File;

public class RARStrategyFactory
implements IStrategyFactory {
    public Strategy createStrategy(File fileOrDirectory, IStrategyFactoryRegistry registry) {
        if (fileOrDirectory.getName().toLowerCase().endsWith(".rar") && (new File(fileOrDirectory, "META-INF/ra.xml").isFile() || ArchiveUtil.isZip((File)fileOrDirectory))) {
            if (!SystemUtil.useStagerForJavaFiles()) {
                return new RARStrategy(fileOrDirectory, registry);
            }
            if (registry.useAlternativeStrategy()) {
                return new JavaStagerStrategy(fileOrDirectory, null);
            }
        }
        return null;
    }

    public boolean isBuildOutput() {
        return true;
    }

    public void loadUniqueTarget(IScan scan) {
    }
}

