/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.internal.discovery.jee;

import com.ibm.appscan.common.model.IScan;
import com.ibm.appscan.common.utils.SystemUtil;
import com.ibm.appscan.discovery.IStrategyFactory;
import com.ibm.appscan.discovery.IStrategyFactoryRegistry;
import com.ibm.appscan.discovery.Strategy;
import com.ibm.appscan.internal.discovery.java.stage.JavaStagerStrategy;
import com.ibm.appscan.internal.discovery.jee.WARStrategy;
import java.io.File;

public class WARStrategyFactory
implements IStrategyFactory {
    public Strategy createStrategy(File fileOrDirectory, IStrategyFactoryRegistry registry) {
        if (fileOrDirectory.getName().toLowerCase().endsWith(".war") || new File(fileOrDirectory, "WEB-INF").isDirectory()) {
            if (!SystemUtil.useStagerForJavaFiles()) {
                return new WARStrategy(fileOrDirectory, registry);
            }
            if (registry.useAlternativeStrategy()) {
                return new JavaStagerStrategy(fileOrDirectory, null);
            }
        }
        return null;
    }

    public boolean isBuildOutput() {
        return true;
    }

    public void loadUniqueTarget(IScan scan) {
    }
}

