/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.frameworks.handlers.spring3;

import com.ibm.appscan.frameworks.analyzers.generic.LangIndependentWalaUtil;
import com.ibm.appscan.frameworks.analyzers.generic.StringConstantFlow;
import com.ibm.appscan.frameworks.handlers.spring3.SpringConfigManager;
import com.ibm.appscan.frameworks.handlers.spring3.Util;
import com.ibm.appscan.frameworks.highlevelapi.F4FActions;
import com.ibm.appscan.frameworks.highlevelapi.F4FApp;
import com.ibm.appscan.frameworks.highlevelapi.processing.F4FActionProcessor;
import com.ibm.appscan.frameworks.specinfo.ArgToOrigCallExpr;
import com.ibm.appscan.frameworks.specinfo.AssignableSyntheticExpr;
import com.ibm.appscan.frameworks.specinfo.AssignmentExpr;
import com.ibm.appscan.frameworks.specinfo.BeanDecl;
import com.ibm.appscan.frameworks.specinfo.CallSiteReplacement;
import com.ibm.appscan.frameworks.specinfo.GlobalRefExpr;
import com.ibm.appscan.frameworks.specinfo.NonDetSelectionExpr;
import com.ibm.appscan.frameworks.specinfo.NonVoidSyntheticExpr;
import com.ibm.appscan.frameworks.specinfo.ObjectRefExpr;
import com.ibm.appscan.frameworks.specinfo.SyntheticExpr;
import com.ibm.appscan.frameworks.util.FilePositionInfo;
import com.ibm.appscan.frameworks.util.Messages;
import com.ibm.appscan.frameworks.util.VDBJavaUtil;
import com.ibm.appscan.frameworks.util.WalaUtil;
import com.ibm.appscan.taint.util.logging.TaintLogger;
import com.ibm.wala.analysis.typeInference.TypeInference;
import com.ibm.wala.classLoader.CallSiteReference;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.classLoader.Language;
import com.ibm.wala.ipa.callgraph.AnalysisCache;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.shrikeCT.AnnotationsReader;
import com.ibm.wala.ssa.DefUse;
import com.ibm.wala.ssa.IR;
import com.ibm.wala.ssa.SSAAbstractInvokeInstruction;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.types.MethodReference;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.types.annotations.Annotation;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.collections.Iterator2Iterable;
import com.ibm.wala.util.collections.MapUtil;
import com.ibm.wala.util.debug.UnimplementedError;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class Spring3CallReplacementGenerator {
    private F4FApp app;
    private F4FActions actions;
    private SpringConfigManager configManager;
    private final Map<String, WriteToGlobalInfo> callReplacementSig2WriteToGlobalInfo = HashMapFactory.make();
    private static final String MODEL_AND_VIEW_NAME = "Lorg/springframework/web/servlet/ModelAndView";

    public Spring3CallReplacementGenerator(F4FApp app, F4FActions actions, SpringConfigManager configManager) {
        this.app = app;
        this.actions = actions;
        this.configManager = configManager;
    }

    public void generateCallReplacements() {
        String VdbSigForModelAndViewCtor1 = "org.springframework.web.servlet.ModelAndView.&lt;init&gt;(java.lang.String;java.lang.String;java.lang.Object):void";
        this.replaceCallsWithWritingToGlobals(VdbSigForModelAndViewCtor1, "request", 2, 3);
        TaintLogger.i().getLogger().info((Object)Messages.getString((String)"framework.replace.call.write", (Object[])new Object[]{VdbSigForModelAndViewCtor1, "request"}));
        String VdbSigForModelAndViewCtor2 = "org.springframework.web.servlet.ModelAndView.&lt;init&gt;(org.springframework.web.servlet.View;java.lang.String;java.lang.Object):void";
        this.replaceCallsWithWritingToGlobals(VdbSigForModelAndViewCtor2, "request", 2, 3);
        TaintLogger.i().getLogger().info((Object)Messages.getString((String)"framework.replace.call.write", (Object[])new Object[]{VdbSigForModelAndViewCtor2, "request"}));
        String VdbSigForAddObject = "org.springframework.web.servlet.ModelAndView.addObject(java.lang.String;java.lang.Object):org.springframework.web.servlet.ModelAndView";
        this.replaceCallsWithWritingToGlobals(VdbSigForAddObject, "request", 1, 2);
        TaintLogger.i().getLogger().info((Object)Messages.getString((String)"framework.replace.call.write", (Object[])new Object[]{VdbSigForAddObject, "request"}));
        String VdbSigForModelMapCtor = "org.springframework.ui.ModelMap.&lt;init&gt;(java.lang.String;java.lang.Object):void";
        this.replaceCallsWithWritingToGlobals(VdbSigForModelMapCtor, "request", 1, 2);
        TaintLogger.i().getLogger().info((Object)Messages.getString((String)"framework.replace.call.write", (Object[])new Object[]{VdbSigForModelMapCtor, "request"}));
        String VdbSigForAddAttr = "org.springframework.ui.ModelMap.addAttribute(java.lang.String;java.lang.Object):org.springframework.ui.ModelMap";
        this.replaceCallsWithWritingToGlobals(VdbSigForAddAttr, "request", 1, 2);
        TaintLogger.i().getLogger().info((Object)Messages.getString((String)"framework.replace.call.write", (Object[])new Object[]{VdbSigForAddAttr, "request"}));
        String VdbSigForModelMapAddObject = "org.springframework.ui.ModelMap.addObject(java.lang.String;java.lang.Object):org.springframework.ui.ModelMap";
        this.replaceCallsWithWritingToGlobals(VdbSigForModelMapAddObject, "request", 1, 2);
        TaintLogger.i().getLogger().info((Object)Messages.getString((String)"framework.replace.call.write", (Object[])new Object[]{VdbSigForModelMapAddObject, "request"}));
        String VdbSigForModelMapPut = "org.springframework.ui.ModelMap.put(java.lang.Object;java.lang.Object):java.lang.Object";
        this.replaceCallsWithWritingToGlobals(VdbSigForModelMapPut, "request", 1, 2);
        TaintLogger.i().getLogger().info((Object)Messages.getString((String)"framework.replace.call.write", (Object[])new Object[]{VdbSigForModelMapPut, "request"}));
        String VdbSigForMapPut = "java.util.Map.put(java.lang.Object;java.lang.Object):java.lang.Object";
        this.replaceCallsWithWritingToGlobals(VdbSigForMapPut, "request", 1, 2);
        TaintLogger.i().getLogger().info((Object)Messages.getString((String)"framework.replace.call.write", (Object[])new Object[]{VdbSigForMapPut, "request"}));
        String VdbSigForHashMapPut = "java.util.HashMap.put(java.lang.Object;java.lang.Object):java.lang.Object";
        this.replaceCallsWithWritingToGlobals(VdbSigForHashMapPut, "request", 1, 2);
        TaintLogger.i().getLogger().info((Object)Messages.getString((String)"framework.replace.call.write", (Object[])new Object[]{VdbSigForHashMapPut, "request"}));
        String VdbSigForModelAddAttribute = "org.springframework.ui.Model.addAttribute(java.lang.String;java.lang.Object):org.springframework.ui.Model";
        this.replaceCallsWithWritingToGlobals(VdbSigForModelAddAttribute, "request", 1, 2);
        TaintLogger.i().getLogger().info((Object)Messages.getString((String)"framework.replace.call.write", (Object[])new Object[]{VdbSigForModelAddAttribute, "request"}));
        this.generateReplaceCallsWithWritingToGlobals();
    }

    private void replaceCallsWithWritingToGlobals(String VdbSigForTheCall, String globalNamePrefix, int paraIndexToGetGlobalNameSuffix, int paraIndex4RSE) {
        if (this.callReplacementSig2WriteToGlobalInfo.containsKey(VdbSigForTheCall)) {
            throw new IllegalArgumentException("already have a replaceCallsWithWritingToGlobals for calls to " + VdbSigForTheCall);
        }
        this.callReplacementSig2WriteToGlobalInfo.put(VdbSigForTheCall, new WriteToGlobalInfo(globalNamePrefix, paraIndexToGetGlobalNameSuffix, paraIndex4RSE));
    }

    private void generateReplaceCallsWithWritingToGlobals() {
        if (this.callReplacementSig2WriteToGlobalInfo.isEmpty()) {
            return;
        }
        AnalysisCache cache = new AnalysisCache();
        IClassHierarchy cha = this.app.getClassHierarchy();
        HashSet globalBeans = HashSetFactory.make();
        HashMap callReplacements = HashMapFactory.make();
        for (IClass klass : cha) {
            if (klass.isInterface()) continue;
            Language lang = klass.getClassLoader().getLanguage();
            if (!cha.getScope().isApplicationLoader(klass.getClassLoader())) continue;
            for (IMethod m : klass.getDeclaredMethods()) {
                if (m.isAbstract()) continue;
                try {
                    IR ir = LangIndependentWalaUtil.getIR((IMethod)m, (AnalysisCache)cache);
                    DefUse du = LangIndependentWalaUtil.getDU((IR)ir, (AnalysisCache)cache);
                    TypeInference ti = null;
                    for (SSAInstruction instr : Iterator2Iterable.make((Iterator)ir.iterateNormalInstructions())) {
                        TypeReference storedObjType;
                        SSAAbstractInvokeInstruction call;
                        CallSiteReference callSiteRef;
                        MethodReference targetRef;
                        String vdbTargetName;
                        if (!(instr instanceof SSAAbstractInvokeInstruction) || !this.callReplacementSig2WriteToGlobalInfo.containsKey(vdbTargetName = F4FActionProcessor.getVDBSig((MethodReference)(targetRef = (callSiteRef = (call = (SSAAbstractInvokeInstruction)instr).getCallSite()).getDeclaredTarget()), (Language)lang, (IClassHierarchy)cha)) || (vdbTargetName.equals("java.util.Map.put(java.lang.Object;java.lang.Object):java.lang.Object") || vdbTargetName.equals("java.util.HashMap.put(java.lang.Object;java.lang.Object):java.lang.Object")) && !this.isArgumentToMethodOf(du, call.getUse(0), "<init>", MODEL_AND_VIEW_NAME)) continue;
                        WriteToGlobalInfo write2GlobalInfo = this.callReplacementSig2WriteToGlobalInfo.get(vdbTargetName);
                        if (vdbTargetName.equals("org.springframework.ui.ModelMap.put(java.lang.Object;java.lang.Object):java.lang.Object")) {
                            vdbTargetName = "java.util.LinkedHashMap.put(java.lang.Object;java.lang.Object):java.lang.Object";
                        }
                        int modelNameParamLVal = call.getUse(write2GlobalInfo.paraIndexToGetGlobalNameSuffix);
                        StringConstantFlow flow = StringConstantFlow.makeIntraproc((IR)ir, (DefUse)du);
                        Collection modelNames = flow.findIntraprocStringsFlowingToVar(modelNameParamLVal);
                        if (modelNames.size() != 1) continue;
                        String modelName = (String)modelNames.iterator().next();
                        String globalId = write2GlobalInfo.globalNamePrefix + "." + modelName;
                        ObjectRefExpr lval = null;
                        if (this.isSessionAttribute(this.app, klass, modelName)) {
                            HashSet globalRefs = HashSetFactory.make();
                            globalRefs.add(GlobalRefExpr.make((String)globalId));
                            globalRefs.add(GlobalRefExpr.make((String)("session." + modelName)));
                            lval = ObjectRefExpr.make((NonVoidSyntheticExpr)NonDetSelectionExpr.make((Set)globalRefs), (String)"");
                        } else {
                            lval = ObjectRefExpr.make((NonVoidSyntheticExpr)GlobalRefExpr.make((String)globalId), (String)"");
                        }
                        ArgToOrigCallExpr rval = ArgToOrigCallExpr.make((int)write2GlobalInfo.getParaIndex4RightSideExpr());
                        FilePositionInfo filePosInfo = Util.getMethodPosition(m, this.configManager.getSourceDirectoryList());
                        AssignmentExpr assignment = AssignmentExpr.make((FilePositionInfo)filePosInfo, (AssignableSyntheticExpr)lval, (NonVoidSyntheticExpr)rval);
                        int bcIndex = callSiteRef.getProgramCounter();
                        CallSiteReplacement replacement = CallSiteReplacement.make((String)vdbTargetName, (int)bcIndex, (int)WalaUtil.getSourceLine((IMethod)m, (CallSiteReference)callSiteRef), (SyntheticExpr)assignment);
                        TaintLogger.i().getLogger().info((Object)Messages.getString((String)"framework.generate.call.replacement", (Object[])new Object[]{vdbTargetName, m.getName().toString()}));
                        MapUtil.findOrCreateSet((Map)callReplacements, (Object)F4FActionProcessor.getVDBSig((MethodReference)m.getReference(), (Language)lang, (IClassHierarchy)cha)).add(replacement);
                        if (ti == null) {
                            ti = TypeInference.make((IR)ir, (boolean)true);
                        }
                        String typeName = (storedObjType = ti.getType(call.getUse(write2GlobalInfo.getParaIndex4RightSideExpr())).getTypeReference()) != null ? VDBJavaUtil.jvmToVDBType((String)storedObjType.getName().toString()) : "java.lang.Object";
                        globalBeans.add(BeanDecl.makeWithConcreteType((String)globalId, (String)typeName, (BeanDecl.BeanLifespan)BeanDecl.BeanLifespan.ENTRYPOINT));
                    }
                }
                catch (UnimplementedError e) {
                    return;
                }
            }
        }
        F4FActionProcessor.addCallReplacements((Map)callReplacements);
        for (BeanDecl global : globalBeans) {
            TaintLogger.i().getLogger().info((Object)Messages.getString((String)"framework.generate.global", (Object[])new Object[]{global.getId()}));
            this.actions.createGlobal(global.getId(), global.getType(), global.getLifespan() == BeanDecl.BeanLifespan.ENTRYPOINT);
        }
    }

    private boolean isArgumentToMethodOf(DefUse du, int val, String methodName, String className) {
        boolean result = false;
        for (SSAInstruction use : Iterator2Iterable.make((Iterator)du.getUses(val))) {
            SSAAbstractInvokeInstruction invoke;
            MethodReference tRef;
            if (!(use instanceof SSAAbstractInvokeInstruction) || !(tRef = (invoke = (SSAAbstractInvokeInstruction)use).getDeclaredTarget()).getName().toString().equals(methodName) || !tRef.getDeclaringClass().getName().toString().equals(className)) continue;
            result = true;
            break;
        }
        return result;
    }

    private boolean isSessionAttribute(F4FApp app, IClass c, String name) {
        Collection classAnnotations = app.getClassAnnotations(c);
        for (Annotation annot : classAnnotations) {
            String theAnnotTypeName = annot.getType().toString();
            if (!theAnnotTypeName.contains("SessionAttributes")) continue;
            if (annot.getNamedArguments().get("value") == null || !(annot.getNamedArguments().get("value") instanceof AnnotationsReader.ArrayElementValue)) break;
            AnnotationsReader.ElementValue[] vals = ((AnnotationsReader.ArrayElementValue)annot.getNamedArguments().get((Object)"value")).vals;
            for (int i = 0; i < vals.length; ++i) {
                if (!vals[i].toString().equals(name)) continue;
                return true;
            }
        }
        return false;
    }

    public class WriteToGlobalInfo {
        private String globalNamePrefix;
        private int paraIndexToGetGlobalNameSuffix;
        private int paraIndex4RightSideExpr;

        public WriteToGlobalInfo(String globalNamePrefix, int paraIndexToGetGlobalNameSuffix, int paraIndex4RightSideExpr) {
            this.globalNamePrefix = globalNamePrefix;
            this.paraIndexToGetGlobalNameSuffix = paraIndexToGetGlobalNameSuffix;
            this.paraIndex4RightSideExpr = paraIndex4RightSideExpr;
        }

        public String getGlobalNamePrefix() {
            return this.globalNamePrefix;
        }

        public int getParaIndexToGetGlobalNameSuffix() {
            return this.paraIndexToGetGlobalNameSuffix;
        }

        public int getParaIndex4RightSideExpr() {
            return this.paraIndex4RightSideExpr;
        }
    }
}

