/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.frameworks.handlers.spring3;

import com.ibm.appscan.frameworks.handlers.spring3.InternalResourceViewResolver;
import com.ibm.appscan.frameworks.util.DOMParserWithLineNumbers;
import com.ibm.appscan.frameworks.util.Messages;
import com.ibm.appscan.frameworks.util.PreNamespaceContext;
import com.ibm.appscan.taint.util.logging.TaintLogger;
import com.ibm.wala.util.collections.HashSetFactory;
import java.io.IOException;
import java.util.Set;
import javax.xml.namespace.NamespaceContext;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class SpringAppContextFileParser {
    private String applicationContextFileName;
    private Set<String> autoBeanDiscoverPackages = HashSetFactory.make();
    private Set<InternalResourceViewResolver> viewResolverList = HashSetFactory.make();
    private float springVersionNumber = -1.0f;
    private boolean hasMVCAnnotationDriven = false;
    private String defaultNamespaceURI;
    private String contextNamespaceURI;
    private String xsiNamespaceURI;
    private String mvcNamespaceURI;

    public Set<InternalResourceViewResolver> getViewResolverList() {
        return this.viewResolverList;
    }

    public SpringAppContextFileParser(String filename) throws IOException, SAXException {
        this.applicationContextFileName = filename;
        DOMParserWithLineNumbers parser = new DOMParserWithLineNumbers(filename);
        Document document = parser.getDocument();
        this.defaultNamespaceURI = this.getNamespaceURI(document, null);
        this.contextNamespaceURI = this.getNamespaceURI(document, "context");
        this.xsiNamespaceURI = this.getNamespaceURI(document, "xsi");
        this.mvcNamespaceURI = this.getNamespaceURI(document, "mvc");
        if (this.mvcNamespaceURI == null && this.defaultNamespaceURI != null && this.defaultNamespaceURI.endsWith("/mvc")) {
            this.mvcNamespaceURI = this.defaultNamespaceURI;
        }
        this.populate(document);
    }

    public String getApplicationContextFileName() {
        return this.applicationContextFileName;
    }

    public Set<String> getAutoBeanDiscoverPackages() {
        return this.autoBeanDiscoverPackages;
    }

    public float getSpringVersionNumber() {
        if (this.springVersionNumber == -1.0f) {
            TaintLogger.i().getLogger().warn((Object)Messages.getString((String)"framework.failure.getting.from", (Object[])new Object[]{"version", this.applicationContextFileName}));
        }
        return this.springVersionNumber;
    }

    public boolean isJSR303BeanValidatorEnabled() {
        return this.hasMVCAnnotationDriven;
    }

    private void populate(Document doc) {
        try {
            XPath xpathForContextNS = this.createXPath(this.contextNamespaceURI);
            this.handleBeanAutoDiscovery(doc, xpathForContextNS);
            this.handleSpringVersionInfo(doc);
            XPath xpathForMVCNS = this.createXPath(this.mvcNamespaceURI);
            this.handleMVCAnnotationDrivenNode(doc, xpathForMVCNS);
        }
        catch (XPathExpressionException e) {
            e.printStackTrace();
        }
    }

    private void handleBeanAutoDiscovery(Document doc, XPath xpath) throws XPathExpressionException {
        NodeList autoScanComponentNodes = (NodeList)xpath.compile(this.adjustNS("//pre:component-scan", this.contextNamespaceURI)).evaluate(doc, XPathConstants.NODESET);
        for (int i = 0; i < autoScanComponentNodes.getLength(); ++i) {
            Node autoScanComponentNode = autoScanComponentNodes.item(i);
            String packageName = xpath.compile(this.adjustNS("@base-package", this.contextNamespaceURI)).evaluate(autoScanComponentNode);
            this.autoBeanDiscoverPackages.add(packageName);
        }
    }

    private void handleSpringVersionInfo(Document document) {
        String springSchemaLoc;
        TaintLogger.i().getLogger().info((Object)Messages.getString((String)"framework.examine", (Object[])new Object[]{"version"}));
        NodeList childNodes = document.getChildNodes();
        Node beansNode = null;
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node child = childNodes.item(i);
            if (!child.getNodeName().equals("beans")) continue;
            beansNode = child;
            break;
        }
        if (beansNode == null) {
            return;
        }
        NamedNodeMap attributes = beansNode.getAttributes();
        if (attributes == null) {
            return;
        }
        Node schemaLocationAttr = attributes.getNamedItem("xsi:schemaLocation");
        if (schemaLocationAttr == null) {
            return;
        }
        String schemaLocations = schemaLocationAttr.getNodeValue();
        int index = schemaLocations.indexOf(springSchemaLoc = "http://www.springframework.org/schema/mvc/spring-mvc-");
        if (index <= 0) {
            springSchemaLoc = "http://www.springframework.org/schema/beans/spring-beans-";
            index = schemaLocations.indexOf(springSchemaLoc);
        }
        if (index > 0) {
            String springVersion = schemaLocations.substring(index += springSchemaLoc.length(), index + 3);
            try {
                this.springVersionNumber = Float.valueOf(springVersion).floatValue();
            }
            catch (NumberFormatException e) {
                this.springVersionNumber = -1.0f;
            }
            TaintLogger.i().getLogger().info((Object)Messages.getString((String)"framework.found", (Object[])new Object[]{"version=" + Float.toString(this.springVersionNumber)}));
        }
    }

    private void handleMVCAnnotationDrivenNode(Document doc, XPath xpath) throws XPathExpressionException {
        NodeList MVCAnnotationDrivenNode = (NodeList)xpath.compile(this.adjustNS("//pre:annotation-driven", this.mvcNamespaceURI)).evaluate(doc, XPathConstants.NODESET);
        if (MVCAnnotationDrivenNode.getLength() > 0) {
            TaintLogger.i().getLogger().info((Object)Messages.getString((String)"framework.node.found", (Object[])new Object[]{"annotation-driven"}));
            this.hasMVCAnnotationDriven = true;
        } else {
            this.hasMVCAnnotationDriven = true;
        }
    }

    private String adjustNS(String query, String namespaceURI) {
        return namespaceURI != null ? query : query.replaceAll("pre:", "");
    }

    private XPath createXPath(String namespaceURI) {
        XPathFactory factory = XPathFactory.newInstance();
        XPath xpath = factory.newXPath();
        if (namespaceURI != null) {
            xpath.setNamespaceContext((NamespaceContext)new PreNamespaceContext(namespaceURI));
        }
        return xpath;
    }

    private String getNamespaceURI(Document document, String prefix) {
        Node child;
        int i;
        NodeList childNodes = document.getChildNodes();
        Node webAppNode = null;
        for (i = 0; i < childNodes.getLength(); ++i) {
            child = childNodes.item(i);
            if (!child.getNodeName().equals("beans")) continue;
            webAppNode = child;
            break;
        }
        if (webAppNode == null) {
            for (i = 0; i < childNodes.getLength(); ++i) {
                child = childNodes.item(i);
                if (!child.getLocalName().equals("beans")) continue;
                webAppNode = child;
                break;
            }
        }
        if (webAppNode == null) {
            return null;
        }
        NamedNodeMap attributes = webAppNode.getAttributes();
        if (attributes == null) {
            return null;
        }
        String attrName = prefix == null ? "xmlns" : "xmlns:" + prefix;
        Node nsAttribute = attributes.getNamedItem(attrName);
        if (nsAttribute == null) {
            return null;
        }
        return nsAttribute.getNodeValue();
    }

    public static void main(String[] args) {
        try {
            SpringAppContextFileParser contextParser = new SpringAppContextFileParser("D:\\Automation_TestApps\\TestApps\\TestApps\\F4F Apps\\Spring3\\Spring3-MVC-HelloWorld-Example\\SpringMVC\\src\\main\\webapp\\WEB-INF\\mvc-dispatcher-servlet.xml");
            System.out.println("-----Finished parsing context file---------");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
    }
}

