/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.frameworks.handlers.spring3;

import com.ibm.appscan.frameworks.analyzers.generic.LangIndependentWalaUtil;
import com.ibm.appscan.frameworks.analyzers.generic.StringConstantFlow;
import com.ibm.appscan.frameworks.analyzers.spring.ISpringViewResolver;
import com.ibm.appscan.frameworks.analyzers.spring.ModelAndViewUtil;
import com.ibm.appscan.frameworks.analyzers.spring.SpringAppConfigInfo;
import com.ibm.appscan.frameworks.handlers.spring3.Spring25HandlerCodeAdapter;
import com.ibm.appscan.frameworks.handlers.spring3.SpringAppContextFileParser;
import com.ibm.appscan.frameworks.handlers.spring3.SpringBeanAndValidatorManager;
import com.ibm.appscan.frameworks.handlers.spring3.SpringConfigBeanInfo;
import com.ibm.appscan.frameworks.handlers.spring3.Util;
import com.ibm.appscan.frameworks.highlevelapi.F4FApp;
import com.ibm.appscan.frameworks.highlevelapi.processing.F4FActionProcessor;
import com.ibm.appscan.frameworks.util.DOMParserWithLineNumbers;
import com.ibm.appscan.frameworks.util.JavaUtils;
import com.ibm.appscan.frameworks.util.Messages;
import com.ibm.appscan.frameworks.util.VDBJavaUtil;
import com.ibm.appscan.taint.util.logging.TaintLogger;
import com.ibm.wala.analysis.typeInference.TypeInference;
import com.ibm.wala.classLoader.CallSiteReference;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.classLoader.Language;
import com.ibm.wala.ipa.callgraph.AnalysisCache;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.shrikeCT.AnnotationsReader;
import com.ibm.wala.ssa.DefUse;
import com.ibm.wala.ssa.IR;
import com.ibm.wala.ssa.SSAAbstractInvokeInstruction;
import com.ibm.wala.ssa.SSAArrayStoreInstruction;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SSALoadMetadataInstruction;
import com.ibm.wala.ssa.SymbolTable;
import com.ibm.wala.types.ClassLoaderReference;
import com.ibm.wala.types.MethodReference;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.types.annotations.Annotation;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.collections.Iterator2Iterable;
import com.ibm.wala.util.strings.StringStuff;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.NameFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class SpringConfigManager {
    private String webXmlFile;
    private String scopeFileName;
    private ArrayList<String> sourceDirectoryList = null;
    private ArrayList<String> dispatcherServletsThroughApp = new ArrayList();
    private Set<String> componentScanPackages = HashSetFactory.make();
    private final Map<String, SpringConfigBeanInfo> springConfigBeanInfoMap = HashMapFactory.make();
    private boolean enableWebMvcAnnotationSet = false;
    private boolean usingJavaConfig = false;
    private String urlMappingFromJavaConfig = "";
    private ArrayList<String> freeMarkerFileList = null;
    private String webContentDir;
    Properties options;
    boolean isSpringApp = false;
    float versionNumber = -1.0f;
    SpringAppConfigInfo spring25AppConfigInfo;
    private Spring25HandlerCodeAdapter oldCodeAdapter = new Spring25HandlerCodeAdapter();
    private SpringBeanAndValidatorManager beanAndValidatorManager;
    private Map<String, SpringAppContextFileParser> contextConfigfile2FileParserMap = HashMapFactory.make();

    public SpringConfigManager(String webContentDir, String webXmlFile, Properties options) {
        this(webContentDir, webXmlFile, options, "");
    }

    public SpringConfigManager(String webContentDir, String webXmlFile, Properties options, String scopeFileName) {
        this.webContentDir = webContentDir;
        this.options = options;
        this.webXmlFile = webXmlFile;
        this.scopeFileName = scopeFileName;
        this.beanAndValidatorManager = new SpringBeanAndValidatorManager();
    }

    public String getWebXmlFile() {
        return this.webXmlFile;
    }

    public String getScopeFileName() {
        return this.scopeFileName;
    }

    public ArrayList<String> getSourceDirectoryList() {
        if (this.sourceDirectoryList == null) {
            this.sourceDirectoryList = JavaUtils.retrieveSourceDirectoryList((String)this.scopeFileName);
        }
        return this.sourceDirectoryList;
    }

    public String getWebContentDir() {
        return this.webContentDir;
    }

    public Properties getOptions() {
        return this.options;
    }

    boolean isSpringApp() {
        return this.isSpringApp;
    }

    float getVersionNumber() {
        return this.versionNumber;
    }

    public SpringBeanAndValidatorManager getBeanAndValidatorManager() {
        return this.beanAndValidatorManager;
    }

    public void set25AppConfigInfo(SpringAppConfigInfo spring25AppConfigInfo) {
        this.spring25AppConfigInfo = spring25AppConfigInfo;
    }

    public SpringAppConfigInfo get25AppConfigInfo() {
        return this.spring25AppConfigInfo;
    }

    public boolean isAutoBeanDiscoveryEnabled() {
        return true;
    }

    public boolean isJSR303BeanValidatorEnabled() {
        if (this.enableWebMvcAnnotationSet) {
            return true;
        }
        boolean result = false;
        if (this.contextConfigfile2FileParserMap.isEmpty()) {
            this.findAndParseConfigFiles();
        }
        for (String springContextFileName : this.contextConfigfile2FileParserMap.keySet()) {
            SpringAppContextFileParser contextFileParser = this.contextConfigfile2FileParserMap.get(springContextFileName);
            result = contextFileParser.isJSR303BeanValidatorEnabled();
            if (!result) continue;
            return true;
        }
        return false;
    }

    private SpringAppContextFileParser createOrFindSpringAppContextFileParser(String springContextConfigFileName) {
        try {
            SpringAppContextFileParser contextFileParser;
            if (this.contextConfigfile2FileParserMap.containsKey(springContextConfigFileName)) {
                contextFileParser = this.contextConfigfile2FileParserMap.get(springContextConfigFileName);
            } else {
                contextFileParser = new SpringAppContextFileParser(springContextConfigFileName);
                this.contextConfigfile2FileParserMap.put(springContextConfigFileName, contextFileParser);
            }
            return contextFileParser;
        }
        catch (IOException e) {
            TaintLogger.i().getLogger().warn((Object)Messages.getString((String)"framework.handler.exception", (Object[])new Object[]{e.toString() + Messages.getTraceFromException((Exception)e)}));
        }
        catch (SAXException e) {
            TaintLogger.i().getLogger().warn((Object)Messages.getString((String)"framework.handler.exception", (Object[])new Object[]{e.toString() + Messages.getTraceFromException((Exception)e)}));
        }
        return null;
    }

    public Set<String> getAllAutoBeanDiscoverPackages() {
        HashSet result = HashSetFactory.make();
        if (this.contextConfigfile2FileParserMap.isEmpty()) {
            this.findAndParseConfigFiles();
        }
        for (String springContextFileName : this.contextConfigfile2FileParserMap.keySet()) {
            SpringAppContextFileParser contextFileParser = this.contextConfigfile2FileParserMap.get(springContextFileName);
            result.addAll(contextFileParser.getAutoBeanDiscoverPackages());
        }
        return result;
    }

    public void findAndParseConfigFiles(F4FApp f4fApp) {
        String contextConfigLocValue = this.checkAppForWebSpringSettings(f4fApp);
        if (this.isSpringApp && contextConfigLocValue != null && contextConfigLocValue.trim().length() > 0) {
            this.processContextConfigLoc(contextConfigLocValue);
        }
    }

    public String checkAppForWebSpringSettings(F4FApp f4fApp) {
        String contextConfigLocValue = null;
        Collection theClasses = f4fApp.getAllApplicationClasses();
        IClassHierarchy cha = f4fApp.getClassHierarchy();
        TypeReference webInitTypeReference = TypeReference.findOrCreate((ClassLoaderReference)ClassLoaderReference.Application, (String)"Lorg/springframework/web/WebApplicationInitializer");
        IClass webApplicationInitializerInterface = cha.lookupClass(webInitTypeReference);
        for (IClass currentClass : theClasses) {
            Collection classAnnotations;
            if (webApplicationInitializerInterface != null && !cha.isInterface(currentClass.getReference()) && cha.implementsInterface(currentClass, webApplicationInitializerInterface)) {
                this.versionNumber = 3.1f;
                this.isSpringApp = true;
                Collection onStartupMethods = f4fApp.getClassMethods(currentClass, "onStartup");
                if (onStartupMethods.size() == 1) {
                    IMethod onStartupMethod = (IMethod)onStartupMethods.iterator().next();
                    contextConfigLocValue = this.processOnStartupMethod(onStartupMethod, f4fApp, cha, currentClass);
                }
            }
            if ((classAnnotations = f4fApp.getClassAnnotations(currentClass)).isEmpty()) continue;
            for (Annotation annot : classAnnotations) {
                String theAnnotTypeName = annot.getType().toString();
                if (theAnnotTypeName.contains("EnableWebMvc")) {
                    this.enableWebMvcAnnotationSet = true;
                    continue;
                }
                if (theAnnotTypeName.contains("ComponentScan")) {
                    if (annot.getNamedArguments().get("value") != null) {
                        this.componentScanPackages.add(Util.cleanString(((AnnotationsReader.ElementValue)annot.getNamedArguments().get("value")).toString()));
                        continue;
                    }
                    TypeReference typeRef = currentClass.getReference();
                    if (typeRef == null) continue;
                    String packageName = typeRef.getName().getPackage().toString();
                    this.componentScanPackages.add(packageName);
                    continue;
                }
                if (!theAnnotTypeName.contains("Configuration")) continue;
                this.handleConfigurationAnnotation(f4fApp, cha, currentClass);
            }
        }
        return contextConfigLocValue;
    }

    public void findAndParseConfigFiles() {
        try {
            String defaultConfigFileName;
            File appConfigFile;
            if (this.webXmlFile == null || this.webXmlFile.length() > 0 || !new File(this.webXmlFile).exists()) {
                return;
            }
            TaintLogger.i().getLogger().info((Object)Messages.getString((String)"framework.examine", (Object[])new Object[]{this.webXmlFile}));
            DOMParserWithLineNumbers parser = new DOMParserWithLineNumbers(this.webXmlFile);
            Document document = parser.getDocument();
            NodeList servletClasses = document.getElementsByTagName("servlet-class");
            for (int i = 0; i < servletClasses.getLength(); ++i) {
                TaintLogger.i().getLogger().info((Object)Messages.getString((String)"framework.node.found", (Object[])new Object[]{"servlet-class=" + servletClasses.item(i).getTextContent()}));
                if (!servletClasses.item(i).getTextContent().trim().equals("org.springframework.web.servlet.DispatcherServlet")) continue;
                this.isSpringApp = true;
                this.versionNumber = -1.0f;
            }
            if (!this.isSpringApp) {
                return;
            }
            String contextConfigLocValueFromWebXML = this.oldCodeAdapter.getContextParamValue(this.webXmlFile, "contextConfigLocation");
            if (contextConfigLocValueFromWebXML != null) {
                this.processContextConfigLoc(contextConfigLocValueFromWebXML);
            }
            if ((appConfigFile = new File(defaultConfigFileName = this.webXmlFile.substring(0, this.webXmlFile.indexOf("web.xml")) + File.separator + "applicationContext.xml")).exists()) {
                TaintLogger.i().getLogger().info((Object)Messages.getString((String)"framework.examine", (Object[])new Object[]{defaultConfigFileName}));
                SpringAppContextFileParser contextFileParser = this.createOrFindSpringAppContextFileParser(defaultConfigFileName);
                float versionNumberFromConfigFile = contextFileParser.getSpringVersionNumber();
                if (this.versionNumber < versionNumberFromConfigFile) {
                    this.versionNumber = versionNumberFromConfigFile;
                }
            }
            Set<String> servletNameList = this.oldCodeAdapter.getServletNames(this.webXmlFile);
            for (String servletName : servletNameList) {
                String configFileLocFromInitParams;
                String fileName = servletName + "-servlet.xml";
                String fullServletFileName = this.webXmlFile.substring(0, this.webXmlFile.indexOf("web.xml")) + fileName;
                File servletXmlFile = new File(fullServletFileName);
                if (servletXmlFile.exists()) {
                    TaintLogger.i().getLogger().info((Object)Messages.getString((String)"framework.examine", (Object[])new Object[]{fullServletFileName}));
                    SpringAppContextFileParser contextFileParser = this.createOrFindSpringAppContextFileParser(fullServletFileName);
                    float versionNumberFromConfigFile = contextFileParser.getSpringVersionNumber();
                    if (this.versionNumber < versionNumberFromConfigFile) {
                        this.versionNumber = versionNumberFromConfigFile;
                    }
                }
                if ((configFileLocFromInitParams = this.oldCodeAdapter.getInitParamsForServletName(this.webXmlFile, servletName, "contextConfigLocation")) == null) continue;
                this.processContextConfigLoc(configFileLocFromInitParams);
            }
            TaintLogger.i().getLogger().info((Object)Messages.getString((String)"framework.found", (Object[])new Object[]{"version=" + Float.toString(this.versionNumber)}));
        }
        catch (IOException e) {
            TaintLogger.i().getLogger().warn((Object)Messages.getString((String)"framework.handler.exception", (Object[])new Object[]{e.toString() + Messages.getTraceFromException((Exception)e)}));
        }
        catch (SAXException e) {
            TaintLogger.i().getLogger().warn((Object)Messages.getString((String)"framework.handler.exception", (Object[])new Object[]{e.toString() + Messages.getTraceFromException((Exception)e)}));
        }
    }

    public String getRootUrl() {
        try {
            if (this.urlMappingFromJavaConfig != null && this.urlMappingFromJavaConfig.trim().length() > 0) {
                return this.urlMappingFromJavaConfig;
            }
            if (this.webXmlFile == null || this.webXmlFile.trim().length() == 0) {
                return "/";
            }
            String rootURL = this.oldCodeAdapter.getRootUrl(this.webXmlFile);
            if (rootURL != null && rootURL.trim().length() > 0) {
                return rootURL;
            }
            return "/";
        }
        catch (Exception e) {
            TaintLogger.i().getLogger().warn((Object)Messages.getString((String)"framework.handler.exception", (Object[])new Object[]{e.toString() + Messages.getTraceFromException((Exception)e)}));
            return null;
        }
    }

    public boolean getUsingJavaConfig() {
        return this.usingJavaConfig;
    }

    public Set<String> getPathsToViewEntrypoints(IMethod controllerMethod, AnalysisCache cache) {
        ISpringViewResolver viewResolver = this.getViewResolver();
        if (viewResolver == null) {
            return Collections.emptySet();
        }
        Set possibleViewNames = ModelAndViewUtil.getPossibleViewNames((IMethod)controllerMethod, (AnalysisCache)cache, null);
        HashSet paths = HashSetFactory.make();
        for (String viewName : possibleViewNames) {
            paths.addAll(viewResolver.resolveView(viewName));
        }
        return paths;
    }

    public ISpringViewResolver getViewResolver() {
        HashSet springBeanInfoSet = HashSetFactory.make(this.springConfigBeanInfoMap.values());
        for (SpringConfigBeanInfo beanInfo : springBeanInfoSet) {
            String classAttr = beanInfo.getClassAttr();
            if (classAttr != null && classAttr.equals("org.springframework.web.servlet.view.InternalResourceViewResolver")) {
                return SpringConfigManager.handleInternalResourceViewResolver(beanInfo);
            }
            if (classAttr == null || !classAttr.equals("org.springframework.web.servlet.view.UrlBasedViewResolver")) continue;
            return SpringConfigManager.handleUrlBasedViewResolver(beanInfo);
        }
        return null;
    }

    public String resolveRelativeFilePath(String fileName) {
        if (fileName.startsWith("classpath:")) {
            return this.resolveFilePathWithClasspath(fileName, this.webContentDir);
        }
        String fullContextConfigFilePath = null;
        fullContextConfigFilePath = fileName.charAt(0) == File.separatorChar || fileName.charAt(0) == '/' ? this.webContentDir + fileName : this.webContentDir + File.separator + fileName;
        File configFile = new File(fullContextConfigFilePath = fullContextConfigFilePath.replace('\\', File.separatorChar).replace('/', File.separatorChar));
        if (!configFile.exists() && this.webContentDir.contains("WEB-INF") && fileName.contains("WEB-INF")) {
            fullContextConfigFilePath = this.webContentDir.substring(0, this.webContentDir.indexOf("WEB-INF")) + fileName.substring(fileName.indexOf("WEB-INF"));
            fullContextConfigFilePath = fullContextConfigFilePath.replace('\\', File.separatorChar).replace('/', File.separatorChar);
            System.out.println(fullContextConfigFilePath);
        }
        return fullContextConfigFilePath;
    }

    public ArrayList<String> getDispatcherServletsThroughApp() {
        return this.dispatcherServletsThroughApp;
    }

    public ArrayList<String> getFreemarkerFileList() {
        if (this.freeMarkerFileList == null) {
            this.freeMarkerFileList = new ArrayList();
            this.collectAllFreeMarkerFiles(this.webContentDir, "");
        }
        return this.freeMarkerFileList;
    }

    private void collectAllFreeMarkerFiles(String directory, String curSubDir) {
        File dirFile = new File(directory + File.separatorChar + curSubDir);
        String[] freeMarkerFilesInDir = dirFile.list(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".ftl");
            }
        });
        for (String fileName : freeMarkerFilesInDir) {
            this.freeMarkerFileList.add(fileName);
        }
        for (File f : dirFile.listFiles()) {
            if (!f.isDirectory()) continue;
            this.collectAllFreeMarkerFiles(dirFile.getAbsolutePath(), f.getName());
        }
    }

    private String resolveFilePathWithClasspath(String filePath, String webContentDir) {
        if (!filePath.startsWith("classpath:")) {
            return filePath;
        }
        String resultFilePath = filePath;
        if (webContentDir.endsWith("_staging")) {
            File webContentFolder = new File(webContentDir);
            File appRoot = webContentFolder.getParentFile();
            int index = filePath.lastIndexOf("\\");
            if (index < 0) {
                index = filePath.lastIndexOf("/");
            }
            index = index < 0 ? 0 : ++index;
            String fileNameWithoutPath = filePath.substring(index);
            Iterator iter = FileUtils.iterateFiles((File)appRoot, (IOFileFilter)new NameFileFilter(fileNameWithoutPath), (IOFileFilter)TrueFileFilter.INSTANCE);
            if (!iter.hasNext()) {
                TaintLogger.i().getLogger().info((Object)Messages.getString((String)"framework.missing.file", (Object[])new Object[]{filePath}));
                return resultFilePath;
            }
            while (iter.hasNext()) {
                try {
                    resultFilePath = ((File)iter.next()).getCanonicalPath();
                    if (!resultFilePath.endsWith(filePath.substring("classpath:".length()))) continue;
                    break;
                }
                catch (IOException e) {
                    TaintLogger.i().getLogger().info((Object)Messages.getString((String)"framework.handler.exception", (Object[])new Object[]{e.toString() + Messages.getTraceFromException((Exception)e)}));
                    TaintLogger.i().getLogger().info((Object)Messages.getString((String)"framework.missing.file", (Object[])new Object[]{filePath + " using classpath"}));
                }
            }
        }
        return resultFilePath;
    }

    private String processOnStartupMethod(IMethod onStartupMethod, F4FApp f4fApp, IClassHierarchy cha, IClass currentClass) {
        AnalysisCache cache = new AnalysisCache();
        IR ir = LangIndependentWalaUtil.getIR((IMethod)onStartupMethod, (AnalysisCache)cache);
        DefUse du = LangIndependentWalaUtil.getDU((IR)ir, (AnalysisCache)cache);
        TypeInference ti = null;
        String contextConfigLocValue = "";
        Language lang = currentClass.getClassLoader().getLanguage();
        for (SSAInstruction instr : Iterator2Iterable.make((Iterator)ir.iterateNormalInstructions())) {
            String firstParamString;
            Collection firstParams;
            String declaringClassName;
            if (!(instr instanceof SSAAbstractInvokeInstruction)) continue;
            SSAAbstractInvokeInstruction call = (SSAAbstractInvokeInstruction)instr;
            CallSiteReference callSiteRef = call.getCallSite();
            MethodReference targetRef = callSiteRef.getDeclaredTarget();
            String vdbTargetName = F4FActionProcessor.getVDBSig((MethodReference)targetRef, (Language)lang, (IClassHierarchy)cha);
            if (vdbTargetName.indexOf("javax.servlet.ServletContext.addServlet") != -1) {
                TypeReference inputObjectType;
                String typeName;
                if (ti == null) {
                    ti = TypeInference.make((IR)ir, (boolean)true);
                }
                String string = typeName = (inputObjectType = ti.getType(call.getUse(2)).getTypeReference()) != null ? VDBJavaUtil.jvmToVDBType((String)inputObjectType.getName().toString()) : "java.lang.Object";
                if (typeName.indexOf("org.springframework.web.servlet.DispatcherServlet") != -1) {
                    int firstParamIndex = call.getUse(1);
                    StringConstantFlow flow = StringConstantFlow.makeIntraproc((IR)ir, (DefUse)du);
                    Collection firstParams2 = flow.findIntraprocStringsFlowingToVar(firstParamIndex);
                    if (firstParams2.size() == 1) {
                        String firstParamString2 = (String)firstParams2.iterator().next();
                        this.dispatcherServletsThroughApp.add(firstParamString2);
                    }
                }
            }
            if (vdbTargetName.indexOf(".setConfigLocation(") != -1 && (declaringClassName = VDBJavaUtil.jvmToVDBType((String)targetRef.getDeclaringClass().getName().toString())).indexOf("XmlWebApplicationContext") != -1) {
                int firstParamIndex = call.getUse(1);
                StringConstantFlow flow = StringConstantFlow.makeIntraproc((IR)ir, (DefUse)du);
                firstParams = flow.findIntraprocStringsFlowingToVar(firstParamIndex);
                if (firstParams.size() >= 1) {
                    Iterator iterator = firstParams.iterator();
                    String firstParamStrings = "";
                    while (iterator.hasNext()) {
                        if (firstParamStrings.length() > 0) {
                            firstParamStrings = firstParamStrings + "," + (String)iterator.next();
                            continue;
                        }
                        firstParamStrings = (String)iterator.next();
                    }
                    contextConfigLocValue = contextConfigLocValue.trim().length() > 0 ? contextConfigLocValue + "," + firstParamStrings : firstParamStrings;
                }
            }
            if (vdbTargetName.indexOf(".setConfigLocations(") != -1 && (declaringClassName = VDBJavaUtil.jvmToVDBType((String)targetRef.getDeclaringClass().getName().toString())).indexOf("XmlWebApplicationContext") != -1) {
                int arrayParamVn = call.getUse(1);
                Iterator iterator = du.getUses(arrayParamVn);
                SymbolTable symbolTable = ir.getSymbolTable();
                String firstParamStrings = "";
                while (iterator.hasNext()) {
                    String thisStringConst;
                    int valVn;
                    SSAInstruction thisInstruction = (SSAInstruction)iterator.next();
                    if (!(thisInstruction instanceof SSAArrayStoreInstruction) || !symbolTable.isStringConstant(valVn = ((SSAArrayStoreInstruction)thisInstruction).getValue()) || (thisStringConst = symbolTable.getStringValue(valVn)) == null || thisStringConst.trim().length() <= 0) continue;
                    if (firstParamStrings.length() > 0) {
                        firstParamStrings = firstParamStrings + "," + thisStringConst;
                        continue;
                    }
                    firstParamStrings = thisStringConst;
                }
                contextConfigLocValue = contextConfigLocValue.trim().length() > 0 ? contextConfigLocValue + "," + firstParamStrings : firstParamStrings;
            }
            if (vdbTargetName.indexOf("addMapping(") == -1 || (declaringClassName = VDBJavaUtil.jvmToVDBType((String)targetRef.getDeclaringClass().getName().toString())).indexOf("javax.servlet.ServletRegistration") == -1) continue;
            int firstParamIndex = call.getUse(1);
            StringConstantFlow flow = StringConstantFlow.makeIntraproc((IR)ir, (DefUse)du);
            firstParams = flow.findIntraprocStringsFlowingToVar(firstParamIndex);
            if (firstParams.size() != 1) continue;
            this.urlMappingFromJavaConfig = firstParamString = (String)firstParams.iterator().next();
        }
        return contextConfigLocValue;
    }

    private void processContextConfigLoc(String contextConfigLocValue) {
        String[] configFilePaths;
        for (String path : configFilePaths = contextConfigLocValue.split("(,| )+")) {
            SpringAppContextFileParser contextFileParser;
            float versionNumberFromConfigFile;
            String contextConfigFileName = this.resolveRelativeFilePath(path);
            File contextConfigFile = new File(contextConfigFileName);
            if (!contextConfigFile.exists() || !(this.versionNumber < (versionNumberFromConfigFile = (contextFileParser = this.createOrFindSpringAppContextFileParser(contextConfigFileName)).getSpringVersionNumber()))) continue;
            this.versionNumber = versionNumberFromConfigFile;
        }
    }

    private void handleConfigurationAnnotation(F4FApp f4fApp, IClassHierarchy cha, IClass currentClass) {
        this.usingJavaConfig = true;
        Language lang = currentClass.getClassLoader().getLanguage();
        Collection methods = f4fApp.getMethodsDeclaredInClass(currentClass);
        for (IMethod currentMethod : methods) {
            Collection methodAnnotations = f4fApp.getMethodAnnotations(currentMethod);
            AnalysisCache methodCache = new AnalysisCache();
            IR methodIR = LangIndependentWalaUtil.getIR((IMethod)currentMethod, (AnalysisCache)methodCache);
            for (Annotation methodAnnotation : methodAnnotations) {
                if (!methodAnnotation.getType().toString().contains("Bean")) continue;
                TypeReference returnTypeRef = currentMethod.getReturnType();
                String beanClassName = VDBJavaUtil.jvmToVDBType((String)returnTypeRef.getName().toString());
                DefUse methodDU = LangIndependentWalaUtil.getDU((IR)methodIR, (AnalysisCache)methodCache);
                HashMap beanProperties = HashMapFactory.make();
                TypeInference methodTypeInference = TypeInference.make((IR)methodIR, (boolean)true);
                for (SSAInstruction instr : Iterator2Iterable.make((Iterator)methodIR.iterateNormalInstructions())) {
                    String typeName;
                    SSAAbstractInvokeInstruction call;
                    CallSiteReference callSiteRef;
                    MethodReference targetRef;
                    String vdbTargetName;
                    if (!(instr instanceof SSAAbstractInvokeInstruction) || (vdbTargetName = F4FActionProcessor.getVDBSig((MethodReference)(targetRef = (callSiteRef = (call = (SSAAbstractInvokeInstruction)instr).getCallSite()).getDeclaredTarget()), (Language)lang, (IClassHierarchy)cha)).length() <= 3 || !vdbTargetName.startsWith(beanClassName)) continue;
                    String methodName = targetRef.getName().toString();
                    String propertyValue = null;
                    if (methodName == null || !methodName.startsWith("set")) continue;
                    String propertyName = methodName.substring(3);
                    propertyName = SpringConfigManager.lowerCaseFirstLetter(propertyName);
                    int firstParamIndex = call.getUse(1);
                    TypeReference inputObjectType = methodTypeInference.getType(firstParamIndex).getTypeReference();
                    IClass clrKlass = cha.lookupClass(inputObjectType);
                    String string = typeName = inputObjectType != null ? VDBJavaUtil.jvmToVDBType((String)inputObjectType.getName().toString()) : "java.lang.Object";
                    if (typeName.equals("java.lang.String")) {
                        StringConstantFlow flow = StringConstantFlow.makeIntraproc((IR)methodIR, (DefUse)methodDU);
                        Collection firstParams = flow.findIntraprocStringsFlowingToVar(firstParamIndex);
                        if (firstParams.size() == 1) {
                            String firstParamString;
                            propertyValue = firstParamString = (String)firstParams.iterator().next();
                        }
                    } else {
                        SSAInstruction thisInstruction = methodDU.getDef(firstParamIndex);
                        if (thisInstruction instanceof SSALoadMetadataInstruction) {
                            SSALoadMetadataInstruction loadMetadata = (SSALoadMetadataInstruction)thisInstruction;
                            if (loadMetadata.getType().equals((Object)TypeReference.JavaLangClass)) {
                                TypeReference loadMetadataType = (TypeReference)loadMetadata.getToken();
                                propertyValue = StringStuff.jvmToReadableType((String)loadMetadataType.getName().toString());
                            } else {
                                propertyValue = typeName;
                            }
                        } else {
                            propertyValue = typeName;
                        }
                    }
                    beanProperties.put(propertyName, propertyValue);
                }
                SpringConfigBeanInfo thisSpringConfigBean = new SpringConfigBeanInfo(currentMethod.getName().toString(), beanClassName, beanProperties);
                this.springConfigBeanInfoMap.put(currentMethod.getName().toString(), thisSpringConfigBean);
            }
        }
    }

    private static ISpringViewResolver handleInternalResourceViewResolver(SpringConfigBeanInfo beanInfo) {
        String viewClass;
        Map<String, String> properties = beanInfo.getProperties();
        String prefixProp = properties.get("prefix");
        final String prefix = prefixProp != null ? prefixProp : "";
        String suffixProp = properties.get("suffix");
        final String suffix = suffixProp != null ? suffixProp : "";
        String viewClassProp = properties.get("viewClass");
        String defaultViewClass = "org.springframework.web.servlet.view.InternalResourceView";
        String string = viewClass = viewClassProp != null ? viewClassProp : defaultViewClass;
        if (viewClass.equals("org.springframework.web.servlet.view.tiles.TilesJstlView")) {
            TaintLogger.i().getLogger().info((Object)"Inside SpringConfigManager#handleInternalResourceViewResolver(), Need to provide TilesViewResolver!");
        } else if (viewClass.equals(defaultViewClass) || viewClass.equals("org.springframework.web.servlet.view.JstlView")) {
            return new ISpringViewResolver(){

                public Collection<String> resolveView(String viewName) {
                    return Collections.singleton(prefix + viewName + suffix);
                }
            };
        }
        return null;
    }

    private static ISpringViewResolver handleUrlBasedViewResolver(SpringConfigBeanInfo beanInfo) {
        String viewClass;
        Map<String, String> properties = beanInfo.getProperties();
        String prefixProp = properties.get("prefix");
        final String prefix = prefixProp != null ? prefixProp : "";
        String suffixProp = properties.get("suffix");
        final String suffix = suffixProp != null ? suffixProp : "";
        String viewClassProp = properties.get("viewClass");
        String defaultViewClass = "org.springframework.web.servlet.view.InternalResourceView";
        String string = viewClass = viewClassProp != null ? viewClassProp : defaultViewClass;
        if (viewClass.equals("org.springframework.web.servlet.view.tiles.TilesJstlView")) {
            TaintLogger.i().getLogger().info((Object)"Inside SpringConfigManager#handleUrlBasedViewResolver(), Need to provide TilesViewResolver!");
        } else if (viewClass.equals(defaultViewClass) || viewClass.equals("org.springframework.web.servlet.view.JstlView")) {
            return new ISpringViewResolver(){

                public Collection<String> resolveView(String viewName) {
                    return Collections.singleton(prefix + viewName + suffix);
                }
            };
        }
        return null;
    }

    static String lowerCaseFirstLetter(String original) {
        if (original == null || original.length() == 0) {
            return original;
        }
        return original.substring(0, 1).toLowerCase() + original.substring(1);
    }
}

