/*
 * Decompiled with CFR 0.152.
 */
package com.hcl.appscan.ifa.nlp;

import com.hcl.appscan.ifa.nlp.IFindingExporter;
import com.hcl.appscan.ifa.nlp.feature.IFindingFeature;
import com.ibm.appscan.assessment.model.Assessment;
import com.ibm.appscan.assessment.model.Finding;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Function;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;

public class FindingFeatureExporter
implements IFindingExporter {
    private Collection<IFindingFeature> m_features;

    public FindingFeatureExporter(Collection<IFindingFeature> features) {
        this.m_features = features;
    }

    private Collection<String> mapper(Function<IFindingFeature, String> converter) {
        ArrayList<String> arr = new ArrayList<String>(this.m_features.size());
        this.m_features.stream().map(converter).forEach(arr::add);
        return arr;
    }

    @Override
    public void exportAssessmentDirToCSV(File dir, String output_name) throws Exception {
        File[] files = dir.listFiles();
        BufferedWriter output = new BufferedWriter(new FileWriter(dir.getPath() + System.getProperty("file.separator") + output_name + ".csv"));
        CSVPrinter CSVprinter = new CSVPrinter((Appendable)output, CSVFormat.EXCEL);
        Collection<String> headers = this.mapper(ff -> ff.getClass().getSimpleName());
        headers.add("assessment name");
        CSVprinter.printRecord(headers);
        for (File file : files) {
            if (!file.isFile() || !file.getName().endsWith(".ozasmt")) continue;
            System.out.println("  ::" + file.getName());
            Assessment assessment = new Assessment(file, true);
            for (Finding f : assessment.getFindingList()) {
                Collection<String> record = this.mapper(ff -> ff.getFeature(f));
                record.add(file.getName());
                CSVprinter.printRecord(record);
            }
        }
        CSVprinter.close();
    }
}

