/*
 * Decompiled with CFR 0.152.
 */
package com.hcl.appscan.ifa.nlp.model.Trace;

import com.hcl.appscan.ifa.nlp.model.Trace.BaseTraceModel;
import com.hcl.appscan.ifa.nlp.model.Trace.IfaJavaService;
import com.ibm.appscan.assessment.model.Finding;
import com.ibm.appscan.ifa.common.IfaException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class LocalTraceModel
extends BaseTraceModel {
    private final int BATCH_SIZE = 100;
    private int m_temp_int = 0;
    private IfaJavaService m_service = IfaJavaService.getService();

    public static void main(String[] args) throws Exception {
        try (LocalTraceModel model = new LocalTraceModel();){
            model._main(args);
        }
    }

    @Override
    public void close() throws Exception {
        this.m_service.close();
    }

    @Override
    public Map<Finding, Float> getPredictedValue(Collection<Finding> findings) throws Exception {
        this.m_temp_int = 0;
        HashMap<Finding, Float> values = new HashMap<Finding, Float>(findings.size());
        Collection<List<Finding>> batches = findings.stream().collect(Collectors.groupingBy(f -> this.m_temp_int++ / 100)).values();
        for (List<Finding> batch : batches) {
            List<String> queries = batch.stream().map(f -> this.getFeatures((Finding)f).iterator().next()).collect(Collectors.toList());
            List<String> results = Arrays.asList(this.m_service.predict(queries));
            if (queries.size() != results.size()) {
                throw new IfaException("Number of Quires not equal to number of results");
            }
            Iterator<Finding> i = batch.iterator();
            results.stream().map(s -> Float.valueOf(Float.parseFloat(s))).forEach(f -> values.put((Finding)i.next(), (Float)f));
        }
        return values;
    }

    @Override
    public String getVersion() {
        return "Local 2.0.1";
    }
}

