/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.frameworks.highlevelapi.jaxhandler.internal.utils.jaxapp;

import com.ibm.appscan.frameworks.highlevelapi.F4FApp;
import com.ibm.appscan.frameworks.highlevelapi.jaxhandler.internal.utils.JAXUtils;
import com.ibm.appscan.frameworks.util.Messages;
import com.ibm.appscan.taint.util.logging.TaintLogger;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IField;
import com.ibm.wala.classLoader.IMethod;
import java.util.ArrayList;
import java.util.Collection;

public class JaxRSResource {
    Collection<IMethod> supportedMethods = new ArrayList<IMethod>();
    Collection<IField> contextFields = new ArrayList<IField>();
    Collection<IMethod> contextMethods = new ArrayList<IMethod>();
    IClass clazz;
    F4FApp app;

    public JaxRSResource(F4FApp app, IClass clazz) {
        this.clazz = clazz;
        this.app = app;
        this.constructRootResource();
    }

    private void constructRootResource() {
        this.supportedMethods.addAll(JAXUtils.getJAXRSHttpMethods(this.app, this.clazz));
        for (IMethod method : this.clazz.getDeclaredMethods()) {
            TaintLogger.i().getLogger().info((Object)Messages.getString((String)"framework.method.found", (Object[])new Object[]{method.getSignature()}));
            if (!JAXUtils.hasAnnotation(this.app, method, "Ljavax/ws/rs/core/Context").booleanValue()) continue;
            TaintLogger.i().getLogger().info((Object)Messages.getString((String)"framework.annotation.found", (Object[])new Object[]{"Ljavax/ws/rs/core/Context"}));
            if (method.getNumberOfParameters() != 2) continue;
            this.contextMethods.add(method);
        }
        for (IField field : this.clazz.getDeclaredInstanceFields()) {
            TaintLogger.i().getLogger().info((Object)Messages.getString((String)"framework.field.found", (Object[])new Object[]{field.getName().toString()}));
            if (!JAXUtils.hasAnnotation(this.app, field, "Ljavax/ws/rs/core/Context").booleanValue()) continue;
            TaintLogger.i().getLogger().info((Object)Messages.getString((String)"framework.annotation.found", (Object[])new Object[]{"Ljavax/ws/rs/core/Context"}));
            this.contextFields.add(field);
        }
    }

    public IClass getIClass() {
        return this.clazz;
    }

    public Collection<IMethod> getSupportedMethods() {
        return this.supportedMethods;
    }

    public Collection<IField> getContextFields() {
        return this.contextFields;
    }

    public Collection<IMethod> getContextMethods() {
        return this.contextMethods;
    }
}

