/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.sa.prefix.main;

import com.ibm.wala.util.collections.HashMapFactory;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class StringPrefix {
    public static final int SUFFIX = Integer.MAX_VALUE;
    public static final Integer RET = -1;
    private final boolean hasSuffix;
    private final String prefix;
    private final Set<Integer> envPtrs;
    private final Set<Integer> arrPtrs;
    private final Map<Integer, Integer> bodyPtrs;

    public StringPrefix(String prefix, Set<Integer> envPtrs, Map<Integer, Integer> bodyPtrs, boolean hasSuffix) {
        this(prefix, envPtrs, Collections.emptySet(), bodyPtrs, hasSuffix);
    }

    public StringPrefix(String prefix, Set<Integer> envPtrs, Set<Integer> arrPtrs, Map<Integer, Integer> bodyPtrs, boolean hasSuffix) {
        assert (!envPtrs.isEmpty() || !arrPtrs.isEmpty());
        this.prefix = prefix;
        this.envPtrs = envPtrs;
        this.arrPtrs = arrPtrs;
        if (!hasSuffix) assert (!bodyPtrs.values().contains(Integer.MAX_VALUE));
        this.bodyPtrs = bodyPtrs;
        this.hasSuffix = hasSuffix;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public Set<Integer> getEnvPtrs() {
        return Collections.unmodifiableSet(this.envPtrs);
    }

    public Set<Integer> getArrPtrs() {
        return Collections.unmodifiableSet(this.arrPtrs);
    }

    public Map<Integer, Integer> getBodyPtrs() {
        return Collections.unmodifiableMap(this.bodyPtrs);
    }

    public boolean hasSuffix() {
        return this.hasSuffix;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.arrPtrs == null ? 0 : this.arrPtrs.hashCode());
        result = 31 * result + (this.bodyPtrs == null ? 0 : this.bodyPtrs.hashCode());
        result = 31 * result + (this.envPtrs == null ? 0 : this.envPtrs.hashCode());
        result = 31 * result + (this.hasSuffix ? 1231 : 1237);
        result = 31 * result + (this.prefix == null ? 0 : this.prefix.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StringPrefix other = (StringPrefix)obj;
        if (this.arrPtrs == null ? other.arrPtrs != null : !this.arrPtrs.equals(other.arrPtrs)) {
            return false;
        }
        if (this.bodyPtrs == null ? other.bodyPtrs != null : !this.bodyPtrs.equals(other.bodyPtrs)) {
            return false;
        }
        if (this.envPtrs == null ? other.envPtrs != null : !this.envPtrs.equals(other.envPtrs)) {
            return false;
        }
        if (this.hasSuffix != other.hasSuffix) {
            return false;
        }
        return !(this.prefix == null ? other.prefix != null : !this.prefix.equals(other.prefix));
    }

    public StringPrefix fitToLength(int maxLength) {
        HashMap newBodyPtrs;
        if (this.prefix.length() <= maxLength) {
            return this;
        }
        boolean hasSuffix = true;
        String newPrefix = this.prefix.substring(0, maxLength);
        if (this.bodyPtrs != null) {
            newBodyPtrs = HashMapFactory.make();
            for (Map.Entry<Integer, Integer> e : this.bodyPtrs.entrySet()) {
                int ptr = e.getKey();
                int charOrGlob = e.getValue();
                if (charOrGlob == Integer.MAX_VALUE || charOrGlob < newPrefix.length()) {
                    newBodyPtrs.put(ptr, charOrGlob);
                    continue;
                }
                newBodyPtrs.put(ptr, Integer.MAX_VALUE);
            }
        } else {
            newBodyPtrs = null;
        }
        assert (this.envPtrs != null);
        return new StringPrefix(newPrefix, this.envPtrs, this.arrPtrs, newBodyPtrs, hasSuffix);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.prefix);
        if (this.hasSuffix) {
            sb.append("+?\n");
        }
        sb.append("\tENV PTRS: " + this.envPtrs + "\n");
        if (!this.arrPtrs.isEmpty()) {
            sb.append("\tARR PTRS: " + this.arrPtrs + "\n");
        }
        sb.append("\tBODY PTRS: " + this.bodyPtrs);
        return sb.toString();
    }

    public boolean subsumes(StringPrefix other) {
        if (!this.hasSuffix && other.hasSuffix) {
            return false;
        }
        if (!other.prefix.startsWith(this.prefix)) {
            return false;
        }
        if (!other.envPtrs.equals(this.envPtrs)) {
            return false;
        }
        if (!other.arrPtrs.equals(this.arrPtrs)) {
            return false;
        }
        if (other.bodyPtrs.size() != this.bodyPtrs.size()) {
            return false;
        }
        for (Map.Entry<Integer, Integer> e : other.bodyPtrs.entrySet()) {
            int key = e.getKey();
            int val = e.getValue();
            Integer myVal = this.bodyPtrs.get(key);
            if (myVal == null) {
                return false;
            }
            if (myVal == val || val >= this.prefix.length() && myVal == Integer.MAX_VALUE) continue;
            return false;
        }
        return true;
    }

    public static StringPrefix unknown(int envPtr) {
        return new StringPrefix("", Collections.singleton(envPtr), Collections.emptyMap(), true);
    }

    public static StringPrefix unknown(Set<Integer> envPtrs, int arrPtr) {
        return new StringPrefix("", envPtrs, Collections.singleton(arrPtr), Collections.emptyMap(), true);
    }
}

