/*
 * Decompiled with CFR 0.152.
 */
package com.hcl.appscan.discovery.java.utils;

import com.ibm.appscan.common.CommonCore;
import com.ibm.appscan.common.Messages;
import com.ibm.appscan.common.logging.Message;
import com.ibm.appscan.common.model.IBuildInfo;
import com.ibm.appscan.common.model.IScanTargetMinProxy;
import com.ibm.appscan.common.utils.ClasspathUtil;
import com.ibm.appscan.common.utils.DirectoryUtil;
import com.ibm.appscan.common.utils.ProcessRunner;
import com.ibm.appscan.common.utils.SystemUtil;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.bcel.util.ClassPath;

public class JDKHelper {
    private static final String BOOTSTRAP_CLASSPATH_PROP = "sun.boot.class.path";
    private static final String BOOTSTRAP_CLASSPATH = "bootstrap_classpath";
    private static final String EXTENSION_JARS_PROP = "java.ext.dirs";
    private static final String EXTENSION_JARS = "extension_jars";
    private static final String JAVA_VERSION_PROP = "java.version";

    private static ProcessRunner createJavaRunner(String javaExec) {
        return new ProcessRunner(new String[]{javaExec, "-cp", CommonCore.getDirectoryLocator().getLib() + "com.static.analyzer.shared.jar", "com.ibm.appscan.shared.utils.SystemPropertyRetriever", BOOTSTRAP_CLASSPATH_PROP, EXTENSION_JARS_PROP, JAVA_VERSION_PROP});
    }

    private static void setProperties(IScanTargetMinProxy proxy, Map<String, String> properties) {
        IBuildInfo info = proxy.getBuildInfo();
        String val = properties.get(JAVA_VERSION_PROP);
        if (val != null) {
            String[] versionStrings = val.split("\\.");
            int version = 0;
            try {
                version = Integer.parseInt(versionStrings[0]);
            }
            catch (NumberFormatException ex) {
                version = 0;
            }
            if (version < 9) {
                val = properties.get(BOOTSTRAP_CLASSPATH_PROP);
                if (val != null) {
                    info.setProperty(BOOTSTRAP_CLASSPATH, val);
                }
                if ((val = properties.get(EXTENSION_JARS_PROP)) != null) {
                    info.setProperty(EXTENSION_JARS, val);
                }
            } else {
                info.setProperty(BOOTSTRAP_CLASSPATH, JDKHelper.addJmodsToClasspath());
                info.setProperty(EXTENSION_JARS, "");
                if (CommonCore.getConfiguration().getSettingValueBooleanDefaultTrue("include_deprecated_ee_jars")) {
                    ClasspathUtil.appendToClasspath((String)JDKHelper.getDeprecatedJars(), (IScanTargetMinProxy)proxy);
                }
            }
        }
    }

    public static String getJavaExec(IScanTargetMinProxy proxy) {
        File javaExec = null;
        String binJava = "bin/java" + (SystemUtil.isWindows() ? ".exe" : "");
        String javaHome = proxy.inheritedGetBuidInfo("jdk_path");
        if (javaHome == null) {
            javaHome = System.getProperty("alternateJDK");
        }
        if (javaHome != null && new File(javaHome).isDirectory() && !(javaExec = new File(javaHome = javaHome.replaceAll("^\"|\"$", ""), binJava)).isFile()) {
            javaExec = new File(javaHome, "jre/" + binJava);
        }
        if (javaExec == null || !javaExec.isFile()) {
            javaExec = new File(CommonCore.getDirectoryLocator().getProductRoot(), "jre/" + binJava);
        }
        return javaExec.getPath();
    }

    public static String addJmodsToClasspath() {
        StringBuilder sb = new StringBuilder();
        String cp = ClassPath.getClassPath();
        String[] entries = cp.split(File.pathSeparator);
        for (int i = 0; i < entries.length; ++i) {
            File entry = new File(entries[i]);
            if (entry.getParentFile() == null || !entry.getName().endsWith(".jmod")) continue;
            sb.append(entry.getAbsolutePath() + File.pathSeparator);
        }
        if (sb.length() > 0) {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }

    public static String extractAndAddSystemJmodsToClasspath() {
        StringBuilder sb = new StringBuilder();
        String cp = ClassPath.getClassPath();
        String[] entries = cp.split(File.pathSeparator);
        for (int i = 0; i < entries.length; ++i) {
            File entry = new File(entries[i]);
            if (!entry.isFile() || !entry.getName().endsWith(".jmod")) continue;
            String extractFolder = entry.getName().replace(".", "-");
            File dir = new File(CommonCore.getDirectoryLocator().getJRE() + "temp", extractFolder);
            if (!dir.exists()) {
                try {
                    sb = JDKHelper.extractJmod(entry.getAbsolutePath(), dir.getAbsolutePath(), sb);
                }
                catch (IOException | InterruptedException e) {
                    CommonCore.getLogManager().log(new Message((Throwable)new IOException(Messages.getMessage((String)"err.extract.entry", (Object[])new Object[]{entry.getName()}))));
                }
                continue;
            }
            sb.append(dir.getAbsolutePath() + File.separator + "classes" + File.pathSeparator);
        }
        if (sb.length() > 0) {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }

    private static StringBuilder extractJmod(String jmodFilePath, String dest, StringBuilder sb) throws IOException, InterruptedException {
        File dir = new File(dest);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        File jreBin = new File(CommonCore.getDirectoryLocator().getJRE(), "bin");
        File jmodInstallPath = new File(jreBin, "jmod");
        ProcessBuilder processBuilder = new ProcessBuilder(jmodInstallPath.getAbsolutePath(), "extract", jmodFilePath);
        processBuilder.directory(new File(dest));
        Process process = processBuilder.start();
        int exitCode = process.waitFor();
        if (exitCode != 0) {
            throw new IOException("Error extracting Jmod file");
        }
        String classpath = dest + File.separator + "classes";
        sb.append(classpath).append(File.pathSeparator);
        return sb;
    }

    public static String getDeprecatedJars() {
        StringBuilder _sb = new StringBuilder();
        File _dir = new File(CommonCore.getDirectoryLocator().getProductRoot(), "jre/EE");
        File[] _entries = DirectoryUtil.getFiles((File)_dir, (String)".jar");
        for (int i = 0; i < _entries.length; ++i) {
            _sb.append(_entries[i].getAbsolutePath() + File.pathSeparator);
        }
        if (_sb.length() > 0) {
            _sb.deleteCharAt(_sb.length() - 1);
        }
        return _sb.toString();
    }

    public static void setJDKProperties(IScanTargetMinProxy proxy) throws IOException {
        String javaExec = JDKHelper.getJavaExec(proxy);
        IScanTargetMinProxy _proxy = proxy;
        final HashMap<String, String> properties = new HashMap<String, String>();
        ProcessRunner runner = JDKHelper.createJavaRunner(javaExec);
        ProcessRunner.StreamHandler handler = new ProcessRunner.StreamHandler(){

            protected void handle(String line) {
                if (line.startsWith(JDKHelper.BOOTSTRAP_CLASSPATH_PROP) || line.startsWith(JDKHelper.EXTENSION_JARS_PROP) || line.startsWith(JDKHelper.JAVA_VERSION_PROP)) {
                    String key = line.substring(0, line.indexOf(61));
                    String val = line.substring(line.indexOf(61) + 1);
                    properties.put(key, val);
                }
            }
        };
        int rc = runner.run(handler, new ProcessRunner.StreamHandler());
        IOException e = handler.getException();
        if (rc != 0 || e != null) {
            throw new IOException(Messages.getMessage((String)"err.jdk", (Object[])new Object[]{rc}), e);
        }
        if (properties.size() != 3) {
            CommonCore.getIOConsole().println(Messages.getMessage((String)"jdk.helper.cmd", (Object[])new Object[]{runner.getCommandArgs()}));
            String _out = "[";
            for (Map.Entry entry : properties.entrySet()) {
                _out = _out + (String)entry.getKey() + "=" + (String)entry.getValue() + ", ";
            }
            if (_out.length() > 2) {
                _out = _out.substring(0, _out.length() - 2);
            }
            _out = _out + "]";
            CommonCore.getIOConsole().println(Messages.getMessage((String)"jdk.helper.out", (Object[])new Object[]{_out}));
            throw new IOException(Messages.getMessage((String)"err.jdk.props", (Object[])new Object[0]));
        }
        JDKHelper.setProperties(_proxy, properties);
    }
}

