/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.discovery.util;

import com.ibm.appscan.common.CommonCore;
import com.ibm.appscan.common.utils.ProcessRunner;
import com.ibm.appscan.common.utils.SystemUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public abstract class ToolRunner {
    private File m_directory;
    private ProcessRunner m_builder;
    private ProcessRunner.StreamHandler m_streamHandler;

    public ToolRunner(File directory, boolean showOutput) {
        this.m_directory = directory;
        this.setStreamHandler(showOutput);
    }

    public int run(List<String> arguments) throws IOException {
        ArrayList<String> args = new ArrayList<String>();
        if (SystemUtil.isWindows()) {
            args.add("cmd");
            args.add("/c");
        } else {
            args.add("/bin/sh");
            args.add("-c");
        }
        StringBuffer script = new StringBuffer();
        script.append(this.getExecutable());
        if (SystemUtil.enableFIPS()) {
            arguments.addAll(this.getFipsOptions());
        }
        for (String str : arguments) {
            script.append(" ").append(str);
        }
        args.add(script.toString());
        this.m_builder = new ProcessRunner(args);
        this.m_builder.setDirectory(this.m_directory);
        return this.m_builder.run(this.m_streamHandler);
    }

    protected abstract String getExecutable();

    private void setStreamHandler(boolean showOutput) {
        this.m_streamHandler = showOutput ? new ProcessRunner.StreamHandler(){

            protected boolean handle(BufferedReader reader) throws IOException {
                String line;
                while ((line = reader.readLine()) != null) {
                    CommonCore.getIOConsole().println(line);
                }
                return super.handle(reader);
            }
        } : new ProcessRunner.StreamHandler();
    }

    private List<String> getFipsOptions() {
        ArrayList<String> options = new ArrayList<String>();
        options.add("-Djdk.module.path=" + CommonCore.getDirectoryLocator().getFIPS());
        options.add("-Dssl.SocketFactory.provider=org.bouncycastle.jsse.provider.SSLSocketFactoryImpl");
        options.add("-Dssl.ServerSocketFactory.provider=org.bouncycastle.jsse.provider.SSLServerSocketFactoryImpl");
        return options;
    }
}

