/*
 * Decompiled with CFR 0.152.
 */
package com.hcl.appscan.ifa.nlp.model.JavaScript;

import com.hcl.appscan.ifa.nlp.GetRules;
import com.hcl.appscan.ifa.nlp.OnnxModel;
import com.hcl.appscan.ifa.nlp.Util;
import com.hcl.appscan.ifa.nlp.feature.ConfidenceFeature;
import com.hcl.appscan.ifa.nlp.feature.ContextFeature;
import com.hcl.appscan.ifa.nlp.feature.FileFeature;
import com.hcl.appscan.ifa.nlp.feature.LineFeature;
import com.hcl.appscan.ifa.nlp.feature.MethodFeature;
import com.hcl.appscan.ifa.nlp.feature.SeverityFeature;
import com.hcl.appscan.ifa.nlp.label.InterestingLabel;
import com.hcl.appscan.ifa.nlp.label.PredictionLabel;
import com.hcl.appscan.ifa.nlp.label.PredictionProbaLabel;
import com.hcl.appscan.ifa.nlp.model.JavaScript.feature.JavaScriptContextFeature;
import com.hcl.appscan.ifa.nlp.model.JavaScript.feature.JavaScriptFilteredContextFeature;
import com.hcl.appscan.ifa.nlp.model.JavaScript.feature.JavaScriptShortFileFeature;
import com.ibm.appscan.assessment.model.Finding;
import com.ibm.appscan.common.utils.functional.Lazy;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.NoSuchElementException;

public class JavaScriptModel
extends OnnxModel {
    private static Lazy<ArrayList<String>> s_vocab = Lazy.of(JavaScriptModel::loadVocab);
    private static Lazy<Collection<String>> s_rules = Lazy.of(() -> new GetRules().getJavaScriptRules());
    public static final double DECISION_BOUNDARY = 0.5;

    public JavaScriptModel() {
        this.m_model_resource = "/com/hcl/appscan/ifa/nlp/resources/JavaScript/model.onnx";
        this.m_features = new ArrayList();
        this.m_features.add(new JavaScriptFilteredContextFeature());
        this.m_features.add(new JavaScriptShortFileFeature());
        this.m_features.add(new ConfidenceFeature());
        this.m_features.add(new MethodFeature());
        this.m_features.add(new SeverityFeature());
        this.m_readFeatures = new ArrayList(this.m_features);
        this.m_readFeatures.set(0, new JavaScriptContextFeature());
        this.m_readFeatures.set(1, new JavaScriptShortFileFeature());
        this.m_readFeatures.add(new InterestingLabel());
        this.m_testFeatures = new ArrayList(this.m_features);
        this.m_testFeatures.add(new ContextFeature());
        this.m_testFeatures.add(new PredictionProbaLabel(this));
        this.m_testFeatures.add(new PredictionLabel(this));
        this.m_testFeatures.add(new InterestingLabel());
        this.m_testFeatures.add(new FileFeature());
        this.m_testFeatures.add(new LineFeature());
    }

    public static void main(String[] args) throws Exception {
        try (JavaScriptModel model = new JavaScriptModel();){
            model._main(args);
        }
    }

    public static String filterVocab(String context) {
        context = context.trim();
        String[] splited = context.split("\\s+");
        StringBuilder new_cxt = new StringBuilder();
        for (String token : splited) {
            if (((ArrayList)s_vocab.get()).contains(token)) {
                new_cxt.append(token + " ");
                continue;
            }
            new_cxt.append("UNKNOWNTOKEN ");
        }
        return new_cxt.toString();
    }

    private static ArrayList<String> loadVocab() {
        ArrayList<String> vocab = new ArrayList<String>();
        try (BufferedReader vocab_reader = new BufferedReader(new InputStreamReader(JavaScriptModel.class.getResourceAsStream("/com/hcl/appscan/ifa/nlp/resources/JavaScript/JavaScript.vocab")));){
            while (vocab_reader.ready()) {
                vocab.add(vocab_reader.readLine());
            }
        }
        catch (Exception e) {
            throw new NoSuchElementException("Failed to load JavaScript vocab");
        }
        return vocab;
    }

    public static String preProcess(String string) {
        string = string.replaceAll("(\\'|\\\"|`)[^{}*]*?(?<!\\\\)\\1", " STRINGTOKEN ");
        string = Util.splitCamelCase(string);
        string = string.replaceAll("=", " EQUALSIGNTOKEN ");
        string = string.replaceAll("\\*", " STARSIGNTOKEN ");
        string = string.replaceAll("[0-9]+", " NUMBERTOKEN ");
        string = string.replaceAll("(?<=\\W|^)_+(?=\\W|$)", " UNDERSCORETOKEN ");
        string = string.replaceAll("[^A-Za-z]", " ");
        string = string.replaceAll("(?<=\\s|^)\\w(?=\\s|$)", "SINGLECHARTOKEN");
        string = string.replaceAll("\\s+", " ");
        string = string.toLowerCase();
        return string;
    }

    @Override
    public Boolean isInteresting(Finding f) throws Exception {
        return (double)this.getPredictedValue(f).floatValue() > 0.5;
    }

    public static Boolean isFindingLanguageJavaScript(Finding f) {
        return ((Collection)s_rules.get()).contains(f.getData().getSite().getMethod());
    }
}

