/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.internal.discovery.was;

import com.hcl.appscan.discovery.java.utils.IClasspathContributor;
import com.hcl.appscan.discovery.java.utils.IJavaStrategy;
import com.ibm.appscan.common.IProgress;
import com.ibm.appscan.common.model.CustomTargetInfo;
import com.ibm.appscan.common.model.IScanTargetProxy;
import com.ibm.appscan.common.model.ScanTargetStrategy;
import com.ibm.appscan.common.utils.DirectoryUtil;
import com.ibm.appscan.discovery.IStrategyFactoryRegistry;
import com.ibm.appscan.discovery.jsp.compilers.JSPCompilerClasspathContributor;
import com.ibm.appscan.discovery.was.Messages;
import com.ibm.appscan.internal.discovery.was.ProfileUtil;
import com.ibm.appscan.internal.discovery.was.WebSphereStrategy;
import com.ibm.appscan.internal.discovery.was.compilers.WebSphereJSPCompilerDefinition;
import java.io.File;
import java.io.IOException;

public class WebSphereProfileStrategy
extends WebSphereStrategy {
    private static final String APPS = "installedApps";

    public WebSphereProfileStrategy() {
    }

    WebSphereProfileStrategy(File profileHome, IStrategyFactoryRegistry registry, WebSphereJSPCompilerDefinition jspCompiler) {
        super(profileHome, registry, jspCompiler);
    }

    @Override
    protected File getServerHome() {
        return ProfileUtil.getServerHome(this.m_home);
    }

    @Override
    public String getType() {
        String version;
        String string = version = this.m_jspCompiler == null ? null : this.m_jspCompiler.getVersion();
        if (version == null) {
            return Messages.getMessage("was.profile", new Object[0]);
        }
        return Messages.getMessage("wasX.profile", version);
    }

    @Override
    public boolean handlesIncludesExcludes() {
        return false;
    }

    private void createTarget(IScanTargetProxy proxy, File module) {
        ScanTargetStrategy strategy = this.m_registry.getStrategy(module);
        if (strategy != null) {
            if (this.m_jspCompiler == null) {
                proxy.newScanTarget(strategy);
            } else if (strategy instanceof IJavaStrategy) {
                ((IJavaStrategy)strategy).addClasspathContributor((IClasspathContributor)new JSPCompilerClasspathContributor(this.m_jspCompiler.getName()));
                proxy.newScanTarget(strategy);
            } else {
                CustomTargetInfo info = new CustomTargetInfo();
                info.getBuildInfos().put("jsp_compiler", this.m_jspCompiler.getName());
                proxy.newScanTarget(strategy, info);
            }
        }
    }

    @Override
    public void findScanTargets(final IScanTargetProxy proxy, IProgress progress) {
        try {
            DirectoryUtil.walk((File)new File(this.m_home, APPS), (DirectoryUtil.TreeVisitor)new DirectoryUtil.TreeVisitor(){

                private boolean isModule(File fileOrDirectory) {
                    String name = fileOrDirectory.getName().toLowerCase();
                    if (name.endsWith(".ear") || name.endsWith(".rar")) {
                        WebSphereProfileStrategy.this.createTarget(proxy, fileOrDirectory);
                        return true;
                    }
                    return false;
                }

                protected boolean visitFile(File file) throws IOException {
                    this.isModule(file);
                    return true;
                }

                protected boolean preVisitDirectory(File directory) throws IOException {
                    return !this.isModule(directory);
                }
            });
        }
        catch (IOException e) {
            proxy.getErrorManager().reportError(e.getMessage(), (Throwable)e);
        }
    }
}

