/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.internal.discovery.was.compilers;

import com.ibm.appscan.common.IProgress;
import com.ibm.appscan.common.model.IBuildInfo;
import com.ibm.appscan.common.utils.ClasspathUtil;
import com.ibm.appscan.common.utils.IOUtil;
import com.ibm.appscan.common.utils.ProcessRunner;
import com.ibm.appscan.common.utils.SystemUtil;
import com.ibm.appscan.discovery.jsp.compilers.ExternalJSPCompiler;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.regex.Pattern;

public class WebSphereJSPCompiler
extends ExternalJSPCompiler {
    private String m_jspBatchCompiler;

    WebSphereJSPCompiler(File websphere, String[] classpathEntries) {
        super(classpathEntries);
        String ext = SystemUtil.isWindows() ? ".bat" : ".sh";
        this.m_jspBatchCompiler = websphere.getPath() + "/bin/JspBatchCompiler" + ext;
    }

    public String getServerType() {
        return "WEBSPHERE";
    }

    protected ProcessRunner.StreamHandler getOuputHandler() {
        final Pattern pattern = Pattern.compile("^[A-Z]+\\d+E: .*$");
        final PrintWriter log = this.initLog();
        return new ProcessRunner.StreamHandler(){

            protected void handle(String line) {
                if (pattern.matcher(line).matches()) {
                    WebSphereJSPCompiler.this.m_proxy.getErrorManager().reportError(line);
                }
                if (log == null) {
                    System.out.println(line);
                } else {
                    log.println(line);
                }
            }
        };
    }

    private String fixPath(String path) {
        return path.replace('\\', '/');
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File createResponseFile() throws IOException {
        File file = new File(this.m_outDir.getParentFile(), "compiler.args");
        PrintStream out = new PrintStream((OutputStream)new BufferedOutputStream(new FileOutputStream(file)), true, "UTF-8");
        try {
            out.println("-war.path=" + this.fixPath(this.m_webapp.getPath()));
            out.println("-compileToDir=" + this.fixPath(this.m_outDir.getPath()));
            out.println("-createDebugClassfiles=true");
            out.println("-keepgenerated=true");
            out.println("-useFullPackageNames=true");
            IBuildInfo info = this.m_proxy.getBuildInfo();
            String classpath = ClasspathUtil.joinPaths((String[])new String[]{info.getProperty("classpath"), info.getProperty("additional_classpath")});
            if (!classpath.isEmpty()) {
                out.println("-additional.classpath=" + this.fixPath(classpath));
            }
            File file2 = file;
            return file2;
        }
        finally {
            IOUtil.close((Closeable)out);
        }
    }

    protected boolean run(IProgress progress) throws Exception {
        if (this.compile(new String[]{this.m_jspBatchCompiler, "-response.file", this.createResponseFile().getAbsolutePath()}) != 0) {
            return false;
        }
        this.initMappings(new File(this.m_webapp, "WEB-INF/generated_web.xml"));
        return true;
    }
}

