/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.cli.cloud.commands;

import com.ibm.appscan.cli.cloud.Messages;
import com.ibm.appscan.cli.cloud.handlers.GetLogsHandler;
import com.ibm.appscan.cli.common.CommonCLICore;
import com.ibm.appscan.cli.common.components.Command;
import com.ibm.appscan.common.error.AppScanException;
import com.ibm.appscan.common.logging.Message;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;

public class GetLogsCommand
extends Command {
    private GetLogsHandler m_handler = new GetLogsHandler();

    public GetLogsCommand() {
    }

    public GetLogsCommand(String[] args) {
        super(args);
    }

    public void configure() {
        this.setNamespace(Messages.getMessage("command.logs.namespace", new Object[0]));
        this.setName("get_logs");
        this.setDescription(Messages.getMessage("command.getlogs.description", new Object[0]));
        this.setOptions(this.buildOptions(), false);
    }

    public Command createCommand(String[] args) {
        return new GetLogsCommand(args);
    }

    public void execute() {
        CommandLine cmd = this.getCommandLine();
        if (cmd == null) {
            return;
        }
        try {
            this.m_handler.getLogs(cmd.getOptionValue("i"), cmd.getOptionValue("d"));
        }
        catch (AppScanException e) {
            CommonCLICore.getLogManager().log(new Message((Throwable)e));
            CommonCLICore.getIOConsole().println(new Message((Throwable)e));
        }
    }

    protected Options buildOptions() {
        Options options = new Options();
        OptionBuilder.hasArg((boolean)true);
        OptionBuilder.withArgName((String)Messages.getMessage("option.scanid.argument", new Object[0]));
        OptionBuilder.isRequired();
        OptionBuilder.withDescription((String)Messages.getMessage("option.scanid.description", new Object[0]));
        options.addOption(OptionBuilder.create((String)"i"));
        OptionBuilder.hasArg((boolean)true);
        OptionBuilder.withArgName((String)Messages.getMessage("command.getlogs.path.name", new Object[0]));
        OptionBuilder.withDescription((String)Messages.getMessage("command.getlogs.path.description", new Object[0]));
        options.addOption(OptionBuilder.create((String)"d"));
        return options;
    }
}

