/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.cli.cloud.commands;

import com.ibm.appscan.cli.cloud.Messages;
import com.ibm.appscan.cli.cloud.handlers.GetResultHandler;
import com.ibm.appscan.cli.common.CommonCLICore;
import com.ibm.appscan.cli.common.components.Command;
import com.ibm.appscan.common.error.AppScanException;
import com.ibm.appscan.common.logging.Message;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;

public class GetResultCommand
extends Command {
    private GetResultHandler m_handler = new GetResultHandler();

    public GetResultCommand() {
    }

    public GetResultCommand(String[] args) {
        super(args);
    }

    public void configure() {
        this.setNamespace(Messages.getMessage("command.result.namespace", new Object[0]));
        this.setName("get_result");
        this.setDescription(Messages.getMessage("command.getresult.description", new Object[0]));
        this.setOptions(this.buildOptions(), false);
    }

    public Command createCommand(String[] args) {
        return new GetResultCommand(args);
    }

    public void execute() {
        CommandLine cmd = this.getCommandLine();
        if (cmd == null) {
            return;
        }
        String type = null;
        String destination = null;
        if (cmd.hasOption("t")) {
            type = cmd.getOptionValue("t");
        }
        if (cmd.hasOption("d")) {
            destination = cmd.getOptionValue("d");
        }
        try {
            this.m_handler.getResult(cmd.getOptionValue("i"), type, destination);
        }
        catch (AppScanException e) {
            CommonCLICore.getLogManager().log(new Message((Throwable)e));
            CommonCLICore.getIOConsole().println(new Message((Throwable)e));
        }
    }

    protected Options buildOptions() {
        Options options = new Options();
        OptionBuilder.hasArg((boolean)true);
        OptionBuilder.withArgName((String)Messages.getMessage("option.jobid.argument", new Object[0]));
        OptionBuilder.isRequired();
        OptionBuilder.withDescription((String)Messages.getMessage("command.getresult.jobId.description", new Object[0]));
        options.addOption(OptionBuilder.create((String)"i"));
        OptionBuilder.hasArg((boolean)true);
        OptionBuilder.withArgName((String)Messages.getMessage("command.getresult.type.name", new Object[0]));
        OptionBuilder.withDescription((String)Messages.getMessage("command.getresult.type.description", new Object[0]));
        options.addOption(OptionBuilder.create((String)"t"));
        OptionBuilder.hasArg((boolean)true);
        OptionBuilder.withArgName((String)Messages.getMessage("command.getresult.path.name", new Object[0]));
        OptionBuilder.withDescription((String)Messages.getMessage("command.getresult.path.description", new Object[0]));
        options.addOption(OptionBuilder.create((String)"d"));
        return options;
    }
}

