/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.cli.cloud.handlers;

import com.ibm.appscan.cli.cloud.Messages;
import com.ibm.appscan.cli.cloud.handlers.SAHandler;
import com.ibm.appscan.cli.common.CommonCLICore;
import com.ibm.appscan.cli.common.ProgressAdapter;
import com.ibm.appscan.common.IProgress;
import com.ibm.appscan.common.logging.Message;
import java.io.IOException;
import javax.net.ssl.SSLHandshakeException;
import org.apache.commons.json.JSONArray;
import org.apache.commons.json.JSONException;
import org.apache.commons.json.JSONObject;

public class ListAppsHandler
extends SAHandler {
    public ListAppsHandler() {
        this.setProgressAdapter((IProgress)new ProgressAdapter());
    }

    void listApps(JSONArray apps) throws JSONException {
        if (apps.isEmpty()) {
            this.getProgressAdapter().setStatus(new Message(1, Messages.getMessage("err.apps.none", new Object[0])));
        } else {
            for (int i = 0; i < apps.length(); ++i) {
                JSONObject app = apps.getJSONObject(i);
                CommonCLICore.getIOConsole().println(app.getString("Name") + " [ " + app.getString("Id") + " ]");
            }
        }
    }

    public void listApps() {
        try {
            if (this.m_authProvider.isTokenExpired() || !"SCX".equalsIgnoreCase(this.m_authProvider.getApiEnvironment())) {
                this.getProgressAdapter().setStatus(new Message(4, Messages.getMessage("err.scx.only", new Object[0])));
                return;
            }
            this.listApps(this.getApps());
        }
        catch (SSLHandshakeException e) {
            this.getProgressAdapter().setStatus(new Message(4, Messages.getMessage("err.ssl", this.m_authProvider.getServer())));
        }
        catch (JSONException e) {
            this.getProgressAdapter().setStatus(new Message((Throwable)e));
        }
        catch (IOException e) {
            this.getProgressAdapter().setStatus(new Message((Throwable)e));
        }
    }
}

