/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.cli.cloud.handlers;

import com.ibm.appscan.cli.cloud.handlers.SAHandler;
import com.ibm.appscan.common.http.HttpClient;
import com.ibm.appscan.common.http.HttpResponse;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.json.JSONException;
import org.apache.commons.json.JSONObject;

public class ReportHandler
extends SAHandler {
    public String generateReport(String scope, String id) throws IOException, JSONException {
        String path = String.format("/api/v4/Reports/Issues/%s/%s", scope, id);
        JSONObject json = new JSONObject();
        json.put("OdataFilter", (Object)"Scanner eq 'AppScan Static Analyzer'");
        json.put("ApplyPolicies", (Object)"All");
        json.put("SelectPolicyIds", (Object)"");
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/json");
        HttpResponse response = this.executePostRequest(path, headers, json);
        if (!response.isSuccess()) {
            this.processFailedResponse(response);
        }
        JSONObject obj = (JSONObject)response.getResponseBodyAsJSON();
        return obj.getString("Id");
    }

    public JSONObject getReportStatus(String reportId) throws IOException, JSONException {
        HashMap<String, String> headers;
        String path = "/api/v4/Reports?filter=Id%20eq%20" + reportId;
        HttpResponse response = this.executeGetRequest(path, headers = new HashMap<String, String>());
        if (!response.isSuccess()) {
            this.processFailedResponse(response);
        }
        JSONObject data = (JSONObject)response.getResponseBodyAsJSON();
        return (JSONObject)data.getJSONArray("Items").get(0);
    }

    public void downloadReport(String reportId, File destination) throws IOException, JSONException {
        HashMap<String, String> headers;
        String path = String.format("/api/v4/Reports/%s/Download", reportId);
        HttpResponse response = this.executeGetRequest(path, headers = new HashMap<String, String>());
        if (!response.isSuccess()) {
            this.processFailedResponse(response);
        }
        response.getResponseBodyAsFile(destination);
    }

    private HttpResponse executeGetRequest(String path, Map<String, String> headers) throws IOException {
        String requestUrl = this.m_authProvider.getServer() + path;
        headers.putAll(this.m_authProvider.getAuthorizationHeader());
        return new HttpClient().get(requestUrl, headers, null);
    }

    private HttpResponse executePostRequest(String path, Map<String, String> headers, JSONObject json) throws IOException {
        String requestUrl = this.m_authProvider.getServer() + path;
        headers.putAll(this.m_authProvider.getAuthorizationHeader());
        return new HttpClient().post(requestUrl, headers, json.toString().toCharArray());
    }

    private void processFailedResponse(HttpResponse response) throws IOException {
        try {
            JSONObject obj = (JSONObject)response.getResponseBodyAsJSON();
            if (obj != null && obj.has("Message")) {
                throw new IOException(obj.getString("Message"));
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        throw new IOException("error.getting.issues");
    }
}

