/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.cli.cloud.handlers;

import com.ibm.appscan.cli.cloud.handlers.SAHandler;
import com.ibm.appscan.cli.common.CommonCLICore;
import com.ibm.appscan.cli.common.ProgressAdapter;
import com.ibm.appscan.common.IProgress;
import com.ibm.appscan.common.error.AppScanException;
import com.ibm.appscan.common.logging.Message;
import com.ibm.appscan.common.utils.StringUtil;
import java.io.IOException;
import org.apache.commons.json.JSONException;
import org.apache.commons.json.JSONObject;

public class StatusHandler
extends SAHandler {
    public void status(String scanID) throws AppScanException {
        this.doStatus(StringUtil.getCleanUuid((String)scanID));
    }

    private void doStatus(String jobID) {
        this.setProgressAdapter((IProgress)new ProgressAdapter());
        try {
            if (this.isTokenExpired()) {
                return;
            }
            JSONObject content = this.getScanDetails(jobID);
            if (content != null) {
                if (content.keySet().contains("Message")) {
                    Message errorMessage = new Message(4, content.getString("Message"));
                    this.getProgressAdapter().setStatus(errorMessage);
                } else {
                    JSONObject latestExecution = (JSONObject)content.get("LatestExecution");
                    if (latestExecution != null && !latestExecution.isEmpty()) {
                        CommonCLICore.getIOConsole().print(latestExecution.getString("Status"));
                    }
                }
            }
        }
        catch (JSONException e) {
            this.getProgressAdapter().setStatus(new Message((Throwable)e));
        }
        catch (IOException e) {
            this.getProgressAdapter().setStatus(new Message((Throwable)e));
        }
    }
}

