/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.ica.markup.data;

import com.ibm.appscan.common.CommonCore;
import com.ibm.appscan.common.Language;
import com.ibm.appscan.ica.markup.MarkupException;
import com.ibm.appscan.ica.markup.translator.MarkupTranslator;
import com.ibm.appscan.vdb.data.Vdb;
import com.ibm.appscan.vdb.exception.BadMarkupException;
import com.ibm.appscan.vdb.exception.VDBGeneralException;
import com.ibm.appscan.vdb.method.Method;
import com.ibm.appscan.vdb.provider.VdbProvider;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;

public class RawMarkupData {
    private ArrayList<Method> m_raw_set;
    private ArrayList<Method> m_raw_train_set;
    private ArrayList<Method> m_raw_test_set;
    private double m_split = 0.9;
    private ArrayList<Method> m_train_methods;
    private ArrayList<Method> m_test_methods;
    private MarkupTranslator m_translator;
    private File m_test_methods_vdb;
    private Language.LANGUAGE m_lang;

    public RawMarkupData(MarkupTranslator checker, String name, Language.LANGUAGE lang) {
        this.m_translator = checker;
        this.m_test_methods_vdb = new File(CommonCore.getDirectoryLocator().getMl() + File.separator + "spark" + File.separator + "test", name + "_" + lang.toVdbString() + ".vdb");
        this.m_lang = lang;
    }

    public double getSplit() {
        return this.m_split;
    }

    private ArrayList<Method> getRawMethods() throws MarkupException {
        if (this.m_raw_set == null) {
            this.m_raw_set = new ArrayList();
            if (this.m_lang == Language.LANGUAGE.UNKNOWN) {
                this.processFile(new File(CommonCore.getDirectoryLocator().getVdb() + File.separator + "factory"));
            } else {
                this.processFile(CommonCore.getDirectoryLocator().getVdbLanguageDirectory(this.m_lang));
            }
            Collections.shuffle(this.m_raw_set);
        }
        return this.m_raw_set;
    }

    private void processFile(File dir) throws MarkupException {
        block3: {
            Vdb v;
            block2: {
                if (!dir.isDirectory()) break block2;
                for (File f : dir.listFiles()) {
                    this.processFile(f);
                }
                break block3;
            }
            if (!dir.getPath().endsWith("vdb") || (v = VdbProvider.getVdb((File)dir)) == null) break block3;
            for (Method m : v.getMethods()) {
                if (!m.isMarkedUp()) continue;
                this.m_raw_set.add(m);
            }
        }
    }

    public ArrayList<Method> getRawTestMethods() throws MarkupException {
        if (this.m_raw_test_set == null) {
            this.m_raw_test_set = new ArrayList<Method>(this.getRawMethods().subList((int)((double)this.getRawMethods().size() * this.getSplit()), this.getRawMethods().size()));
        }
        return this.m_raw_test_set;
    }

    public ArrayList<Method> getRawTrainMethods() throws MarkupException {
        if (this.m_raw_train_set == null) {
            this.m_raw_train_set = new ArrayList<Method>(this.getRawMethods().subList(0, (int)((double)this.getRawMethods().size() * this.getSplit())));
        }
        return this.m_raw_train_set;
    }

    public ArrayList<Method> getTrainMethods() throws MarkupException {
        if (this.m_train_methods == null) {
            this.m_train_methods = new ArrayList(this.getRawTrainMethods().size());
            HashMap methods_per_class = new HashMap();
            for (Method method : this.getRawTrainMethods()) {
                if (!this.m_translator.hasMarkup(method) && this.m_translator.useOnlyMarkedUpMethods()) continue;
                if (!methods_per_class.containsKey(this.m_translator.getMarkupString(method))) {
                    methods_per_class.put(this.m_translator.getMarkupString(method), new ArrayList());
                }
                ((ArrayList)methods_per_class.get(this.m_translator.getMarkupString(method))).add(method);
            }
            int high_count = 0;
            for (String key : methods_per_class.keySet()) {
                if (((ArrayList)methods_per_class.get(key)).size() <= high_count) continue;
                high_count = ((ArrayList)methods_per_class.get(key)).size();
            }
            int n = 75000 / methods_per_class.keySet().size();
            for (String key : methods_per_class.keySet()) {
                int high_index = ((ArrayList)methods_per_class.get(key)).size() < n ? ((ArrayList)methods_per_class.get(key)).size() : n;
                this.m_train_methods.addAll(((ArrayList)methods_per_class.get(key)).subList(0, high_index));
            }
            Collections.shuffle(this.m_train_methods);
        }
        return this.m_train_methods;
    }

    public ArrayList<Method> getTestMethods() throws MarkupException {
        if (this.m_test_methods == null) {
            Vdb v;
            this.m_test_methods = new ArrayList();
            if (!this.m_test_methods_vdb.exists()) {
                try {
                    this.m_test_methods_vdb.getParentFile().mkdirs();
                    v = new Vdb(this.m_lang);
                    for (Method m : this.getRawTestMethods()) {
                        if (!this.m_translator.hasMarkup(m) && this.m_translator.useOnlyMarkedUpMethods()) continue;
                        v.addMethod(m);
                    }
                    VdbProvider.saveVdb((Vdb)v, (File)this.m_test_methods_vdb);
                }
                catch (BadMarkupException e) {
                    throw new MarkupException(e);
                }
                catch (VDBGeneralException e) {
                    throw new MarkupException(e);
                }
            }
            v = VdbProvider.getVdb((File)this.m_test_methods_vdb);
            this.m_test_methods.addAll(v.getMethods());
        }
        return this.m_test_methods;
    }
}

