/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.ica.markup.trainer;

import com.ibm.appscan.common.CommonCore;
import com.ibm.appscan.common.Language;
import com.ibm.appscan.common.utils.IOUtil;
import com.ibm.appscan.ica.markup.MarkupException;
import com.ibm.appscan.ica.markup.data.MarkupActiveFeatures;
import com.ibm.appscan.ifa.Trainer;
import com.ibm.appscan.ifa.common.IfaConverter;
import com.ibm.appscan.ifa.common.IfaException;
import com.ibm.appscan.ifa.common.IfaSparkContext;
import com.ibm.appscan.ifa.model.SparkModel;
import com.ibm.appscan.ifa.model.SparkRandomForestClassifier;
import com.ibm.appscan.vdb.data.Vdb;
import com.ibm.appscan.vdb.exception.BadMarkupException;
import com.ibm.appscan.vdb.exception.BadRuleException;
import com.ibm.appscan.vdb.exception.VDBException;
import com.ibm.appscan.vdb.exception.VDBGeneralException;
import com.ibm.appscan.vdb.method.Method;
import com.ibm.appscan.vdb.misc.VDBEnums;
import com.ibm.appscan.vdb.provider.VdbProvider;
import com.ibm.appscan.vdb.provider.data.file.load.RuleReader;
import com.ibm.appscan.vdb.provider.data.file.save.RuleFileWriter;
import com.ibm.appscan.vdb.rule.BaseLogicGate;
import com.ibm.appscan.vdb.rule.Rule;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Scanner;
import org.apache.spark.SparkContext;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors;
import org.apache.spark.mllib.regression.LabeledPoint;
import org.apache.spark.mllib.util.MLUtils;

public abstract class MarkupTrainer
implements Trainer {
    private StringBuilder m_markup_train_data;
    private ArrayList<MarkupActiveFeatures.MARKUP_FEATURES> m_feature_list;
    private SparkModel m_model;
    private HashMap<String, String> m_train_signatures;
    private File m_train_sigs_file;
    private File m_train_file;
    private JavaRDD<LabeledPoint> m_data;
    private ArrayList<Rule> m_rules;
    private ArrayList<Rule> m_anti_rules;
    private HashMap<Integer, String> m_id_entries;
    private HashMap<String, Integer> m_map_entries;
    private HashMap<String, String> m_raw_entries = new HashMap();
    private HashMap<Integer, ArrayList<String>> m_class_entries = new HashMap();
    private File m_id_map;
    private HashMap<String, Integer> m_string_map;
    private File m_string_map_file;
    private HashMap<String, Integer> m_string_counts = new HashMap();
    private Language.LANGUAGE m_language = Language.LANGUAGE.JAVA;

    public MarkupTrainer() {
        this.m_train_file = new File(new File(CommonCore.getDirectoryLocator().getMl() + File.separator + "spark" + File.separator + "trainers", this.getClass().getName() + ".data").getAbsolutePath());
        this.m_train_sigs_file = new File(CommonCore.getDirectoryLocator().getMl() + File.separator + "spark" + File.separator + "trainers", this.getClass().getName() + "_" + this.m_language.toVdbString() + ".sigs");
        this.m_train_file = new File(CommonCore.getDirectoryLocator().getMl() + File.separator + "spark" + File.separator + "trainers", this.getClass().getName() + "_" + this.m_language.toVdbString() + ".train");
        this.m_id_map = new File(CommonCore.getDirectoryLocator().getMl() + File.separator + "spark" + File.separator + "trainers", this.getClass().getName() + "_" + this.m_language.toVdbString() + "_id_map.map");
        this.m_string_map_file = new File(CommonCore.getDirectoryLocator().getMl() + File.separator + "spark" + File.separator + "trainers", "strings.map");
    }

    public void resetFiles() throws IfaException {
        this.m_train_file.delete();
        this.m_id_map.delete();
        this.m_train_sigs_file.delete();
        this.getModel().deleteModelFile();
    }

    protected void setIdMapFile(File f) {
        this.m_id_map = f;
    }

    protected File getIdMapFile() {
        return this.m_id_map;
    }

    protected void setTrainFile(File f) {
        this.m_train_file = f;
    }

    protected File getTrainFile() {
        return this.m_train_file;
    }

    protected void setTrainSignaturesFile(File f) {
        this.m_train_sigs_file = f;
    }

    protected File getTrainSignaturesFile() {
        return this.m_train_sigs_file;
    }

    public JavaRDD<LabeledPoint> getData() throws MarkupException {
        if (this.m_data == null) {
            try {
                if (!this.m_train_file.exists()) {
                    this.m_train_file.getParentFile().mkdirs();
                    PrintWriter w = new PrintWriter(this.m_train_file);
                    w.write(this.getTrainData());
                    w.close();
                }
            }
            catch (FileNotFoundException e) {
                throw new MarkupException(e);
            }
            catch (VDBException e) {
                throw new MarkupException(e);
            }
            this.m_data = MLUtils.loadLibSVMFile((SparkContext)IfaSparkContext.getCtx(), (String)this.m_train_file.getAbsolutePath(), (int)this.getFeatureCount(), (int)2).toJavaRDD();
            this.m_data.cache();
        }
        return this.m_data;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public HashMap<String, String> getTrainSignatures() throws MarkupException {
        if (this.m_train_signatures != null) return this.m_train_signatures;
        this.m_train_signatures = new HashMap();
        if (!this.m_train_sigs_file.exists()) return this.m_train_signatures;
        BufferedReader br = null;
        try {
            br = new BufferedReader(new FileReader(this.m_train_sigs_file));
            String line = br.readLine();
            while (line != null) {
                this.m_train_signatures.put(line, line);
                line = br.readLine();
            }
        }
        catch (FileNotFoundException e) {
            try {
                throw new MarkupException(e);
                catch (IOException e2) {
                    throw new MarkupException(e2);
                }
            }
            catch (Throwable throwable) {
                IOUtil.close(br);
                throw throwable;
            }
        }
        IOUtil.close((Closeable)br);
        return this.m_train_signatures;
    }

    private void saveTrainSIgs() throws MarkupException {
        this.m_train_sigs_file.getParentFile().mkdirs();
        if (this.m_train_file.exists()) {
            this.m_train_file.delete();
        }
        PrintWriter out = null;
        try {
            out = new PrintWriter(this.m_train_sigs_file);
            for (String m : this.getTrainSignatures().keySet()) {
                out.write(m);
                out.write(System.getProperty("line.separator"));
            }
            out.flush();
        }
        catch (FileNotFoundException e) {
            try {
                throw new MarkupException(e);
            }
            catch (Throwable throwable) {
                IOUtil.close(out);
                throw throwable;
            }
        }
        IOUtil.close((Closeable)out);
    }

    public String getClassFromIndex(int index) throws MarkupException {
        return this.getIdMap().get(index);
    }

    public boolean useNoMarkupMethods() {
        return true;
    }

    protected boolean addStrings() {
        return true;
    }

    public String getTrainData() throws VDBException, MarkupException {
        if (this.m_markup_train_data == null) {
            this.m_markup_train_data = new StringBuilder();
            this.getTrainSignatures().clear();
            this.processFile(new File(CommonCore.getDirectoryLocator().getVdb() + File.separator + "factory"));
            ArrayList methods = new ArrayList(1000);
            ArrayList temp = new ArrayList();
            for (int id : this.m_class_entries.keySet()) {
                if (this.m_class_entries.get(id).size() > this.m_raw_entries.keySet().size() / this.m_class_entries.keySet().size()) {
                    temp.addAll(this.m_class_entries.get(id));
                    Collections.shuffle(temp);
                    methods.addAll(temp.subList(0, this.m_raw_entries.keySet().size() / this.m_class_entries.keySet().size()));
                    continue;
                }
                methods.addAll(this.m_class_entries.get(id));
            }
            Collections.shuffle(methods);
            for (String m : methods.subList(0, (int)((double)methods.size() * 0.9))) {
                this.m_markup_train_data.append(this.m_raw_entries.get(m));
                this.getTrainSignatures().put(m, m);
            }
            methods.clear();
            this.saveTrainSIgs();
            this.saveMaps();
            this.m_raw_entries.clear();
            this.m_class_entries.clear();
        }
        return this.m_markup_train_data.toString();
    }

    private void processFile(File dir) throws MarkupException {
        block7: {
            block6: {
                if (!dir.isDirectory()) break block6;
                for (File f : dir.listFiles()) {
                    this.processFile(f);
                }
                break block7;
            }
            Vdb v = VdbProvider.getVdb((File)dir);
            ArrayList<Method> methods = new ArrayList<Method>();
            ArrayList<Method> no_markup_methods = new ArrayList<Method>();
            if (v != null) {
                for (Method m : v.getMethods()) {
                    if (this.hasMarkup(m)) {
                        methods.add(m);
                        continue;
                    }
                    if (!this.useNoMarkupMethods()) continue;
                    no_markup_methods.add(m);
                }
            }
            for (Method m : methods) {
                this.addClassToMap(m);
            }
            if (!this.useNoMarkupMethods() || methods.size() <= 0 || no_markup_methods.size() <= methods.size()) break block7;
            Collections.shuffle(no_markup_methods);
            for (Method m : no_markup_methods.subList(0, methods.size())) {
                this.addClassToMap(m);
            }
        }
    }

    public String getTpString() {
        return "1";
    }

    public String getTnString() {
        return "0";
    }

    private void addClassEntry(Method m) throws MarkupException {
        String markup = this.getMarkupString(m);
        int class_index = this.getClassesStringMap().get(markup);
        if (!this.m_class_entries.containsKey(class_index)) {
            this.m_class_entries.put(class_index, new ArrayList());
        }
        this.m_class_entries.get(class_index).add(m.getSignature());
    }

    public abstract boolean hasMarkup(Method var1);

    public SparkModel getModel() throws IfaException {
        if (this.m_model == null) {
            this.m_model = this.initModel();
        }
        return this.m_model;
    }

    protected SparkModel initModel() throws IfaException {
        return new SparkRandomForestClassifier(this.getClass().getName(), this.getData(), this.getNumClasses());
    }

    public String testMethod(Method m) throws IfaException {
        if (this.antiRuleApplies(m)) {
            return this.getAntiMatch();
        }
        if (this.ruleApplies(m) && !this.antiRuleApplies(m)) {
            return this.getMarkupFromRule(m);
        }
        return this.predict_(m);
    }

    protected abstract String getAntiMatch();

    public HashMap<Double, Double> getProbabilities(Method m) throws MarkupException, VDBException {
        try {
            return this.getModel().getProbabilities(this.getVector(this.getTestMethod(m)));
        }
        catch (IfaException e) {
            throw new MarkupException(e);
        }
    }

    public LinkedHashMap<Double, Double> getSortedProbabilities(Method m) throws MarkupException, VDBException {
        try {
            return this.getModel().getSortedProbabilities(this.getVector(this.getTestMethod(m)));
        }
        catch (IfaException e) {
            throw new MarkupException(e);
        }
    }

    public void predict(Method m) throws IfaException {
        try {
            this.applyMarkup(m, this.testMethod(m));
        }
        catch (BadMarkupException e) {
            throw new MarkupException(e);
        }
    }

    protected abstract void applyMarkup(Method var1, String var2) throws MarkupException, BadMarkupException;

    public ArrayList<Rule> getMatchingRules(Method m) throws MarkupException {
        ArrayList<Rule> ret = new ArrayList<Rule>();
        for (Rule r : this.getRules()) {
            if (!r.isMatch(m)) continue;
            ret.add(r);
        }
        return ret;
    }

    public ArrayList<Rule> getMatchingAntiRules(Method m) throws MarkupException {
        ArrayList<Rule> ret = new ArrayList<Rule>();
        for (Rule r : this.getAntiRules()) {
            if (!r.isMatch(m)) continue;
            ret.add(r);
        }
        return ret;
    }

    public abstract String predict_(Method var1) throws MarkupException, IfaException;

    public double getProbability(Method m, double value) throws VDBException, IfaException {
        return this.getModel().getProbability(this.getModel().getVector(this.getFeatureCount(), this.getNormalizedMethod(m)), value);
    }

    public double getProbability(Vector v, double value) throws IfaException {
        return this.getModel().getProbability(v, value);
    }

    public String getTestMethod(Method m) throws MarkupException {
        return this.getNormalizedMethod(m);
    }

    public Vector getVector(String data) throws IfaException {
        String[] entries = data.split(" ");
        ArrayList<Double> temp = new ArrayList<Double>();
        for (int i = 1; i < entries.length; ++i) {
            temp.add(Double.parseDouble(entries[i].split(":")[1]));
        }
        double[] ret = new double[temp.size()];
        for (int i = 0; i < temp.size(); ++i) {
            ret[i] = (Double)temp.get(i);
        }
        return Vectors.dense((double[])ret);
    }

    public void addToTrainSet(Method m) throws IfaException {
        this.addClassToMap(m);
        this.m_markup_train_data.append(this.getNormalizedMethod(m));
    }

    public void addToTrainSet(List<Method> methods) throws IfaException {
        for (Method m : methods) {
            this.addToTrainSet(m);
        }
    }

    public String getNormalizedMethod(Method m) throws MarkupException {
        try {
            StringBuffer str = new StringBuffer();
            String signature = m.getMethodName();
            signature = signature.replaceAll("_", "");
            signature = signature.replaceAll("-", "");
            signature = signature.replaceAll("\\+", "");
            if (signature.contains(".")) {
                signature = signature.substring(signature.lastIndexOf(".") + 1);
            }
            for (int i = 0; i < this.getFeatures().size(); ++i) {
                if (i > 0) {
                    str.append(i);
                    str.append(":");
                }
                if (this.getFeatures().get(i) == MarkupActiveFeatures.MARKUP_FEATURES.SIMPLE_ARG_1) {
                    if (m.getArgs().size() > 0) {
                        str.append(this.getSimpleStringId(m.getSimpleArgString(0)));
                    } else {
                        str.append("0");
                    }
                } else if (this.getFeatures().get(i) == MarkupActiveFeatures.MARKUP_FEATURES.SIMPLE_ARG_2) {
                    if (m.getArgs().size() > 1) {
                        str.append(this.getSimpleStringId(m.getSimpleArgString(1)));
                    } else {
                        str.append("0");
                    }
                } else if (this.getFeatures().get(i) == MarkupActiveFeatures.MARKUP_FEATURES.SIMPLE_ARG_3) {
                    if (m.getArgs().size() > 2) {
                        str.append(this.getSimpleStringId(m.getSimpleArgString(2)));
                    } else {
                        str.append("0");
                    }
                } else if (this.getFeatures().get(i) == MarkupActiveFeatures.MARKUP_FEATURES.METHOD_CLASS) {
                    if (m.getClassName() != null && m.getClassName().length() > 0) {
                        str.append(this.getStringId(m.getClassName(), m.getClassName()));
                    } else {
                        str.append("0");
                    }
                } else if (this.getFeatures().get(i) == MarkupActiveFeatures.MARKUP_FEATURES.METHOD_PACKAGE) {
                    if (m.getPackageName() != null) {
                        str.append(this.getStringId(m.getPackageName(), m.getPackageName()));
                    } else {
                        str.append("0");
                    }
                } else if (this.getFeatures().get(i) == MarkupActiveFeatures.MARKUP_FEATURES.METHOD_PART1) {
                    if (m.getMethodParts().size() > 0) {
                        str.append(this.getStringId((String)m.getMethodParts().get(0), m.getSimpleArg((String)m.getMethodParts().get(0))));
                    } else {
                        str.append(this.getStringId(m.getMethodName(), m.getMethodName()));
                    }
                } else if (this.getFeatures().get(i) == MarkupActiveFeatures.MARKUP_FEATURES.METHOD_PART2) {
                    if (m.getMethodParts().size() > 1) {
                        str.append(this.getStringId((String)m.getMethodParts().get(1), m.getSimpleArg((String)m.getMethodParts().get(1))));
                    } else {
                        str.append("0");
                    }
                } else if (this.getFeatures().get(i) == MarkupActiveFeatures.MARKUP_FEATURES.METHOD_PART3) {
                    if (m.getMethodParts().size() > 2) {
                        str.append(this.getStringId((String)m.getMethodParts().get(2), m.getSimpleArg((String)m.getMethodParts().get(2))));
                    } else {
                        str.append("0");
                    }
                } else if (this.getFeatures().get(i) == MarkupActiveFeatures.MARKUP_FEATURES.METHOD_RETURN) {
                    str.append(this.getStringId(m.getReturn(), m.getSimpleReturn()));
                } else if (this.getFeatures().get(i) == MarkupActiveFeatures.MARKUP_FEATURES.ARG_COUNT) {
                    str.append(m.getArgs().size());
                } else if (this.getFeatures().get(i) == MarkupActiveFeatures.MARKUP_FEATURES.STATIC) {
                    if (m.isStatic() || m.getMethodName().startsWith("+")) {
                        str.append("1");
                    } else {
                        str.append("0");
                    }
                } else if (this.getFeatures().get(i) == MarkupActiveFeatures.MARKUP_FEATURES.ALLOWS_RETURN) {
                    if (m.isReturn()) {
                        str.append("1");
                    } else {
                        str.append("0");
                    }
                } else if (this.getFeatures().get(i) == MarkupActiveFeatures.MARKUP_FEATURES.TYPE) {
                    if (m.isWebTechMech()) {
                        str.append("1");
                    } else if (m.isDbTechMech()) {
                        str.append("2");
                    } else if (m.isFileTechMech()) {
                        str.append("3");
                    } else {
                        str.append("0");
                    }
                } else if (this.getFeatures().get(i) == MarkupActiveFeatures.MARKUP_FEATURES.TECH_MECH) {
                    if (m.isDbTechMech()) {
                        str.append("1");
                    } else if (m.isFileTechMech()) {
                        str.append("2");
                    } else if (m.isWebTechMech()) {
                        str.append("3");
                    } else {
                        str.append("0");
                    }
                } else if (this.getFeatures().get(i) == MarkupActiveFeatures.MARKUP_FEATURES.METHOD) {
                    str.append(this.getSimpleStringId(m.getSimpleMethodName()));
                } else if (this.getFeatures().get(i) == MarkupActiveFeatures.MARKUP_FEATURES.META) {
                    if (m.isGetter() || VdbProvider.isGetterType((Method)m)) {
                        str.append("1");
                    } else if (m.isSetter() || VdbProvider.isSetterType((Method)m)) {
                        str.append("2");
                    } else if (m.isConstructor()) {
                        str.append("3");
                    } else {
                        str.append("0");
                    }
                } else if (this.getFeatures().get(i) == MarkupActiveFeatures.MARKUP_FEATURES.GETTER) {
                    if (m.isGetter() || VdbProvider.isGetterType((Method)m)) {
                        str.append("1");
                    } else {
                        str.append("0");
                    }
                } else if (this.getFeatures().get(i) == MarkupActiveFeatures.MARKUP_FEATURES.SETTER) {
                    if (m.isSetter() || VdbProvider.isSetterType((Method)m)) {
                        str.append("1");
                    } else {
                        str.append("0");
                    }
                } else if (this.getFeatures().get(i) == MarkupActiveFeatures.MARKUP_FEATURES.CONSTRUCTOR) {
                    if (m.isGetter() || VdbProvider.isGetterType((Method)m)) {
                        str.append("1");
                    } else {
                        str.append("0");
                    }
                } else if (this.getFeature() == this.getFeatures().get(i)) {
                    this.processMarkup(str, m);
                }
                str.append(" ");
            }
            str.deleteCharAt(str.length() - 1);
            str.append(System.getProperty("line.separator"));
            String string = str.toString();
            return string;
        }
        catch (VDBException e) {
            throw new MarkupException(e);
        }
    }

    public abstract String getMarkupString(Method var1) throws MarkupException;

    protected abstract MarkupActiveFeatures.MARKUP_FEATURES getFeature();

    public ArrayList<MarkupActiveFeatures.MARKUP_FEATURES> getFeatures() {
        if (this.m_feature_list == null) {
            this.m_feature_list = new ArrayList();
            this.m_feature_list.add(this.getFeature());
            this.m_feature_list.add(MarkupActiveFeatures.MARKUP_FEATURES.METHOD_PART1);
            this.m_feature_list.add(MarkupActiveFeatures.MARKUP_FEATURES.METHOD_PART2);
            this.m_feature_list.add(MarkupActiveFeatures.MARKUP_FEATURES.METHOD_PART3);
            this.m_feature_list.add(MarkupActiveFeatures.MARKUP_FEATURES.METHOD_RETURN);
            this.m_feature_list.add(MarkupActiveFeatures.MARKUP_FEATURES.ARG_COUNT);
            this.m_feature_list.add(MarkupActiveFeatures.MARKUP_FEATURES.ALLOWS_RETURN);
            this.m_feature_list.add(MarkupActiveFeatures.MARKUP_FEATURES.SIMPLE_ARG_1);
            this.m_feature_list.add(MarkupActiveFeatures.MARKUP_FEATURES.SIMPLE_ARG_2);
            this.m_feature_list.add(MarkupActiveFeatures.MARKUP_FEATURES.SIMPLE_ARG_3);
            this.m_feature_list.add(MarkupActiveFeatures.MARKUP_FEATURES.META);
            this.m_feature_list.add(MarkupActiveFeatures.MARKUP_FEATURES.STATIC);
            this.m_feature_list.add(MarkupActiveFeatures.MARKUP_FEATURES.TYPE);
            this.m_feature_list.add(MarkupActiveFeatures.MARKUP_FEATURES.TECH_MECH);
        }
        return this.m_feature_list;
    }

    public ArrayList<Rule> getRules() throws MarkupException {
        if (this.m_rules == null) {
            this.m_rules = new ArrayList();
            File rule_file = new File(CommonCore.getDirectoryLocator().getMl() + File.separator + "spark" + File.separator + "rules", this.getClass().getName() + ".rules");
            try {
                this.initRules();
                this.initBulkRules();
                rule_file.getParentFile().mkdirs();
                RuleFileWriter writer = new RuleFileWriter(rule_file);
                writer.writeRules(this.m_rules);
                RuleReader reader = new RuleReader(rule_file);
                reader.parse();
                for (Rule r : reader.getRules()) {
                    this.m_rules.add(r);
                }
            }
            catch (VDBGeneralException e) {
                throw new MarkupException(e);
            }
            catch (BadRuleException e) {
                throw new MarkupException(e);
            }
        }
        return this.m_rules;
    }

    public ArrayList<Rule> getAntiRules() throws MarkupException {
        if (this.m_anti_rules == null) {
            this.m_anti_rules = new ArrayList();
            File rule_file = new File(CommonCore.getDirectoryLocator().getMl() + File.separator + "spark" + File.separator + "anti_rules", this.getClass().getName() + ".rules");
            try {
                try {
                    this.initAntiRules();
                    this.initBulkAntiRules();
                    rule_file.getParentFile().mkdirs();
                    RuleFileWriter writer = new RuleFileWriter(rule_file);
                    writer.writeRules(this.m_anti_rules);
                }
                catch (BadRuleException e) {
                    throw new MarkupException(e);
                }
                RuleReader reader = new RuleReader(rule_file);
                reader.parse();
                for (Rule r : reader.getRules()) {
                    this.m_anti_rules.add(r);
                }
            }
            catch (VDBGeneralException e) {
                throw new MarkupException(e);
            }
        }
        return this.m_anti_rules;
    }

    protected void initBulkRules() throws MarkupException, BadRuleException {
        for (VDBEnums.RULE_OPERATOR op : VDBEnums.RULE_OPERATOR.values()) {
            Rule r = this.initBulkRule();
            r.setRuleName("method name " + op.getSimpleName() + " - " + this.getMarkupType() + " - rule");
            this.processBulkMethodNameRule(r, new File(CommonCore.getDirectoryLocator().getMl() + "spark" + File.separator + "rules" + File.separator, "method_" + op.getSimpleName() + "_" + this.getMarkupType() + ".rule"), op, this.getRules());
            r = this.initBulkRule();
            r.setRuleName("class name " + op.getSimpleName() + " - " + this.getMarkupType() + " - anti rule");
            this.processBulkClassNameRule(r, new File(CommonCore.getDirectoryLocator().getMl() + "spark" + File.separator + "rules" + File.separator, "class_" + op.getSimpleName() + "_" + this.getMarkupType() + ".rule"), op, this.getRules());
            r = this.initBulkRule();
            r.setRuleName("return name " + op.getSimpleName() + " - " + this.getMarkupType() + " - anti rule");
            this.processBulkReturnRule(r, new File(CommonCore.getDirectoryLocator().getMl() + "spark" + File.separator + "rules" + File.separator, "return_" + op.getSimpleName() + "_" + this.getMarkupType() + ".rule"), op, this.getRules());
            r = this.initBulkRule();
            r.setRuleName("package name " + op.getSimpleName() + " - " + this.getMarkupType() + " - anti rule");
            this.processBulkPackageNameRule(r, new File(CommonCore.getDirectoryLocator().getMl() + "spark" + File.separator + "rules" + File.separator, "package_" + op.getSimpleName() + "_" + this.getMarkupType() + ".rule"), op, this.getRules());
        }
    }

    protected void initBulkAntiRules() throws MarkupException, BadRuleException {
        for (VDBEnums.RULE_OPERATOR op : VDBEnums.RULE_OPERATOR.values()) {
            Rule r = this.initBulkRule();
            r.setRuleName("method name " + op.getSimpleName() + " - " + this.getMarkupType() + " - anti rule");
            this.processBulkMethodNameRule(r, new File(CommonCore.getDirectoryLocator().getMl() + "spark" + File.separator + "anti_rules" + File.separator, "method_" + op.getSimpleName() + "_" + this.getMarkupType() + ".rule"), op, this.getAntiRules());
            r = this.initBulkRule();
            r.setRuleName("class name " + op.getSimpleName() + " - " + this.getMarkupType() + " - anti rule");
            this.processBulkClassNameRule(r, new File(CommonCore.getDirectoryLocator().getMl() + "spark" + File.separator + "anti_rules" + File.separator, "class_" + op.getSimpleName() + "_" + this.getMarkupType() + ".rule"), op, this.getAntiRules());
            r = this.initBulkRule();
            r.setRuleName("return name " + op.getSimpleName() + " - " + this.getMarkupType() + " - anti rule");
            this.processBulkReturnRule(r, new File(CommonCore.getDirectoryLocator().getMl() + "spark" + File.separator + "anti_rules" + File.separator, "return_" + op.getSimpleName() + "_" + this.getMarkupType() + ".rule"), op, this.getAntiRules());
            r = this.initBulkRule();
            r.setRuleName("package name " + op.getSimpleName() + " - " + this.getMarkupType() + " - anti rule");
            this.processBulkPackageNameRule(r, new File(CommonCore.getDirectoryLocator().getMl() + "spark" + File.separator + "anti_rules" + File.separator, "package_" + op.getSimpleName() + "_" + this.getMarkupType() + ".rule"), op, this.getAntiRules());
        }
    }

    protected Rule initBulkRule() throws BadRuleException {
        return new Rule();
    }

    protected abstract String getMarkupType();

    protected abstract void initRules() throws MarkupException, BadRuleException;

    protected abstract void initAntiRules() throws MarkupException, BadRuleException;

    protected void processMarkup(StringBuffer str, Method m) throws MarkupException {
        if (this.getClassesStringMap().get(this.getMarkupString(m)) != null) {
            str.append(this.getClassesStringMap().get(this.getMarkupString(m)));
        } else {
            str.append("0");
        }
    }

    public int getNumClasses() throws MarkupException {
        return this.getIdMap().keySet().size();
    }

    public boolean ruleApplies(Method m) throws MarkupException {
        if (this.antiRuleApplies(m)) {
            return false;
        }
        for (Rule r : this.getRules()) {
            if (!r.isMatch(m)) continue;
            return true;
        }
        return false;
    }

    public boolean antiRuleApplies(Method m) throws MarkupException {
        for (Rule r : this.getAntiRules()) {
            if (!r.isMatch(m)) continue;
            return true;
        }
        return false;
    }

    public abstract String getMarkupFromRule(Method var1) throws MarkupException;

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void processBulkMethodNameRule(Rule r, File f, VDBEnums.RULE_OPERATOR op, ArrayList<Rule> map) throws MarkupException {
        if (!f.exists()) {
            return;
        }
        BufferedReader br = null;
        try {
            br = new BufferedReader(new FileReader(f));
            String line = br.readLine();
            BaseLogicGate g = r.createLogicGate(VDBEnums.RULE_GATE_TYPE.OR);
            boolean add = false;
            while (line != null) {
                if (line != null && line.length() > 0 && !line.startsWith("#")) {
                    add = true;
                    Rule r1 = g.createRule();
                    r1.getMethodRule().getSignatureRule().setRuleOperator(op);
                    r1.getMethodRule().getSignatureRule().setRuleValue(line);
                }
                line = br.readLine();
            }
            if (add) {
                map.add(r);
            }
        }
        catch (FileNotFoundException e) {
            try {
                throw new MarkupException(e);
                catch (IOException e2) {
                    throw new MarkupException(e2);
                }
                catch (BadRuleException e3) {
                    throw new MarkupException(e3);
                }
            }
            catch (Throwable throwable) {
                IOUtil.close(br);
                throw throwable;
            }
        }
        IOUtil.close((Closeable)br);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void processBulkPackageNameRule(Rule r, File f, VDBEnums.RULE_OPERATOR op, ArrayList<Rule> map) throws MarkupException {
        if (!f.exists()) {
            return;
        }
        BufferedReader br = null;
        try {
            br = new BufferedReader(new FileReader(f));
            String line = br.readLine();
            BaseLogicGate g = r.createLogicGate(VDBEnums.RULE_GATE_TYPE.OR);
            boolean add = false;
            while (line != null) {
                if (line != null && line.length() > 0 && !line.startsWith("#")) {
                    add = true;
                    Rule r1 = g.createRule();
                    r1.getMethodRule().getPackageRule().setRuleOperator(op);
                    r1.getMethodRule().getPackageRule().setRuleValue(line);
                }
                line = br.readLine();
            }
            if (add) {
                map.add(r);
            }
        }
        catch (FileNotFoundException e) {
            try {
                throw new MarkupException(e);
                catch (IOException e2) {
                    throw new MarkupException(e2);
                }
                catch (BadRuleException e3) {
                    throw new MarkupException(e3);
                }
            }
            catch (Throwable throwable) {
                IOUtil.close(br);
                throw throwable;
            }
        }
        IOUtil.close((Closeable)br);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void processBulkClassNameRule(Rule r, File f, VDBEnums.RULE_OPERATOR op, ArrayList<Rule> map) throws MarkupException {
        if (!f.exists()) {
            return;
        }
        BufferedReader br = null;
        try {
            br = new BufferedReader(new FileReader(f));
            String line = br.readLine();
            BaseLogicGate g = r.createLogicGate(VDBEnums.RULE_GATE_TYPE.OR);
            boolean add = false;
            while (line != null) {
                if (line != null && line.length() > 0 && !line.startsWith("#")) {
                    add = true;
                    Rule r1 = g.createRule();
                    r1.getMethodRule().getClassRule().setRuleOperator(op);
                    r1.getMethodRule().getClassRule().setRuleValue(line);
                }
                line = br.readLine();
            }
            if (add) {
                map.add(r);
            }
        }
        catch (FileNotFoundException e) {
            try {
                throw new MarkupException(e);
                catch (IOException e2) {
                    throw new MarkupException(e2);
                }
                catch (BadRuleException e3) {
                    throw new MarkupException(e3);
                }
            }
            catch (Throwable throwable) {
                IOUtil.close(br);
                throw throwable;
            }
        }
        IOUtil.close((Closeable)br);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void processBulkReturnRule(Rule r, File f, VDBEnums.RULE_OPERATOR op, ArrayList<Rule> map) throws MarkupException {
        if (!f.exists()) {
            return;
        }
        BufferedReader br = null;
        try {
            br = new BufferedReader(new FileReader(f));
            String line = br.readLine();
            BaseLogicGate g = r.createLogicGate(VDBEnums.RULE_GATE_TYPE.OR);
            boolean add = false;
            while (line != null) {
                if (line != null && line.length() > 0 && !line.startsWith("#")) {
                    add = true;
                    Rule r1 = g.createRule();
                    r1.getMethodRule().getReturnRule().setRuleOperator(op);
                    r1.getMethodRule().getReturnRule().setRuleValue(line);
                }
                line = br.readLine();
            }
            if (add) {
                map.add(r);
            }
        }
        catch (FileNotFoundException e) {
            try {
                throw new MarkupException(e);
                catch (IOException e2) {
                    throw new MarkupException(e2);
                }
                catch (BadRuleException e3) {
                    throw new MarkupException(e3);
                }
            }
            catch (Throwable throwable) {
                IOUtil.close(br);
                throw throwable;
            }
        }
        IOUtil.close((Closeable)br);
    }

    public void addClassToMap(Method m) throws MarkupException {
        String class_name = this.getMarkupString(m);
        if (!this.getClassesStringMap().containsKey(class_name)) {
            int id = this.getIdMap().keySet().size();
            this.getIdMap().put(id, class_name);
            this.getClassesStringMap().put(class_name, id);
        }
        this.addClassEntry(m);
        this.m_raw_entries.put(m.getSignature(), this.getNormalizedMethod(m));
    }

    public HashMap<String, Integer> getClassesStringMap() throws MarkupException {
        if (this.m_map_entries == null) {
            this.m_map_entries = new HashMap();
            if (this.m_id_map.exists()) {
                Scanner scan = null;
                try {
                    scan = new Scanner(this.m_id_map);
                    while (scan.hasNextLine()) {
                        String line = scan.nextLine();
                        this.m_map_entries.put(line.split(":")[1], Integer.parseInt(line.split(":")[0]));
                    }
                }
                catch (FileNotFoundException e) {
                    try {
                        throw new MarkupException(e);
                    }
                    catch (Throwable throwable) {
                        IOUtil.close(scan);
                        throw throwable;
                    }
                }
                IOUtil.close((Closeable)scan);
            }
        }
        return this.m_map_entries;
    }

    public HashMap<Integer, String> getIdMap() throws MarkupException {
        if (this.m_id_entries == null) {
            this.m_id_entries = new HashMap();
            if (this.m_id_map.exists()) {
                Scanner scan = null;
                try {
                    scan = new Scanner(this.m_id_map);
                    while (scan.hasNextLine()) {
                        String line = scan.nextLine();
                        this.m_id_entries.put(Integer.parseInt(line.split(":")[0]), line.split(":")[1]);
                    }
                }
                catch (FileNotFoundException e) {
                    try {
                        throw new MarkupException(e);
                    }
                    catch (Throwable throwable) {
                        IOUtil.close(scan);
                        throw throwable;
                    }
                }
                IOUtil.close((Closeable)scan);
            }
        }
        return this.m_id_entries;
    }

    public int getIdForMapEntry(String entry) throws MarkupException {
        for (int id : this.getIdMap().keySet()) {
            if (!this.getIdMap().get(id).equals(entry)) continue;
            return id;
        }
        return 1;
    }

    private void saveMaps() throws MarkupException {
        PrintWriter id_map = null;
        try {
            id_map = new PrintWriter(this.m_id_map);
            for (int id : this.getIdMap().keySet()) {
                id_map.write(id + ":" + this.getIdMap().get(id));
                id_map.write(System.getProperty("line.separator"));
            }
            id_map.flush();
        }
        catch (FileNotFoundException e) {
            try {
                throw new MarkupException(e);
            }
            catch (Throwable throwable) {
                IOUtil.close(id_map);
                throw throwable;
            }
        }
        IOUtil.close((Closeable)id_map);
    }

    public int getFeatureCount() throws MarkupException {
        return this.getFeatures().size();
    }

    public String getStringId(String s, String simple) throws MarkupException {
        s = s.toLowerCase();
        return IfaConverter.byteArrayToInt((byte[])s.getBytes());
    }

    public String getSimpleStringId(String s) throws MarkupException {
        s = s.toLowerCase();
        return IfaConverter.byteArrayToInt((byte[])s.getBytes());
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected HashMap<String, Integer> getStringMap() throws MarkupException {
        if (this.m_string_map != null) return this.m_string_map;
        this.m_string_map = new HashMap();
        if (this.m_string_map_file.exists()) {
            BufferedReader br = null;
            try {
                br = new BufferedReader(new FileReader(this.m_string_map_file));
                String line = br.readLine();
                while (line != null) {
                    this.m_string_map.put(line.split("--;;--")[0], Integer.parseInt(line.split("--;;--")[1]));
                    line = br.readLine();
                }
            }
            catch (FileNotFoundException e) {
                try {
                    throw new MarkupException(e);
                    catch (IOException e2) {
                        throw new MarkupException(e2);
                    }
                }
                catch (Throwable throwable) {
                    IOUtil.close(br);
                    throw throwable;
                }
            }
            IOUtil.close((Closeable)br);
            return this.m_string_map;
        }
        try {
            this.loadMap(new File(CommonCore.getDirectoryLocator().getVdb()));
            this.saveStringMap();
            return this.m_string_map;
        }
        catch (VDBException e) {
            throw new MarkupException(e);
        }
    }

    private void loadMap(File dir) throws MarkupException, VDBException {
        block8: {
            block7: {
                if (!dir.isDirectory()) break block7;
                for (File f : dir.listFiles()) {
                    this.loadMap(f);
                }
                break block8;
            }
            Vdb v = VdbProvider.getVdb((File)dir);
            if (v == null) break block8;
            for (Method m : v.getMethods()) {
                if (m.getMethodParts().size() > 0) {
                    for (String s : m.getMethodParts()) {
                        this.addString(s);
                    }
                }
                this.addString(m.getMethodName());
                if (m.getClassName() != null && m.getClassName().length() > 0) {
                    this.addString(m.getClassName());
                }
                if (m.getPackageName() != null && m.getPackageName().length() > 0) {
                    this.addString(m.getPackageName());
                }
                for (String arg : m.getArgs()) {
                    this.addString(arg);
                    this.addString(m.getSimpleArg(arg));
                }
            }
        }
    }

    private void saveStringMap() throws MarkupException {
        this.m_string_map_file.getParentFile().mkdirs();
        if (this.m_string_map_file.exists()) {
            this.m_string_map_file.delete();
        }
        PrintWriter out = null;
        try {
            out = new PrintWriter(this.m_string_map_file);
            ArrayList<Integer> ids = new ArrayList<Integer>(this.getStringMap().values());
            Collections.sort(ids);
            HashMap<Integer, String> order = new HashMap<Integer, String>(ids.size(), 1.0f);
            for (String s : this.getStringMap().keySet()) {
                order.put(this.getStringMap().get(s), s);
            }
            Iterator<Object> iterator = ids.iterator();
            while (iterator.hasNext()) {
                int id = (Integer)iterator.next();
                out.write((String)order.get(id) + "--;;--" + id);
                out.write(System.getProperty("line.separator"));
            }
            out.flush();
        }
        catch (FileNotFoundException e) {
            try {
                throw new MarkupException(e);
            }
            catch (Throwable throwable) {
                IOUtil.close(out);
                throw throwable;
            }
        }
        IOUtil.close((Closeable)out);
    }

    private int addString(String s) throws MarkupException {
        s = s.toLowerCase();
        if (!this.getStringMap().containsKey(s)) {
            this.getStringMap().put(s, this.getStringMap().keySet().size() + 1);
        }
        if (!this.m_string_counts.containsKey(s)) {
            this.m_string_counts.put(s, 0);
        }
        int temp = this.m_string_counts.get(s);
        this.m_string_counts.put(s, ++temp);
        return this.getStringMap().get(s);
    }
}

