/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.ica.markup.trainer;

import com.ibm.appscan.ica.markup.MarkupException;
import com.ibm.appscan.ica.markup.data.MarkupActiveFeatures;
import com.ibm.appscan.ica.markup.trainer.MarkupTrainer;
import com.ibm.appscan.ica.markup.trainer.SinkArgTrainer;
import com.ibm.appscan.ica.markup.trainer.SinkSevTrainer;
import com.ibm.appscan.ica.markup.trainer.SinkVulnTrainer;
import com.ibm.appscan.ifa.common.IfaException;
import com.ibm.appscan.vdb.exception.BadMarkupException;
import com.ibm.appscan.vdb.exception.BadRuleException;
import com.ibm.appscan.vdb.method.Method;
import com.ibm.appscan.vdb.method.markup.ao.ActionObject;
import com.ibm.appscan.vdb.method.markup.ao.Sink;
import com.ibm.appscan.vdb.misc.VDBEnums;
import com.ibm.appscan.vdb.rule.BaseLogicGate;
import com.ibm.appscan.vdb.rule.Rule;
import java.util.Iterator;
import java.util.LinkedHashMap;

public class SinkTrainer
extends MarkupTrainer {
    private static String SINK = "Is Sink";
    private static String NOT_SINK = "Is Not Sink";
    private SinkVulnTrainer m_sink_vuln_trainer;
    private SinkArgTrainer m_arg_trainer;
    private SinkSevTrainer m_sev_trainer;

    @Override
    public String getTpString() {
        return SINK;
    }

    @Override
    public String getTnString() {
        return NOT_SINK;
    }

    @Override
    protected MarkupActiveFeatures.MARKUP_FEATURES getFeature() {
        return MarkupActiveFeatures.MARKUP_FEATURES.SINK;
    }

    @Override
    public boolean hasMarkup(Method m) {
        return m.getSinks().size() > 0;
    }

    @Override
    public String getMarkupFromRule(Method m) throws MarkupException {
        if (this.ruleApplies(m)) {
            return SINK;
        }
        return NOT_SINK;
    }

    @Override
    protected void applyMarkup(Method m, String markupString) throws MarkupException, BadMarkupException {
        try {
            if (this.testMethod(m).equals(SINK)) {
                Sink s = new Sink(this.getSinkVulnTrainer().testMethod(m), VDBEnums.SEVERITY.valueOf((String)this.getSinkSevTrainer().testMethod(m).toUpperCase()), this.getSinkArgTrainer().testMethod(m));
                m.addActionObject((ActionObject)s);
            }
        }
        catch (IfaException e) {
            e.printStackTrace();
        }
    }

    private SinkVulnTrainer getSinkVulnTrainer() {
        if (this.m_sink_vuln_trainer == null) {
            this.m_sink_vuln_trainer = new SinkVulnTrainer();
        }
        return this.m_sink_vuln_trainer;
    }

    private SinkArgTrainer getSinkArgTrainer() {
        if (this.m_arg_trainer == null) {
            this.m_arg_trainer = new SinkArgTrainer();
        }
        return this.m_arg_trainer;
    }

    private SinkSevTrainer getSinkSevTrainer() {
        if (this.m_sev_trainer == null) {
            this.m_sev_trainer = new SinkSevTrainer();
        }
        return this.m_sev_trainer;
    }

    @Override
    protected String getAntiMatch() {
        return NOT_SINK;
    }

    @Override
    public String getMarkupString(Method m) {
        return this.hasMarkup(m) ? SINK : NOT_SINK;
    }

    @Override
    protected void initRules() throws MarkupException, BadRuleException {
        Rule r = new Rule();
        r.setRuleName("setter - sink - rule");
        BaseLogicGate g = r.createLogicGate(VDBEnums.RULE_GATE_TYPE.OR);
        Rule r1 = g.createRule();
        r1.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r1.getMethodRule().getSignatureRule().setRuleValue("password");
        r1 = g.createRule();
        r1.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r1.getMethodRule().getSignatureRule().setRuleValue("passwd");
        r1 = g.createRule();
        r1.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r1.getMethodRule().getSignatureRule().setRuleValue("username");
        r1 = g.createRule();
        r1.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r1.getMethodRule().getSignatureRule().setRuleValue("url");
        r1 = g.createRule();
        r1.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r1.getMethodRule().getSignatureRule().setRuleValue("uri");
        r1 = g.createRule();
        r1.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r1.getMethodRule().getSignatureRule().setRuleValue("file");
        r1 = g.createRule();
        r1.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r1.getMethodRule().getSignatureRule().setRuleValue("query");
        r1 = g.createRule();
        r1.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r1.getMethodRule().getSignatureRule().setRuleValue("InnerXml");
        r1 = g.createRule();
        r1.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r1.getMethodRule().getSignatureRule().setRuleValue("userid");
        r1 = g.createRule();
        r1.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r1.getMethodRule().getSignatureRule().setRuleValue("directory");
        r1 = g.createRule();
        r1.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r1.getMethodRule().getSignatureRule().setRuleValue("email");
        r1 = g.createRule();
        r1.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r1.getMethodRule().getSignatureRule().setRuleValue("usersid");
        r1 = g.createRule();
        r1.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r1.getMethodRule().getSignatureRule().setRuleValue("path");
        r1 = g.createRule();
        r1.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r1.getMethodRule().getSignatureRule().setRuleValue("directory");
        r1 = g.createRule();
        r1.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r1.getMethodRule().getSignatureRule().setRuleValue("commandline");
        r1 = g.createRule();
        r1.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r1.getMethodRule().getSignatureRule().setRuleValue("contenttype");
        r1 = g.createRule();
        r1.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r1.getMethodRule().getSignatureRule().setRuleValue("contentencoding");
        r.getSpecialCaseRule().setSpecialCase(VDBEnums.SPECIAL_CASES.IS_SETTER);
        this.getRules().add(r);
        r = new Rule();
        r.setRuleName("createdfrom uri - sink - rule");
        g = r.createLogicGate(VDBEnums.RULE_GATE_TYPE.AND);
        r1 = g.createRule();
        r1.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r1.getMethodRule().getSignatureRule().setRuleValue("createdfrom");
        r1 = g.createRule();
        r1.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r1.getMethodRule().getSignatureRule().setRuleValue("uri");
        r.getSpecialCaseRule().setSpecialCase(VDBEnums.SPECIAL_CASES.IS_SETTER);
        this.getRules().add(r);
        r = new Rule();
        r.setRuleName("create...withurl - sink - rule");
        g = r.createLogicGate(VDBEnums.RULE_GATE_TYPE.AND);
        r1 = g.createRule();
        r1.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r1.getMethodRule().getSignatureRule().setRuleValue("create");
        r1 = g.createRule();
        r1.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r1.getMethodRule().getSignatureRule().setRuleValue("withurl");
        this.getRules().add(r);
        r = new Rule();
        r.setRuleName("set...url - sink - rule");
        r.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.STARTS_WITH);
        r.getMethodRule().getSignatureRule().setRuleValue("set");
        g = r.createLogicGate(VDBEnums.RULE_GATE_TYPE.OR);
        r1 = g.createRule();
        r1.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r1.getMethodRule().getSignatureRule().setRuleValue("url");
        r1 = g.createRule();
        r1.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r1.getMethodRule().getSignatureRule().setRuleValue("uri");
        r1 = g.createRule();
        r1.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.ENDS_WITH);
        r1.getMethodRule().getSignatureRule().setRuleValue("errormessage");
        r1 = g.createRule();
        r1.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r1.getMethodRule().getSignatureRule().setRuleValue("path");
        r1 = g.createRule();
        r1.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r1.getMethodRule().getSignatureRule().setRuleValue("href");
        r1 = g.createRule();
        r1.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r1.getMethodRule().getSignatureRule().setRuleValue("html");
        this.getRules().add(r);
        r = new Rule();
        r.setRuleName("xpath...* - sink - rule");
        g = r.createLogicGate(VDBEnums.RULE_GATE_TYPE.OR);
        r1 = g.createRule();
        r1.getMethodRule().getClassRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r1.getMethodRule().getClassRule().setRuleValue("xpath");
        r1 = g.createRule();
        r1.getMethodRule().getPackageRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r1.getMethodRule().getPackageRule().setRuleValue("xpath");
        r1 = g.createRule();
        r1.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r1.getMethodRule().getSignatureRule().setRuleValue("xpath");
        g = r.createLogicGate(VDBEnums.RULE_GATE_TYPE.OR);
        r1 = g.createRule();
        r1.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r1.getMethodRule().getSignatureRule().setRuleValue("eval");
        r1 = g.createRule();
        r1.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r1.getMethodRule().getSignatureRule().setRuleValue("match");
        r1 = g.createRule();
        r1.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r1.getMethodRule().getSignatureRule().setRuleValue("select");
        r1 = g.createRule();
        r1.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r1.getMethodRule().getSignatureRule().setRuleValue("compile");
        this.getRules().add(r);
        r = new Rule();
        r.setRuleName("xml...* - sink - rule");
        g = r.createLogicGate(VDBEnums.RULE_GATE_TYPE.OR);
        r1 = g.createRule();
        r1.getMethodRule().getClassRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r1.getMethodRule().getClassRule().setRuleValue("xml");
        r1 = g.createRule();
        r1.getMethodRule().getPackageRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r1.getMethodRule().getPackageRule().setRuleValue("xml");
        r1 = g.createRule();
        r1.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r1.getMethodRule().getSignatureRule().setRuleValue("xml");
        g = r.createLogicGate(VDBEnums.RULE_GATE_TYPE.OR);
        r1 = g.createRule();
        r1.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.STARTS_WITH);
        r1.getMethodRule().getSignatureRule().setRuleValue("setName");
        r1 = g.createRule();
        r1.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r1.getMethodRule().getSignatureRule().setRuleValue("GetSchemaByUri");
        r1 = g.createRule();
        r1.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r1.getMethodRule().getSignatureRule().setRuleValue("setSchema");
        r1 = g.createRule();
        r1.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r1.getMethodRule().getSignatureRule().setRuleValue("setPrefix");
        r1 = g.createRule();
        r1.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r1.getMethodRule().getSignatureRule().setRuleValue("namespace");
        this.getRules().add(r);
        r = new Rule();
        r.setRuleName("mapreduce...operation - sink - rule");
        g = r.createLogicGate(VDBEnums.RULE_GATE_TYPE.AND);
        r1 = g.createRule();
        r1.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r1.getMethodRule().getSignatureRule().setRuleValue("mapreduce");
        r1 = g.createRule();
        r1.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r1.getMethodRule().getSignatureRule().setRuleValue("operation");
        this.getRules().add(r);
        r = new Rule();
        r.setRuleName("exception with string");
        r.getSpecialCaseRule().setSpecialCase(VDBEnums.SPECIAL_CASES.IS_CONSTRUCTOR);
        g = r.createLogicGate(VDBEnums.RULE_GATE_TYPE.OR);
        r1 = g.createRule();
        r1.getMethodRule().getClassRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r1.getMethodRule().getClassRule().setRuleValue("exception");
        r1 = g.createRule();
        r1.getMethodRule().getClassRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r1.getMethodRule().getClassRule().setRuleValue("error");
        r.getMethodRule().getArgumentRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r.getMethodRule().getArgumentRule().setRuleValue("string");
        this.getRules().add(r);
        r = new Rule();
        r.setRuleName("run - more than 0 args - sink - rule");
        r.getMethodRule().getArgCountRule().setRuleOperator(VDBEnums.RULE_OPERATOR.INTEGER_GREATER_THAN);
        r.getMethodRule().getArgCountRule().setArgCountValue(0);
        r.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.EQUALS);
        r.getMethodRule().getSignatureRule().setRuleValue("run");
        this.getRules().add(r);
        r = new Rule();
        r.setRuleName("sql sinks");
        g = r.createLogicGate(VDBEnums.RULE_GATE_TYPE.OR);
        r1 = g.createRule();
        r1.getMethodRule().getPackageRule().setRuleOperator(VDBEnums.RULE_OPERATOR.STARTS_WITH);
        r1.getMethodRule().getPackageRule().setRuleValue("ADODB");
        r1 = g.createRule();
        r1.getMethodRule().getPackageRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r1.getMethodRule().getPackageRule().setRuleValue("sql");
        r1 = g.createRule();
        r1.getMethodRule().getClassRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r1.getMethodRule().getClassRule().setRuleValue("sql");
        r1 = g.createRule();
        r1.getMethodRule().getClassRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r1.getMethodRule().getClassRule().setRuleValue("dbconnection");
        r1 = g.createRule();
        r1.getMethodRule().getPackageRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r1.getMethodRule().getPackageRule().setRuleValue("database");
        r1 = g.createRule();
        r1.getMethodRule().getClassRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r1.getMethodRule().getClassRule().setRuleValue("database");
        r1 = g.createRule();
        r1.getMethodRule().getPackageRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r1.getMethodRule().getPackageRule().setRuleValue("hibernate");
        r1 = g.createRule();
        r1.getMethodRule().getClassRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r1.getMethodRule().getClassRule().setRuleValue("hibernate");
        r1 = g.createRule();
        r1.getMethodRule().getPackageRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r1.getMethodRule().getPackageRule().setRuleValue("jdbc");
        r1 = g.createRule();
        r1.getMethodRule().getClassRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r1.getMethodRule().getClassRule().setRuleValue("jdbc");
        r1 = g.createRule();
        r1.getMethodRule().getPackageRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r1.getMethodRule().getPackageRule().setRuleValue("odbc");
        r1 = g.createRule();
        r1.getMethodRule().getClassRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r1.getMethodRule().getClassRule().setRuleValue("odbc");
        g = r.createLogicGate(VDBEnums.RULE_GATE_TYPE.OR);
        r1 = g.createRule();
        r1.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.EQUALS);
        r1.getMethodRule().getSignatureRule().setRuleValue("Delete");
        r1 = g.createRule();
        r1.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.EQUALS);
        r1.getMethodRule().getSignatureRule().setRuleValue("open");
        r1 = g.createRule();
        r1.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r1.getMethodRule().getSignatureRule().setRuleValue("update");
        r1 = g.createRule();
        r1.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r1.getMethodRule().getSignatureRule().setRuleValue("insert");
        r1 = g.createRule();
        r1.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r1.getMethodRule().getSignatureRule().setRuleValue("select");
        r1 = g.createRule();
        r1.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.EQUALS);
        r1.getMethodRule().getSignatureRule().setRuleValue("exec");
        r1 = g.createRule();
        r1.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.EQUALS);
        r1.getMethodRule().getSignatureRule().setRuleValue("setbyte");
        r1 = g.createRule();
        r1.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.EQUALS);
        r1.getMethodRule().getSignatureRule().setRuleValue("setstring");
        r1 = g.createRule();
        r1.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.EQUALS);
        r1.getMethodRule().getSignatureRule().setRuleValue("setbytes");
        r1 = g.createRule();
        r1.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.EQUALS);
        r1.getMethodRule().getSignatureRule().setRuleValue("setref");
        r1 = g.createRule();
        r1.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.EQUALS);
        r1.getMethodRule().getSignatureRule().setRuleValue("setobject");
        r1 = g.createRule();
        r1.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r1.getMethodRule().getSignatureRule().setRuleValue("compile");
        r1 = g.createRule();
        r1.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.EQUALS);
        r1.getMethodRule().getSignatureRule().setRuleValue("setTables");
        r1 = g.createRule();
        r1.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.EQUALS);
        r1.getMethodRule().getSignatureRule().setRuleValue("setChar");
        this.getRules().add(r);
        r1 = g.createRule();
        r1.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.EQUALS);
        r1.getMethodRule().getSignatureRule().setRuleValue("setUnicodeStream");
        r1 = g.createRule();
        r1.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r1.getMethodRule().getSignatureRule().setRuleValue("prepare");
        r1 = g.createRule();
        r1.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r1.getMethodRule().getSignatureRule().setRuleValue("setStream");
        r1 = g.createRule();
        r1.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r1.getMethodRule().getSignatureRule().setRuleValue("setBlob");
        r1 = g.createRule();
        r1.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r1.getMethodRule().getSignatureRule().setRuleValue("setClob");
        this.getRules().add(r);
        r = new Rule();
        r.setRuleName("file sinks");
        r.getSpecialCaseRule().setSpecialCase(VDBEnums.SPECIAL_CASES.IS_CONSTRUCTOR);
        g = r.createLogicGate(VDBEnums.RULE_GATE_TYPE.AND);
        r1 = g.createRule();
        r1.getMethodRule().getClassRule().setRuleOperator(VDBEnums.RULE_OPERATOR.DOES_NOT_CONTAIN);
        r1.getMethodRule().getClassRule().setRuleValue("exception");
        r1.getMethodRule().getPackageRule().setRuleOperator(VDBEnums.RULE_OPERATOR.DOES_NOT_CONTAIN);
        r1.getMethodRule().getPackageRule().setRuleValue("exception");
        r1 = g.createRule();
        r1.getMethodRule().getClassRule().setRuleOperator(VDBEnums.RULE_OPERATOR.DOES_NOT_CONTAIN);
        r1.getMethodRule().getClassRule().setRuleValue("profile");
        r1.getMethodRule().getPackageRule().setRuleOperator(VDBEnums.RULE_OPERATOR.DOES_NOT_CONTAIN);
        r1.getMethodRule().getPackageRule().setRuleValue("profile");
        g = r.createLogicGate(VDBEnums.RULE_GATE_TYPE.OR);
        r1 = g.createRule();
        r1.getMethodRule().getPackageRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r1.getMethodRule().getPackageRule().setRuleValue("file");
        r1 = g.createRule();
        r1.getMethodRule().getClassRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r1.getMethodRule().getClassRule().setRuleValue("file");
        g = r.createLogicGate(VDBEnums.RULE_GATE_TYPE.OR);
        r1 = g.createRule();
        r1.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.EQUALS);
        r1.getMethodRule().getSignatureRule().setRuleValue("init");
        r1 = g.createRule();
        r1.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.STARTS_WITH);
        r1.getMethodRule().getSignatureRule().setRuleValue("copy");
        r1 = g.createRule();
        r1.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.STARTS_WITH);
        r1.getMethodRule().getSignatureRule().setRuleValue("open");
        this.getRules().add(r);
        r = new Rule();
        r.setRuleName("stream sinks");
        r.getSpecialCaseRule().setSpecialCase(VDBEnums.SPECIAL_CASES.IS_CONSTRUCTOR);
        r.getMethodRule().getArgCountRule().setRuleOperator(VDBEnums.RULE_OPERATOR.INTEGER_GREATER_THAN);
        r.getMethodRule().getArgCountRule().setArgCountValue(0);
        r1 = g.createRule();
        r1.getMethodRule().getArgumentRule().setRuleOperator(VDBEnums.RULE_OPERATOR.DOES_NOT_CONTAIN);
        r1.getMethodRule().getArgumentRule().setRuleValue("stream");
        r1 = g.createRule();
        r1.getMethodRule().getArgumentRule().setRuleOperator(VDBEnums.RULE_OPERATOR.DOES_NOT_CONTAIN);
        r1.getMethodRule().getArgumentRule().setRuleValue("writer");
        r1 = g.createRule();
        r1.getMethodRule().getArgumentRule().setRuleOperator(VDBEnums.RULE_OPERATOR.DOES_NOT_CONTAIN);
        r1.getMethodRule().getArgumentRule().setRuleValue("reader");
        r1 = g.createRule();
        r1.getMethodRule().getArgumentRule().setRuleOperator(VDBEnums.RULE_OPERATOR.DOES_NOT_CONTAIN);
        r1.getMethodRule().getArgumentRule().setRuleValue("channel");
        g = r.createLogicGate(VDBEnums.RULE_GATE_TYPE.OR);
        r1 = g.createRule();
        r1.getMethodRule().getPackageRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r1.getMethodRule().getPackageRule().setRuleValue("stream");
        r1 = g.createRule();
        r1.getMethodRule().getClassRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r1.getMethodRule().getClassRule().setRuleValue("stream");
        g = r.createLogicGate(VDBEnums.RULE_GATE_TYPE.OR);
        r1 = g.createRule();
        r1.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.STARTS_WITH);
        r1.getMethodRule().getSignatureRule().setRuleValue("copy");
        this.getRules().add(r);
        r = new Rule();
        r.setRuleName("constructor sinks");
        g = r.createLogicGate(VDBEnums.RULE_GATE_TYPE.AND);
        r1 = g.createRule();
        r1.getSpecialCaseRule().setSpecialCase(VDBEnums.SPECIAL_CASES.IS_CONSTRUCTOR);
        r1 = g.createRule();
        r1.getMethodRule().getClassRule().setRuleOperator(VDBEnums.RULE_OPERATOR.DOES_NOT_CONTAIN);
        r1.getMethodRule().getClassRule().setRuleValue("stream");
        g = r.createLogicGate(VDBEnums.RULE_GATE_TYPE.OR);
        r1 = g.createRule();
        r1.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r1.getMethodRule().getSignatureRule().setRuleValue("HttpDelete");
        r1 = g.createRule();
        r1.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r1.getMethodRule().getSignatureRule().setRuleValue("HttpPost");
        r1 = g.createRule();
        r1.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r1.getMethodRule().getSignatureRule().setRuleValue("HttpGet");
        r1 = g.createRule();
        r1.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r1.getMethodRule().getSignatureRule().setRuleValue("password");
        r1.getSpecialCaseRule().setSpecialCase(VDBEnums.SPECIAL_CASES.IS_CONSTRUCTOR);
        this.getRules().add(r);
        r = new Rule();
        r.setRuleName("SQL exec sinks");
        r.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.STARTS_WITH);
        r.getMethodRule().getSignatureRule().setRuleValue("exec");
        g = r.createLogicGate(VDBEnums.RULE_GATE_TYPE.OR);
        r1 = g.createRule();
        r1.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r1.getMethodRule().getSignatureRule().setRuleValue("sql");
        r1 = g.createRule();
        r1.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r1.getMethodRule().getSignatureRule().setRuleValue("query");
        r1 = g.createRule();
        r1.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r1.getMethodRule().getSignatureRule().setRuleValue("command");
        r1 = g.createRule();
        r1.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r1.getMethodRule().getSignatureRule().setRuleValue("function");
        r1 = g.createRule();
        r1.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r1.getMethodRule().getSignatureRule().setRuleValue("assembly");
        r1 = g.createRule();
        r1.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r1.getMethodRule().getSignatureRule().setRuleValue("script");
        r1 = g.createRule();
        r1.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r1.getMethodRule().getSignatureRule().setRuleValue("update");
        r1 = g.createRule();
        r1.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r1.getMethodRule().getSignatureRule().setRuleValue("insert");
        r1 = g.createRule();
        r1.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r1.getMethodRule().getSignatureRule().setRuleValue("select");
        r1 = g.createRule();
        r1.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r1.getMethodRule().getSignatureRule().setRuleValue("delete");
        this.getRules().add(r);
        r = new Rule();
        r.setRuleName("response sinks");
        r.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.STARTS_WITH);
        r.getMethodRule().getSignatureRule().setRuleValue("response");
        g = r.createLogicGate(VDBEnums.RULE_GATE_TYPE.OR);
        r1 = g.createRule();
        r1.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r1.getMethodRule().getSignatureRule().setRuleValue("cookievalue");
        r1 = g.createRule();
        r1.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r1.getMethodRule().getSignatureRule().setRuleValue("cookietext");
        r1 = g.createRule();
        r1.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r1.getMethodRule().getSignatureRule().setRuleValue("cookiesubvalue");
        r1 = g.createRule();
        r1.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r1.getMethodRule().getSignatureRule().setRuleValue("addcookie");
        r1 = g.createRule();
        r1.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r1.getMethodRule().getSignatureRule().setRuleValue("redirect");
        r1 = g.createRule();
        r1.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r1.getMethodRule().getSignatureRule().setRuleValue("addheader");
        r1 = g.createRule();
        r1.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r1.getMethodRule().getSignatureRule().setRuleValue("headertext");
        r1 = g.createRule();
        r1.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r1.getMethodRule().getSignatureRule().setRuleValue("function");
        r1 = g.createRule();
        r1.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r1.getMethodRule().getSignatureRule().setRuleValue("assembly");
        r1 = g.createRule();
        r1.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r1.getMethodRule().getSignatureRule().setRuleValue("script");
        this.getRules().add(r);
        r = new Rule();
        r.setRuleName("web control sinks sinks");
        g = r.createLogicGate(VDBEnums.RULE_GATE_TYPE.OR);
        r1 = g.createRule();
        r1.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.STARTS_WITH);
        r1.getMethodRule().getSignatureRule().setRuleValue("settext");
        r1 = g.createRule();
        r1.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.STARTS_WITH);
        r1.getMethodRule().getSignatureRule().setRuleValue("settitle");
        r1 = g.createRule();
        r1.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.STARTS_WITH);
        r1.getMethodRule().getSignatureRule().setRuleValue("setheadertext");
        r1 = g.createRule();
        r1.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.STARTS_WITH);
        r1.getMethodRule().getSignatureRule().setRuleValue("setitem");
        r1 = g.createRule();
        r1.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.STARTS_WITH);
        r1.getMethodRule().getSignatureRule().setRuleValue("open");
        r1 = g.createRule();
        r1.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r1.getMethodRule().getSignatureRule().setRuleValue("post");
        r1 = g.createRule();
        r1.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r1.getMethodRule().getSignatureRule().setRuleValue("put");
        r1 = g.createRule();
        r1.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r1.getMethodRule().getSignatureRule().setRuleValue("get");
        g = r.createLogicGate(VDBEnums.RULE_GATE_TYPE.OR);
        r1 = g.createRule();
        r1.getMethodRule().getClassRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r1.getMethodRule().getClassRule().setRuleValue("web");
        r1 = g.createRule();
        r1.getMethodRule().getPackageRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r1.getMethodRule().getPackageRule().setRuleValue("web");
        r1 = g.createRule();
        r1.getMethodRule().getClassRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r1.getMethodRule().getClassRule().setRuleValue("http");
        r1 = g.createRule();
        r1.getMethodRule().getPackageRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r1.getMethodRule().getPackageRule().setRuleValue("http");
        r1 = g.createRule();
        r1.getMethodRule().getPackageRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r1.getMethodRule().getPackageRule().setRuleValue("cookie");
        this.getRules().add(r);
        r = new Rule();
        r.setRuleName("android - sink");
        r.getMethodRule().getPackageRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r.getMethodRule().getPackageRule().setRuleValue("android");
        g = r.createLogicGate(VDBEnums.RULE_GATE_TYPE.OR);
        r1 = g.createRule();
        r1.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.EQUALS);
        r1.getMethodRule().getSignatureRule().setRuleValue("addData");
        r1 = g.createRule();
        r1.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.EQUALS);
        r1.getMethodRule().getSignatureRule().setRuleValue("bindService");
        r1 = g.createRule();
        r1.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.EQUALS);
        r1.getMethodRule().getSignatureRule().setRuleValue("w");
        r1 = g.createRule();
        r1.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.EQUALS);
        r1.getMethodRule().getSignatureRule().setRuleValue("i");
        r1 = g.createRule();
        r1.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.EQUALS);
        r1.getMethodRule().getSignatureRule().setRuleValue("d");
        r1 = g.createRule();
        r1.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.EQUALS);
        r1.getMethodRule().getSignatureRule().setRuleValue("println");
        r1 = g.createRule();
        r1.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.EQUALS);
        r1.getMethodRule().getSignatureRule().setRuleValue("instantiate");
        r1 = g.createRule();
        r1.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.EQUALS);
        r1.getMethodRule().getSignatureRule().setRuleValue("bindService");
        r1 = g.createRule();
        r1.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.EQUALS);
        r1.getMethodRule().getSignatureRule().setRuleValue("deleteFile");
        r1 = g.createRule();
        r1.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.EQUALS);
        r1.getMethodRule().getSignatureRule().setRuleValue("transact");
        r1 = g.createRule();
        r1.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.EQUALS);
        r1.getMethodRule().getSignatureRule().setRuleValue("addText");
        r1 = g.createRule();
        r1.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.EQUALS);
        r1.getMethodRule().getSignatureRule().setRuleValue("v");
        r1 = g.createRule();
        r1.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.EQUALS);
        r1.getMethodRule().getSignatureRule().setRuleValue("proceed");
        r1 = g.createRule();
        r1.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.EQUALS);
        r1.getMethodRule().getSignatureRule().setRuleValue("startService");
        r1 = g.createRule();
        r1.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.EQUALS);
        r1.getMethodRule().getSignatureRule().setRuleValue("openFileOutput");
        r1 = g.createRule();
        r1.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.EQUALS);
        r1.getMethodRule().getSignatureRule().setRuleValue("grantUriPermission");
        r1 = g.createRule();
        r1.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.STARTS_WITH);
        r1.getMethodRule().getSignatureRule().setRuleValue("startActivit");
        r1 = g.createRule();
        r1.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.EQUALS);
        r1.getMethodRule().getSignatureRule().setRuleValue("setResultData");
        r1 = g.createRule();
        r1.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.EQUALS);
        r1.getMethodRule().getSignatureRule().setRuleValue("putString");
        r1 = g.createRule();
        r1.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.EQUALS);
        r1.getMethodRule().getSignatureRule().setRuleValue("addFile");
        r1 = g.createRule();
        r1.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.EQUALS);
        r1.getMethodRule().getSignatureRule().setRuleValue("startWithFragment");
        r1 = g.createRule();
        r1.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.EQUALS);
        r1.getMethodRule().getSignatureRule().setRuleValue("setDataSource");
        r1 = g.createRule();
        r1.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.EQUALS);
        r1.getMethodRule().getSignatureRule().setRuleValue("mountObb");
        this.getRules().add(r);
        r = new Rule();
        r.setRuleName("mail sinks");
        g = r.createLogicGate(VDBEnums.RULE_GATE_TYPE.OR);
        r1 = g.createRule();
        r1.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r1.getMethodRule().getSignatureRule().setRuleValue("subject");
        r1 = g.createRule();
        r1.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r1.getMethodRule().getSignatureRule().setRuleValue("cc");
        r1 = g.createRule();
        r1.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r1.getMethodRule().getSignatureRule().setRuleValue("setbcc");
        r1 = g.createRule();
        r1.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.STARTS_WITH);
        r1.getMethodRule().getSignatureRule().setRuleValue("recipient");
        g = r.createLogicGate(VDBEnums.RULE_GATE_TYPE.OR);
        r1 = g.createRule();
        r1.getMethodRule().getClassRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r1.getMethodRule().getClassRule().setRuleValue("mail");
        r1 = g.createRule();
        r1.getMethodRule().getPackageRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r1.getMethodRule().getPackageRule().setRuleValue("mail");
        r1 = g.createRule();
        r1.getMethodRule().getClassRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r1.getMethodRule().getClassRule().setRuleValue("mime");
        r1 = g.createRule();
        r1.getMethodRule().getPackageRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r1.getMethodRule().getPackageRule().setRuleValue("mime");
        this.getRules().add(r);
        r = new Rule();
        r.setRuleName("getInputStream 1 arg");
        r.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.EQUALS);
        r.getMethodRule().getSignatureRule().setRuleValue("getInputStream");
        r.getMethodRule().getArgCountRule().setRuleOperator(VDBEnums.RULE_OPERATOR.INTEGER_EQUALS);
        r.getMethodRule().getArgCountRule().setArgCountValue(1);
        this.getRules().add(r);
        r = new Rule();
        r.setRuleName("url or uri arg 1 arg");
        r.getMethodRule().getArgCountRule().setRuleOperator(VDBEnums.RULE_OPERATOR.INTEGER_EQUALS);
        r.getMethodRule().getArgCountRule().setArgCountValue(1);
        g = r.createLogicGate(VDBEnums.RULE_GATE_TYPE.OR);
        r1 = g.createRule();
        r1.getMethodRule().getArgumentRule().setRuleOperator(VDBEnums.RULE_OPERATOR.EQUALS);
        r1.getMethodRule().getArgumentRule().setRuleValue("java.net.URL");
        r1 = g.createRule();
        r1.getMethodRule().getArgumentRule().setRuleOperator(VDBEnums.RULE_OPERATOR.EQUALS);
        r1.getMethodRule().getArgumentRule().setRuleValue("java.net.URI");
        this.getRules().add(r);
        r = new Rule();
        r.setRuleName("JSON sinks");
        g = r.createLogicGate(VDBEnums.RULE_GATE_TYPE.OR);
        r1 = g.createRule();
        r1.getMethodRule().getClassRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r1.getMethodRule().getClassRule().setRuleValue("json");
        r1 = g.createRule();
        r1.getMethodRule().getPackageRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r1.getMethodRule().getPackageRule().setRuleValue("json");
        g = r.createLogicGate(VDBEnums.RULE_GATE_TYPE.OR);
        r1 = g.createRule();
        r1.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r1.getMethodRule().getSignatureRule().setRuleValue("parse");
        this.getRules().add(r);
    }

    @Override
    protected void initAntiRules() throws MarkupException, BadRuleException {
        Rule r = new Rule();
        r.setRuleName("no args - anti sink");
        r.getMethodRule().getArgCountRule().setRuleOperator(VDBEnums.RULE_OPERATOR.INTEGER_EQUALS);
        r.getMethodRule().getArgCountRule().setArgCountValue(0);
        this.getAntiRules().add(r);
        r = new Rule();
        r.setRuleName("Constructor no string arg");
        r.getSpecialCaseRule().setSpecialCase(VDBEnums.SPECIAL_CASES.IS_CONSTRUCTOR);
        r.getMethodRule().getArgumentRule().setRuleOperator(VDBEnums.RULE_OPERATOR.DOES_NOT_CONTAIN);
        r.getMethodRule().getArgumentRule().setRuleValue("string");
        this.getAntiRules().add(r);
        r = new Rule();
        r.setRuleName("Creating ui component");
        r.getMethodRule().getPackageRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r.getMethodRule().getPackageRule().setRuleValue("UI");
        r.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r.getMethodRule().getSignatureRule().setRuleValue("create");
        this.getAntiRules().add(r);
        r = new Rule();
        r.setRuleName("exception without string");
        r.getSpecialCaseRule().setSpecialCase(VDBEnums.SPECIAL_CASES.IS_CONSTRUCTOR);
        BaseLogicGate g = r.createLogicGate(VDBEnums.RULE_GATE_TYPE.OR);
        Rule r1 = g.createRule();
        r1.getMethodRule().getClassRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r1.getMethodRule().getClassRule().setRuleValue("exception");
        r1 = g.createRule();
        r1.getMethodRule().getClassRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r1.getMethodRule().getClassRule().setRuleValue("error");
        r.getMethodRule().getArgumentRule().setRuleOperator(VDBEnums.RULE_OPERATOR.DOES_NOT_CONTAIN);
        r.getMethodRule().getArgumentRule().setRuleValue("string");
        this.getAntiRules().add(r);
        r = new Rule();
        r.setRuleName("Number only args - sink - anti");
        r.getMethodRule().getArgumentRule().setRuleOperator(VDBEnums.RULE_OPERATOR.EQUALS);
        r.getMethodRule().getArgumentRule().setRuleValue("number");
        this.getAntiRules().add(r);
        r = new Rule();
        r.setRuleName("Graphic only args - sink - anti");
        r.getMethodRule().getArgumentRule().setRuleOperator(VDBEnums.RULE_OPERATOR.EQUALS);
        r.getMethodRule().getArgumentRule().setRuleValue("java.awt.Graphics");
        this.getAntiRules().add(r);
        r = new Rule();
        r.setRuleName("boolean only args - sink - anti");
        r.getMethodRule().getArgumentRule().setRuleOperator(VDBEnums.RULE_OPERATOR.EQUALS);
        r.getMethodRule().getArgumentRule().setRuleValue("boolean");
        this.getAntiRules().add(r);
        r = new Rule();
        r.setRuleName("date only args - sink - anti");
        r.getMethodRule().getArgumentRule().setRuleOperator(VDBEnums.RULE_OPERATOR.EQUALS);
        r.getMethodRule().getArgumentRule().setRuleValue("date");
        this.getAntiRules().add(r);
        r = new Rule();
        r.setRuleName("File arg - sink - anti");
        r.getMethodRule().getArgumentRule().setRuleOperator(VDBEnums.RULE_OPERATOR.EQUALS);
        r.getMethodRule().getArgumentRule().setRuleValue("java.io.File");
        this.getAntiRules().add(r);
        r = new Rule();
        r.setRuleName("File arg - sink - anti");
        r.getMethodRule().getArgumentRule().setRuleOperator(VDBEnums.RULE_OPERATOR.EQUALS);
        r.getMethodRule().getArgumentRule().setRuleValue("java.io.FileDescriptor");
        this.getAntiRules().add(r);
        r = new Rule();
        r.setRuleName("Date or number class - anti sink");
        g = r.createLogicGate(VDBEnums.RULE_GATE_TYPE.AND);
        r1 = g.createRule();
        r1.getMethodRule().getClassRule().setRuleOperator(VDBEnums.RULE_OPERATOR.DOES_NOT_CONTAIN);
        r1.getMethodRule().getClassRule().setRuleValue("runtime");
        r1 = g.createRule();
        r1.getMethodRule().getPackageRule().setRuleOperator(VDBEnums.RULE_OPERATOR.DOES_NOT_CONTAIN);
        r1.getMethodRule().getPackageRule().setRuleValue("runtime");
        r1 = g.createRule();
        r1.getMethodRule().getClassRule().setRuleOperator(VDBEnums.RULE_OPERATOR.DOES_NOT_CONTAIN);
        r1.getMethodRule().getClassRule().setRuleValue("vectorwriter");
        r1 = g.createRule();
        r1.getMethodRule().getPackageRule().setRuleOperator(VDBEnums.RULE_OPERATOR.DOES_NOT_CONTAIN);
        r1.getMethodRule().getPackageRule().setRuleValue("vectorwriter");
        g = r.createLogicGate(VDBEnums.RULE_GATE_TYPE.OR);
        r1 = g.createRule();
        r1.getMethodRule().getClassRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r1.getMethodRule().getClassRule().setRuleValue("date");
        r1 = g.createRule();
        r1.getMethodRule().getPackageRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r1.getMethodRule().getPackageRule().setRuleValue("date");
        r1 = g.createRule();
        r1.getMethodRule().getClassRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r1.getMethodRule().getClassRule().setRuleValue("time");
        r1 = g.createRule();
        r1.getMethodRule().getPackageRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r1.getMethodRule().getPackageRule().setRuleValue("time");
        r1 = g.createRule();
        r1.getMethodRule().getClassRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r1.getMethodRule().getClassRule().setRuleValue("locale");
        r1 = g.createRule();
        r1.getMethodRule().getPackageRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r1.getMethodRule().getPackageRule().setRuleValue("locale");
        r1 = g.createRule();
        r1.getMethodRule().getClassRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r1.getMethodRule().getClassRule().setRuleValue("icuservicee");
        r1 = g.createRule();
        r1.getMethodRule().getPackageRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r1.getMethodRule().getPackageRule().setRuleValue("icuservicee");
        r1 = g.createRule();
        r1.getMethodRule().getClassRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r1.getMethodRule().getClassRule().setRuleValue("duration");
        r1 = g.createRule();
        r1.getMethodRule().getPackageRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r1.getMethodRule().getPackageRule().setRuleValue("duration");
        r1 = g.createRule();
        r1.getMethodRule().getClassRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r1.getMethodRule().getClassRule().setRuleValue("decimal");
        r1 = g.createRule();
        r1.getMethodRule().getPackageRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r1.getMethodRule().getPackageRule().setRuleValue("decimal");
        r1 = g.createRule();
        r1.getMethodRule().getClassRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r1.getMethodRule().getClassRule().setRuleValue("measure");
        r1 = g.createRule();
        r1.getMethodRule().getPackageRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r1.getMethodRule().getPackageRule().setRuleValue("measure");
        r1 = g.createRule();
        r1.getMethodRule().getClassRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r1.getMethodRule().getClassRule().setRuleValue("currency");
        r1 = g.createRule();
        r1.getMethodRule().getPackageRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r1.getMethodRule().getPackageRule().setRuleValue("currency");
        r1 = g.createRule();
        r1.getMethodRule().getClassRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r1.getMethodRule().getClassRule().setRuleValue("number");
        r1 = g.createRule();
        r1.getMethodRule().getPackageRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r1.getMethodRule().getPackageRule().setRuleValue("number");
        r1 = g.createRule();
        r1.getMethodRule().getClassRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r1.getMethodRule().getClassRule().setRuleValue("decimal");
        r1 = g.createRule();
        r1.getMethodRule().getPackageRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r1.getMethodRule().getPackageRule().setRuleValue("decimal");
        r1 = g.createRule();
        r1.getMethodRule().getClassRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r1.getMethodRule().getClassRule().setRuleValue("path2d");
        r1 = g.createRule();
        r1.getMethodRule().getPackageRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r1.getMethodRule().getPackageRule().setRuleValue("path2d");
        r1 = g.createRule();
        r1.getMethodRule().getClassRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r1.getMethodRule().getClassRule().setRuleValue("event");
        r1 = g.createRule();
        r1.getMethodRule().getPackageRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r1.getMethodRule().getPackageRule().setRuleValue("event");
        r1 = g.createRule();
        r1.getMethodRule().getClassRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r1.getMethodRule().getClassRule().setRuleValue("lock");
        r1 = g.createRule();
        r1.getMethodRule().getPackageRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r1.getMethodRule().getPackageRule().setRuleValue("lock");
        r1 = g.createRule();
        r1.getMethodRule().getClassRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r1.getMethodRule().getClassRule().setRuleValue(".map.");
        r1 = g.createRule();
        r1.getMethodRule().getPackageRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r1.getMethodRule().getPackageRule().setRuleValue(".map.");
        r1 = g.createRule();
        r1.getMethodRule().getClassRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r1.getMethodRule().getClassRule().setRuleValue("list");
        r1 = g.createRule();
        r1.getMethodRule().getPackageRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r1.getMethodRule().getPackageRule().setRuleValue("list");
        r1 = g.createRule();
        r1.getMethodRule().getClassRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r1.getMethodRule().getClassRule().setRuleValue("array");
        r1 = g.createRule();
        r1.getMethodRule().getPackageRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r1.getMethodRule().getPackageRule().setRuleValue("array");
        r1 = g.createRule();
        r1.getMethodRule().getClassRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r1.getMethodRule().getClassRule().setRuleValue("vector");
        r1 = g.createRule();
        r1.getMethodRule().getPackageRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r1.getMethodRule().getPackageRule().setRuleValue("vector");
        r1 = g.createRule();
        r1.getMethodRule().getClassRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r1.getMethodRule().getClassRule().setRuleValue("treeset");
        r1 = g.createRule();
        r1.getMethodRule().getPackageRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r1.getMethodRule().getPackageRule().setRuleValue("treeset");
        r1 = g.createRule();
        r1.getMethodRule().getClassRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r1.getMethodRule().getClassRule().setRuleValue("hash");
        r1 = g.createRule();
        r1.getMethodRule().getPackageRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r1.getMethodRule().getPackageRule().setRuleValue("hash");
        r1 = g.createRule();
        r1.getMethodRule().getClassRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r1.getMethodRule().getClassRule().setRuleValue("calendar");
        r1 = g.createRule();
        r1.getMethodRule().getPackageRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r1.getMethodRule().getPackageRule().setRuleValue("calendar");
        r1 = g.createRule();
        r1.getMethodRule().getClassRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r1.getMethodRule().getClassRule().setRuleValue("inet");
        r1 = g.createRule();
        r1.getMethodRule().getPackageRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r1.getMethodRule().getPackageRule().setRuleValue("inet");
        r1 = g.createRule();
        r1.getMethodRule().getClassRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r1.getMethodRule().getClassRule().setRuleValue("integer");
        r1 = g.createRule();
        r1.getMethodRule().getPackageRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r1.getMethodRule().getPackageRule().setRuleValue("integer");
        r1 = g.createRule();
        r1.getMethodRule().getClassRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r1.getMethodRule().getClassRule().setRuleValue("enum");
        r1 = g.createRule();
        r1.getMethodRule().getPackageRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r1.getMethodRule().getPackageRule().setRuleValue("enum");
        r1 = g.createRule();
        r1.getMethodRule().getClassRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r1.getMethodRule().getClassRule().setRuleValue("camera");
        r1 = g.createRule();
        r1.getMethodRule().getPackageRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r1.getMethodRule().getPackageRule().setRuleValue("camera");
        r1 = g.createRule();
        r1.getMethodRule().getClassRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r1.getMethodRule().getClassRule().setRuleValue("icon");
        r1 = g.createRule();
        r1.getMethodRule().getPackageRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r1.getMethodRule().getPackageRule().setRuleValue("icon");
        r1 = g.createRule();
        r1.getMethodRule().getClassRule().setRuleOperator(VDBEnums.RULE_OPERATOR.EQUALS);
        r1.getMethodRule().getClassRule().setRuleValue("random");
        r1 = g.createRule();
        r1.getMethodRule().getPackageRule().setRuleOperator(VDBEnums.RULE_OPERATOR.EQUALS);
        r1.getMethodRule().getPackageRule().setRuleValue("random");
        r1 = g.createRule();
        r1.getMethodRule().getClassRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r1.getMethodRule().getClassRule().setRuleValue("mouse");
        r1 = g.createRule();
        r1.getMethodRule().getPackageRule().setRuleOperator(VDBEnums.RULE_OPERATOR.EQUALS);
        r1.getMethodRule().getPackageRule().setRuleValue("mouse");
        r1 = g.createRule();
        r1.getMethodRule().getClassRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r1.getMethodRule().getClassRule().setRuleValue("ChoiceFormat");
        r1 = g.createRule();
        r1.getMethodRule().getPackageRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r1.getMethodRule().getPackageRule().setRuleValue("ChoiceFormat");
        r1 = g.createRule();
        r1.getMethodRule().getClassRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r1.getMethodRule().getClassRule().setRuleValue("annotation");
        r1 = g.createRule();
        r1.getMethodRule().getPackageRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r1.getMethodRule().getPackageRule().setRuleValue("annotation");
        r1 = g.createRule();
        r1.getMethodRule().getClassRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r1.getMethodRule().getClassRule().setRuleValue("pane");
        r1 = g.createRule();
        r1.getMethodRule().getPackageRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r1.getMethodRule().getPackageRule().setRuleValue("pane");
        r1 = g.createRule();
        r1.getMethodRule().getClassRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r1.getMethodRule().getClassRule().setRuleValue("chooser");
        r1 = g.createRule();
        r1.getMethodRule().getPackageRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r1.getMethodRule().getPackageRule().setRuleValue("chooser");
        r1 = g.createRule();
        r1.getMethodRule().getClassRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r1.getMethodRule().getClassRule().setRuleValue("shape");
        r1 = g.createRule();
        r1.getMethodRule().getPackageRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r1.getMethodRule().getPackageRule().setRuleValue("shape");
        r1 = g.createRule();
        r1.getMethodRule().getClassRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r1.getMethodRule().getClassRule().setRuleValue("drawable");
        r1 = g.createRule();
        r1.getMethodRule().getPackageRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r1.getMethodRule().getPackageRule().setRuleValue("drawable");
        r1 = g.createRule();
        r1.getMethodRule().getClassRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r1.getMethodRule().getClassRule().setRuleValue("sensor");
        r1 = g.createRule();
        r1.getMethodRule().getPackageRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r1.getMethodRule().getPackageRule().setRuleValue("sensor");
        r1 = g.createRule();
        r1.getMethodRule().getClassRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r1.getMethodRule().getClassRule().setRuleValue("gesture");
        r1 = g.createRule();
        r1.getMethodRule().getPackageRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r1.getMethodRule().getPackageRule().setRuleValue("gesture");
        r1 = g.createRule();
        r1.getMethodRule().getClassRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r1.getMethodRule().getClassRule().setRuleValue("audio");
        r1 = g.createRule();
        r1.getMethodRule().getPackageRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r1.getMethodRule().getPackageRule().setRuleValue("audio");
        r1 = g.createRule();
        r1.getMethodRule().getPackageRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r1.getMethodRule().getPackageRule().setRuleValue(".pen.");
        r1 = g.createRule();
        r1.getMethodRule().getClassRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r1.getMethodRule().getClassRule().setRuleValue("motion");
        r1 = g.createRule();
        r1.getMethodRule().getPackageRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r1.getMethodRule().getPackageRule().setRuleValue("motion");
        r1 = g.createRule();
        r1.getMethodRule().getClassRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r1.getMethodRule().getClassRule().setRuleValue("media");
        r1 = g.createRule();
        r1.getMethodRule().getPackageRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r1.getMethodRule().getPackageRule().setRuleValue("media");
        r1 = g.createRule();
        r1.getMethodRule().getClassRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r1.getMethodRule().getClassRule().setRuleValue("imagefilter");
        r1 = g.createRule();
        r1.getMethodRule().getPackageRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r1.getMethodRule().getPackageRule().setRuleValue("imagefilter");
        this.getAntiRules().add(r);
        r = new Rule();
        r.setRuleName("access - anti");
        r.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.STARTS_WITH);
        r.getMethodRule().getSignatureRule().setRuleValue("access$");
        this.getAntiRules().add(r);
        r = new Rule();
        r.setRuleName("notification - anti");
        r.getMethodRule().getClassRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r.getMethodRule().getClassRule().setRuleValue("notification");
        r.getMethodRule().getPackageRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r.getMethodRule().getPackageRule().setRuleValue("notification");
        this.getAntiRules().add(r);
        r = new Rule();
        r.setRuleName("write non-sinks - anti");
        r.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.STARTS_WITH);
        r.getMethodRule().getSignatureRule().setRuleValue("write");
        g = r.createLogicGate(VDBEnums.RULE_GATE_TYPE.OR);
        r1 = g.createRule();
        r1.getMethodRule().getArgumentRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r1.getMethodRule().getArgumentRule().setRuleValue("writer");
        r1 = g.createRule();
        r1.getMethodRule().getArgumentRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
        r1.getMethodRule().getArgumentRule().setRuleValue("channel");
        this.getAntiRules().add(r);
    }

    @Override
    protected String getMarkupType() {
        return "sink";
    }

    @Override
    protected Rule initBulkRule() throws BadRuleException {
        Rule r = new Rule();
        return r;
    }

    @Override
    public String predict_(Method m) throws IfaException {
        LinkedHashMap probabilities = this.getModel().getSortedProbabilities(this.getVector(this.getTestMethod(m)));
        Iterator iterator = probabilities.keySet().iterator();
        while (iterator.hasNext()) {
            double key = (Double)iterator.next();
            if (!((Double)probabilities.get(key) > 0.95)) continue;
            return this.getIdMap().get((int)key);
        }
        return NOT_SINK;
    }

    @Override
    public boolean useNoMarkupMethods() {
        return true;
    }
}

