/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.ica.markup.translator;

import com.ibm.appscan.ica.markup.MarkupException;
import com.ibm.appscan.ica.markup.translator.MarkupChildTranslator;
import com.ibm.appscan.vdb.exception.BadMarkupException;
import com.ibm.appscan.vdb.exception.BadRuleException;
import com.ibm.appscan.vdb.exception.VDBException;
import com.ibm.appscan.vdb.method.Method;
import com.ibm.appscan.vdb.method.markup.Parameter;
import com.ibm.appscan.vdb.method.markup.ao.ActionObject;
import com.ibm.appscan.vdb.misc.VDBEnums;
import com.ibm.appscan.vdb.rule.Rule;

public class SinkArgTranslator
extends MarkupChildTranslator {
    @Override
    public boolean isValidClassForMethod(String markupString, Method m) throws MarkupException {
        try {
            Parameter p = new Parameter(this.getDetailString(m, markupString));
            return p.workForArgs(m);
        }
        catch (BadMarkupException e) {
            return false;
        }
        catch (VDBException e) {
            throw new MarkupException(e);
        }
    }

    @Override
    public String getMarkupString(Method m) throws MarkupException {
        if (!this.hasMarkup(m)) {
            return "0";
        }
        StringBuffer arg = new StringBuffer();
        block4: for (char c : ((ActionObject)m.getSinks().get(0)).getParameter().toString(m).toCharArray()) {
            switch (c) {
                case '-': {
                    arg.append("=");
                    continue block4;
                }
                case ',': {
                    arg.append("_");
                    continue block4;
                }
                default: {
                    arg.append(c);
                }
            }
        }
        if (arg.toString().equals("all")) {
            return "default";
        }
        if (arg.toString().equals("this")) {
            return "default";
        }
        return arg.toString();
    }

    @Override
    public String getDetailString(Method m, String markupString) {
        StringBuffer ret = new StringBuffer();
        block4: for (char c : markupString.toCharArray()) {
            switch (c) {
                case '=': {
                    ret.append("-");
                    continue block4;
                }
                case '_': {
                    ret.append(",");
                    continue block4;
                }
                default: {
                    ret.append(c);
                }
            }
        }
        return ret.toString();
    }

    @Override
    public boolean hasMarkup(Method m) {
        return m.getSinks().size() > 0;
    }

    @Override
    public boolean useOnlyMarkedUpMethods() {
        return true;
    }

    @Override
    protected void initRules() throws MarkupException, BadRuleException {
        Rule r = new Rule();
        r.setRuleName("1 arg - sink arg");
        r.getMethodRule().getArgCountRule().setRuleOperator(VDBEnums.RULE_OPERATOR.INTEGER_EQUALS);
        r.getMethodRule().getArgCountRule().setArgCountValue(1);
        r.getActionObjectRule().setParameter("1");
        this.getRules().add(r);
    }

    @Override
    protected void initAntiRules() throws MarkupException, BadRuleException {
    }

    @Override
    protected String getMarkupType() {
        return "sink_arg";
    }

    @Override
    public String convertRuleToMarkup(Method m) throws MarkupException {
        for (Rule r : this.getRules()) {
            if (!r.isMatch(m)) continue;
            return r.getActionObjectRule().getParameter();
        }
        return null;
    }

    @Override
    protected String getAntiMatch() {
        return null;
    }

    @Override
    public String getDefaultValue() {
        return "default";
    }
}

