/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.ica.model;

import com.hcl.appscan.common.error.ComponentException;
import com.hcl.appscan.common.mlservices.MLServiceFactory;
import com.ibm.appscan.common.Language;
import com.ibm.appscan.ica.markup.MarkupException;
import com.ibm.appscan.ica.model.IIcaModel;
import com.ibm.appscan.vdb.exception.VDBException;
import com.ibm.appscan.vdb.method.Method;
import com.ibm.appscan.vdb.provider.VdbProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.json.JSONArray;
import org.apache.commons.json.JSONException;
import org.apache.commons.json.JSONObject;

public abstract class AbstractRemoteIcaModel
extends MLServiceFactory.MLService<Method, String>
implements IIcaModel {
    @Override
    public void predict(Collection<Method> l) throws MarkupException, ComponentException {
        for (Map.Entry kv : this.m_client.infer(l).entrySet()) {
            ((Method)kv.getKey()).addComment("ICA2.0 (" + this.getClass().getSimpleName() + ") predicted: \"" + (String)kv.getValue() + "\"");
            this.applyMarkup((Method)kv.getKey(), (String)kv.getValue());
        }
    }

    abstract void applyMarkup(Method var1, String var2) throws MarkupException;

    public JSONObject toJson(Collection<Method> batch) throws ComponentException {
        ArrayList<Integer> shape = new ArrayList<Integer>(2);
        shape.add(batch.size());
        shape.add(1);
        try {
            return new JSONObject().put("inputs", (Object[])new JSONObject[]{new JSONObject().put("name", (Object)"simple_name").put("shape", shape).put("datatype", (Object)"BYTES").put("parameters", (Map)new JSONObject().put("content_type", (Object)"str")).put("data", (Collection)batch.stream().map(m -> m.getSignature().substring(0, m.getSignature().indexOf("("))).collect(Collectors.toList())), new JSONObject().put("name", (Object)"signature").put("shape", shape).put("datatype", (Object)"BYTES").put("parameters", (Map)new JSONObject().put("content_type", (Object)"str")).put("data", (Collection)batch.stream().map(m -> m.getSignature()).collect(Collectors.toList()))});
        }
        catch (JSONException e) {
            throw new ComponentException((Throwable)e);
        }
    }

    public Map<Method, String> fromJson(Collection<Method> batch, JSONObject response) throws ComponentException {
        JSONArray results;
        HashMap<Method, String> values = new HashMap<Method, String>(batch.size());
        try {
            results = response.getJSONArray("outputs").getJSONObject(0).getJSONArray("data");
        }
        catch (JSONException e) {
            throw new ComponentException((Throwable)e);
        }
        Iterator<Method> i = batch.iterator();
        for (Object o : results) {
            values.put(i.next(), (String)o);
        }
        return values;
    }

    public String getVersion() {
        return this.m_client.getVersion();
    }

    public boolean getHealth() {
        return this.m_client.getHealth();
    }

    static boolean isTaintType(String arg, Language.LANGUAGE l) throws VDBException {
        if (l == Language.LANGUAGE.C || l == Language.LANGUAGE.C_PLUS_PLUS) {
            return VdbProvider.isTaintType((String)arg);
        }
        return VdbProvider.isTaintType((String)arg) && !VdbProvider.isNumber((String)arg);
    }
}

