/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.ica.model;

import com.hcl.appscan.common.error.ComponentException;
import com.ibm.appscan.common.Language;
import com.ibm.appscan.ica.model.IIcaModel;
import com.ibm.appscan.ica.model.IcaSinkDotnetModel;
import com.ibm.appscan.ica.model.IcaSinkModel;
import com.ibm.appscan.ica.model.IcaSinkVulnModel;
import com.ibm.appscan.ifa.common.IfaException;
import com.ibm.appscan.vdb.method.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class IcaSinkPipeline
implements IIcaModel {
    IcaSinkDotnetModel m_dotnet;
    IcaSinkModel m_sink;
    IcaSinkVulnModel m_vuln;

    public IcaSinkPipeline(IcaSinkDotnetModel dotnet, IcaSinkModel sink, IcaSinkVulnModel vuln) {
        this.m_dotnet = dotnet;
        this.m_sink = sink;
        this.m_vuln = vuln;
    }

    @Override
    public void predict(Collection<Method> methods) throws IfaException, ComponentException {
        List<Method> otherMethods;
        Map<Boolean, List<Method>> mapIsDotnet = methods.stream().collect(Collectors.partitioningBy(m -> m.getLang() == Language.LANGUAGE.DOT_NET));
        ArrayList<Method> sinksForVuln = new ArrayList<Method>();
        List<Method> dotnetMethods = mapIsDotnet.get(true);
        if (dotnetMethods != null && !dotnetMethods.isEmpty()) {
            this.m_dotnet.predict(dotnetMethods);
            sinksForVuln.addAll(dotnetMethods.stream().filter(m -> !m.getSinks().isEmpty()).collect(Collectors.toList()));
        }
        if ((otherMethods = mapIsDotnet.get(false)) != null && !otherMethods.isEmpty()) {
            this.m_sink.predict(otherMethods);
            sinksForVuln.addAll(otherMethods.stream().filter(m -> !m.getSinks().isEmpty()).collect(Collectors.toList()));
        }
        if (!sinksForVuln.isEmpty()) {
            this.m_vuln.predict(sinksForVuln);
        }
    }
}

