/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.vdb.rule;

import com.ibm.appscan.vdb.exception.BadRuleException;
import com.ibm.appscan.vdb.method.Method;
import com.ibm.appscan.vdb.misc.VDBEnums;
import com.ibm.appscan.vdb.rule.BaseRuleMember;
import java.util.ArrayList;

public abstract class SearchRule
extends BaseRuleMember {
    private ArrayList<SearchRule> m_groups;
    private ArrayList<BaseRuleMember> m_base_rules;
    private VDBEnums.RULE_OPERATOR m_rule_operator = VDBEnums.RULE_OPERATOR.NULL;

    public void setRuleOperator(VDBEnums.RULE_OPERATOR operator) throws BadRuleException {
        this.validateOperator(operator);
        this.m_rule_operator = !this.allowsContains() ? (operator == VDBEnums.RULE_OPERATOR.CONTAINS || operator == VDBEnums.RULE_OPERATOR.ENDS_WITH || operator == VDBEnums.RULE_OPERATOR.STARTS_WITH ? VDBEnums.RULE_OPERATOR.EQUALS : (operator == VDBEnums.RULE_OPERATOR.DOES_NOT_CONTAIN || operator == VDBEnums.RULE_OPERATOR.DOES_NOT_END_WITH || operator == VDBEnums.RULE_OPERATOR.DOES_NOT_START_WITH ? VDBEnums.RULE_OPERATOR.DOES_NOT_EQUAL : operator)) : operator;
    }

    public abstract boolean allowsContains();

    public VDBEnums.RULE_OPERATOR getRuleOperator() {
        return this.m_rule_operator;
    }

    protected ArrayList<SearchRule> getGroups() {
        if (this.m_groups == null) {
            this.m_groups = new ArrayList();
        }
        return this.m_groups;
    }

    protected ArrayList<BaseRuleMember> getBaseRules() {
        if (this.m_base_rules == null) {
            this.m_base_rules = new ArrayList();
        }
        return this.m_base_rules;
    }

    public boolean isSearchValid() {
        if (this.getGroups().size() > 0) {
            for (SearchRule g : this.getGroups()) {
                if (!g.isSearchValid()) continue;
                return true;
            }
        }
        if (this.getRuleOperator() == VDBEnums.RULE_OPERATOR.NULL) {
            return false;
        }
        if (this.getBaseRules().size() > 0) {
            for (BaseRuleMember rule : this.getBaseRules()) {
                if (!rule.isRuleValid()) continue;
                return true;
            }
        } else {
            return this.isRuleValid();
        }
        return true;
    }

    protected boolean compareValues(VDBEnums.AO_TYPE methodType) {
        return this.compareValues(this.getRuleOperator(), methodType);
    }

    protected boolean compareValues(VDBEnums.OPTION_NAME name) {
        return this.compareValues(name.toString());
    }

    protected boolean compareValues(VDBEnums.OPTION_CONFIDENCE con) {
        return this.compareValues(con.toString());
    }

    protected boolean compareValues(VDBEnums.OPTION_OPERATOR op) {
        return this.compareValues(op.toString());
    }

    protected boolean compareValues(VDBEnums.SEVERITY methodSev) {
        return this.compareValues(methodSev.toString());
    }

    protected boolean compareValues(boolean methodValue) {
        return this.compareValues(Boolean.toString(methodValue));
    }

    protected boolean compareValues(String methodValue) {
        return this.compareValues(this.getRuleOperator(), methodValue);
    }

    protected boolean compareValues(ArrayList<String> methodValues) {
        return this.compareValues(this.getRuleOperator(), methodValues);
    }

    public boolean compareValues(int count, int value) {
        return this.compareValues(this.getRuleOperator(), count, value);
    }

    protected abstract boolean searchRule(Method var1);

    public boolean isMatch(Method m) {
        if (!this.isSearchValid()) {
            return false;
        }
        return this.searchRule(m);
    }

    protected boolean checkGroups(Method m) {
        if (this.getGroups().size() == 0) {
            return false;
        }
        for (SearchRule rule : this.getGroups()) {
            if (!rule.isSearchValid() || rule.searchRule(m)) continue;
            return false;
        }
        return true;
    }

    protected void addSearchGroup(SearchRule g) {
        this.getGroups().add(g);
    }

    protected void addBaseRule(BaseRuleMember rule) {
        this.getBaseRules().add(rule);
    }

    public String getDetailsText() {
        StringBuffer str = new StringBuffer(150);
        if (this.isRuleValid()) {
            str.append("{" + this.getDetailName());
            if (this.getRuleOperator() != VDBEnums.RULE_OPERATOR.NULL) {
                str.append(" " + (Object)((Object)this.getRuleOperator()) + ": ");
            } else {
                str.append(": ");
            }
            if (this.getBaseRules().size() > 0) {
                for (BaseRuleMember baseRuleMember : this.getBaseRules()) {
                    if (!baseRuleMember.isRuleValid()) continue;
                    str.append("[" + baseRuleMember.getDetailName());
                    str.append(": ");
                    str.append(baseRuleMember.getRuleValue());
                    str.append("]");
                }
            } else {
                str.append(this.getRuleValue());
            }
            str.append("}");
        }
        for (SearchRule searchRule : this.getGroups()) {
            if (searchRule.getDetailsText() == null) continue;
            str.append(searchRule.getDetailsText());
        }
        str.append(this.getApplyGroupsDetail());
        if (this.getRuleValue() != null && this.getRuleValue().length() > 0) {
            str.append("}");
        }
        return str.toString();
    }

    protected String getApplyGroupsDetail() {
        return "";
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof SearchRule) {
            SearchRule rule = (SearchRule)obj;
            if (super.equals(obj)) {
                return this.getRuleOperator() == rule.getRuleOperator();
            }
        }
        return super.equals(obj);
    }

    protected void validateOperator(VDBEnums.RULE_OPERATOR operator) throws BadRuleException {
        if (operator == VDBEnums.RULE_OPERATOR.NULL) {
            throw new BadRuleException("Cannot use NULL for a rule RULE_OPERATOR.");
        }
        if (operator == VDBEnums.RULE_OPERATOR.INTEGER_EQUALS || operator == VDBEnums.RULE_OPERATOR.INTEGER_GREATER_THAN || operator == VDBEnums.RULE_OPERATOR.INTEGER_GREATER_THAN_EQUALS || operator == VDBEnums.RULE_OPERATOR.INTEGER_LESS_THAN || operator == VDBEnums.RULE_OPERATOR.INTEGER_LESS_THAN_EQUALS || operator == VDBEnums.RULE_OPERATOR.INTEGER_NOT_EQUALS) {
            throw new BadRuleException("Cannot use an integer operator with a string rule:{0}", operator.toString());
        }
    }
}

