/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.vdb.rule.method;

import com.ibm.appscan.vdb.method.Method;
import com.ibm.appscan.vdb.rule.SearchRule;
import com.ibm.appscan.vdb.rule.method.ArgCountRule;
import com.ibm.appscan.vdb.rule.method.ClassRule;
import com.ibm.appscan.vdb.rule.method.MethodArgumentRule;
import com.ibm.appscan.vdb.rule.method.MethodReturnRule;
import com.ibm.appscan.vdb.rule.method.MethodSignatureRule;
import com.ibm.appscan.vdb.rule.method.PackageRule;

public class MethodRule
extends SearchRule {
    private MethodSignatureRule m_signature;
    private MethodArgumentRule m_args;
    private MethodReturnRule m_return;
    private ArgCountRule m_arg_count;
    private ClassRule m_class_rule;
    private PackageRule m_package_rule;

    @Override
    public String getDetailName() {
        return "Method Rule";
    }

    @Override
    public boolean allowsContains() {
        return false;
    }

    @Override
    public boolean searchRule(Method m) {
        return this.checkGroups(m);
    }

    @Override
    public boolean isRuleValid() {
        return this.getArgCountRule().isRuleValid() || this.getArgumentRule().isRuleValid() || this.getClassRule().isRuleValid() || this.getPackageRule().isRuleValid() || this.getReturnRule().isRuleValid() || this.getSignatureRule().isRuleValid();
    }

    @Override
    public boolean isMatch(Method m) {
        boolean ret = false;
        if (this.getArgCountRule().isSearchValid()) {
            if (this.getArgCountRule().isMatch(m)) {
                ret = true;
            } else {
                return false;
            }
        }
        if (this.getClassRule().isSearchValid()) {
            if (this.getClassRule().isMatch(m)) {
                ret = true;
            } else {
                return false;
            }
        }
        if (this.getPackageRule().isSearchValid()) {
            if (this.getPackageRule().isMatch(m)) {
                ret = true;
            } else {
                return false;
            }
        }
        if (this.getReturnRule().isSearchValid()) {
            if (this.getReturnRule().isMatch(m)) {
                ret = true;
            } else {
                return false;
            }
        }
        if (this.getArgumentRule().isSearchValid()) {
            if (this.getArgumentRule().isMatch(m)) {
                ret = true;
            } else {
                return false;
            }
        }
        if (this.getSignatureRule().isSearchValid()) {
            if (this.getSignatureRule().isMatch(m)) {
                ret = true;
            } else {
                return false;
            }
        }
        return ret;
    }

    @Override
    public boolean isSearchValid() {
        return this.getArgCountRule().isSearchValid() || this.getArgumentRule().isSearchValid() || this.getClassRule().isSearchValid() || this.getPackageRule().isSearchValid() || this.getReturnRule().isSearchValid() || this.getSignatureRule().isSearchValid();
    }

    public MethodSignatureRule getSignatureRule() {
        if (this.m_signature == null) {
            this.m_signature = new MethodSignatureRule();
            this.addSearchGroup(this.m_signature);
        }
        return this.m_signature;
    }

    public MethodArgumentRule getArgumentRule() {
        if (this.m_args == null) {
            this.m_args = new MethodArgumentRule();
            this.addSearchGroup(this.m_args);
        }
        return this.m_args;
    }

    public MethodReturnRule getReturnRule() {
        if (this.m_return == null) {
            this.m_return = new MethodReturnRule();
            this.addSearchGroup(this.m_return);
        }
        return this.m_return;
    }

    public ArgCountRule getArgCountRule() {
        if (this.m_arg_count == null) {
            this.m_arg_count = new ArgCountRule();
            this.addSearchGroup(this.m_arg_count);
        }
        return this.m_arg_count;
    }

    public ClassRule getClassRule() {
        if (this.m_class_rule == null) {
            this.m_class_rule = new ClassRule();
            this.addSearchGroup(this.m_class_rule);
        }
        return this.m_class_rule;
    }

    public PackageRule getPackageRule() {
        if (this.m_package_rule == null) {
            this.m_package_rule = new PackageRule();
            this.addSearchGroup(this.m_package_rule);
        }
        return this.m_package_rule;
    }
}

