/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.cli.common;

import com.ibm.appscan.cli.common.Main;
import com.ibm.appscan.common.CommonCore;
import com.ibm.appscan.common.error.AppScanException;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;

public class Launcher {
    public static final String APPSCAN_HOME = "appscan.install.dir";
    public static final String MAIN_CLASS = "com.ibm.appscan.cli.common.Main";
    public static boolean debugMode = false;
    protected static final int EXIT_CODE_ERROR = 2;

    private Launcher() {
    }

    public static void main(String[] args) {
        int exitCode;
        try {
            CommonCore.getDirectoryLocator().setProductRoot(new File(args[0]).getCanonicalPath());
            Launcher launcher = new Launcher();
            String[] cmdArgs = Launcher.getCommandArguments(Arrays.copyOfRange(args, 1, args.length));
            exitCode = launcher.run(cmdArgs);
        }
        catch (AppScanException e) {
            exitCode = 2;
            System.err.println(e.getMessage());
        }
        catch (Throwable t) {
            exitCode = 2;
            t.printStackTrace(System.err);
        }
        if (exitCode != 0) {
            if (debugMode) {
                System.out.println("Exit code: " + exitCode);
            }
            System.exit(exitCode);
        }
    }

    private int run(String[] args) throws AppScanException {
        int exitCode = 0;
        Throwable thrown = null;
        try {
            Main main = new Main();
            main.start(args);
        }
        catch (Throwable t) {
            t.printStackTrace(System.err);
            thrown = t;
        }
        if (thrown != null) {
            exitCode = 2;
        }
        return exitCode;
    }

    private static String[] getCommandArguments(String[] args) {
        ArrayList<String> cmdArgs = new ArrayList<String>();
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i].trim();
            if (arg.length() > 2 && arg.startsWith("-D")) {
                String[] property = arg.substring(2).split("=", 2);
                if (property.length < 2) {
                    System.setProperty(property[0], "");
                    continue;
                }
                System.setProperty(property[0], property[1]);
                continue;
            }
            cmdArgs.add(arg);
        }
        return cmdArgs.toArray(new String[cmdArgs.size()]);
    }
}

