/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.cli.common.commands;

import com.ibm.appscan.cli.common.CLIConstants;
import com.ibm.appscan.cli.common.Messages;
import com.ibm.appscan.cli.common.components.Command;
import com.ibm.appscan.cli.common.handlers.ExitHandler;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;

public class ExitCommand
extends Command
implements CLIConstants {
    private ExitHandler m_handler;

    public ExitCommand() {
    }

    public ExitCommand(String[] args) {
        super(args);
    }

    @Override
    public void configure() {
        this.setNamespace(Messages.getMessage("namespace.global", new Object[0]));
        this.setName("exit");
        this.setAlias("quit");
        this.setDescription(Messages.getMessage("command.exit.description", new Object[0]));
        this.setOptions(this.buildOptions(), false);
    }

    @Override
    protected Options buildOptions() {
        Options options = new Options();
        options.addOption("exit", "quit", false, Messages.getMessage("command.exit.description", new Object[0]));
        options.addOption("s", false, Messages.getMessage("option.silent.description", new Object[0]));
        return options;
    }

    @Override
    public void execute() {
        CommandLine cmd = this.getCommandLine();
        if (cmd == null) {
            return;
        }
        if (cmd.hasOption("h")) {
            this.printHelp();
        } else {
            if (this.m_handler == null) {
                this.m_handler = new ExitHandler();
            }
            this.m_handler.performExit(cmd.hasOption("s"));
        }
    }

    @Override
    public Command createCommand(String[] args) {
        return new ExitCommand(args);
    }
}

