/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.cli.common.components;

import com.ibm.appscan.cli.common.components.Command;
import com.ibm.appscan.cli.common.model.ICommand;
import com.ibm.appscan.cli.common.model.ICommandManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;

public class CommandManager
implements ICommandManager {
    private Map<String, ICommand> m_commands = new HashMap<String, ICommand>();
    private static ServiceLoader<ICommand> LOADER = ServiceLoader.load(ICommand.class);

    public CommandManager() {
        for (ICommand cmd : LOADER) {
            Command command = (Command)cmd;
            if (!command.shouldRegister()) continue;
            this.registerCommand(command.getName(), cmd);
            if (command.getAlias() == null) continue;
            this.registerCommand(command.getAlias(), cmd);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerCommand(String commandKey, ICommand command) {
        Map<String, ICommand> map = this.m_commands;
        synchronized (map) {
            this.m_commands.put(commandKey, command);
        }
    }

    @Override
    public void registerCommand(Command command) {
        this.registerCommand(command.getName(), command);
        if (command.getAlias() != null) {
            this.registerCommand(command.getAlias(), command);
        }
    }

    @Override
    public ICommand createCommand(String commandKey, String[] args) {
        return ((Command)this.m_commands.get(commandKey)).createCommand(args);
    }

    @Override
    public boolean hasCommand(String commandKey) {
        return this.m_commands.containsKey(commandKey);
    }

    @Override
    public List<ICommand> getRegisteredCommands() {
        ArrayList<ICommand> commandList = new ArrayList<ICommand>();
        commandList.addAll(this.m_commands.values());
        return commandList;
    }
}

