/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.andromeda.util;

import com.ibm.wala.util.collections.EmptyIterator;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class CartesianProduct<T>
implements Iterable<T[]> {
    private final T[][] arrayOfArrays;

    public CartesianProduct(T[][] array) {
        this.arrayOfArrays = array;
        this.normalize();
    }

    private void normalize() {
        for (int i = 0; i < this.arrayOfArrays.length; ++i) {
            if (this.arrayOfArrays[i] == null || this.arrayOfArrays[i].length != 0) continue;
            this.arrayOfArrays[i] = null;
        }
    }

    @Override
    public Iterator<T[]> iterator() {
        if (this.arrayOfArrays == null) {
            return EmptyIterator.instance();
        }
        return new CartesianProductIterator();
    }

    private class CartesianProductIterator
    implements Iterator<T[]> {
        private int[] arrayIndices;
        private boolean atEnd;

        public CartesianProductIterator() {
            this.arrayIndices = new int[CartesianProduct.this.arrayOfArrays.length];
            this.atEnd = false;
        }

        private boolean isAtEnd(int index) {
            if (CartesianProduct.this.arrayOfArrays[index] == null) {
                return true;
            }
            return this.arrayIndices[index] >= CartesianProduct.this.arrayOfArrays[index].length - 1;
        }

        @Override
        public boolean hasNext() {
            return !this.atEnd;
        }

        @Override
        public T[] next() {
            int i;
            Object[] nextArray = new Object[this.arrayIndices.length];
            if (this.atEnd) {
                throw new NoSuchElementException();
            }
            try {
                for (i = 0; i < this.arrayIndices.length; ++i) {
                    nextArray[i] = CartesianProduct.this.arrayOfArrays[i] == null ? null : CartesianProduct.this.arrayOfArrays[i][this.arrayIndices[i]];
                }
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw new NoSuchElementException("not flagged as at the end, but did not work anyway");
            }
            for (i = this.arrayIndices.length - 1; i >= 0; --i) {
                if (!this.isAtEnd(i)) {
                    this.arrayIndices[i] = this.arrayIndices[i] + 1;
                    break;
                }
                this.arrayIndices[i] = 0;
            }
            if (i < 0) {
                this.atEnd = true;
            }
            return nextArray;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Cartesian Products do not support removal");
        }
    }
}

