/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.andromeda.util.dependencyAnalysis;

import com.ibm.wala.andromeda.util.dependencyAnalysis.DAGraph;
import com.ibm.wala.andromeda.util.dependencyAnalysis.SplittedScopeExclusions;
import com.ibm.wala.classLoader.Module;
import com.ibm.wala.classLoader.ModuleEntry;
import com.ibm.wala.ipa.callgraph.AnalysisScope;
import com.ibm.wala.shrikeBT.Decoder;
import com.ibm.wala.shrikeCT.InvalidClassFileException;
import com.ibm.wala.types.ClassLoaderReference;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.collections.MapUtil;
import com.ibm.wala.util.config.SetOfClasses;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class AnalysisScopeSplitter {
    private final List<Module> primodialModules;
    private final List<Module> extensionModules;
    private final List<Module> applicationModules;
    private final Map<ModuleEntry, Module> moduleEntryToModule;
    private final Map<Module, Set<ModuleEntry>> moduleToModuleEntry;
    private final Set<ModuleEntry> allModuleEntries;
    private final DAGraph graph;
    private final Map<ModuleEntry, Set<ModuleEntry>> rootME2ReachableME;
    private final Map<ModuleEntry, Set<ModuleEntry>> rootME2ReachableAppME;

    public AnalysisScopeSplitter(AnalysisScope initialScope) throws InvalidClassFileException, Decoder.InvalidBytecodeException {
        this.primodialModules = initialScope.getModules(ClassLoaderReference.Primordial);
        this.extensionModules = initialScope.getModules(ClassLoaderReference.Extension);
        this.applicationModules = initialScope.getModules(ClassLoaderReference.Application);
        this.moduleEntryToModule = HashMapFactory.make();
        this.moduleToModuleEntry = HashMapFactory.make();
        this.rootME2ReachableME = HashMapFactory.make();
        this.rootME2ReachableAppME = HashMapFactory.make();
        this.allModuleEntries = HashSetFactory.make();
        this.associateAllModulesAndModuleEntries();
        this.graph = new DAGraph(this.allModuleEntries);
        this.retrieveReachableModuleEntries();
        this.excludeRedundantRootModuleEntries();
    }

    private void associateAllModulesAndModuleEntries() {
        HashSet allModules = HashSetFactory.make();
        allModules.addAll(this.primodialModules);
        allModules.addAll(this.extensionModules);
        allModules.addAll(this.applicationModules);
        for (Module m : allModules) {
            Iterator meIter = m.getEntries();
            while (meIter.hasNext()) {
                ModuleEntry me = (ModuleEntry)meIter.next();
                if (!me.isClassFile()) continue;
                this.moduleEntryToModule.put(me, m);
                Set moduleEntriesForModule = MapUtil.findOrCreateSet(this.moduleToModuleEntry, (Object)m);
                moduleEntriesForModule.add(me);
                this.allModuleEntries.add(me);
            }
        }
    }

    private void retrieveReachableModuleEntries() {
        HashSet rootModules = HashSetFactory.make();
        rootModules.addAll(this.applicationModules);
        HashSet rootModuleEntries = HashSetFactory.make();
        for (Module m : rootModules) {
            Set<ModuleEntry> entries = this.moduleToModuleEntry.get(m);
            if (entries == null) continue;
            rootModuleEntries.addAll(entries);
        }
        for (ModuleEntry me : rootModuleEntries) {
            boolean bSkipIteration = false;
            for (Set<ModuleEntry> reachableAppModuleEntries : this.rootME2ReachableAppME.values()) {
                if (!reachableAppModuleEntries.contains(me)) continue;
                bSkipIteration = true;
                break;
            }
            if (bSkipIteration) continue;
            TypeReference rootType = this.graph.getTypeForModuleEntry(me);
            HashSet rootTypes = HashSetFactory.make();
            rootTypes.add(rootType);
            Set<TypeReference> reachableTypes = this.graph.getReachableTypes(rootTypes);
            Set<ModuleEntry> reachableModuleEntries = this.graph.getModuleEntriesForTypes(reachableTypes);
            this.rootME2ReachableME.put(me, reachableModuleEntries);
            HashSet appModuleEntries = HashSetFactory.make();
            for (ModuleEntry moduleEntry : reachableModuleEntries) {
                if (!rootModuleEntries.contains(moduleEntry)) continue;
                appModuleEntries.add(moduleEntry);
            }
            this.rootME2ReachableAppME.put(me, appModuleEntries);
        }
    }

    private void excludeRedundantRootModuleEntries() {
        HashSet moduleEntriesToRemove = HashSetFactory.make();
        for (ModuleEntry rootModuleEntry : this.rootME2ReachableAppME.keySet()) {
            for (ModuleEntry rootModuleEntry2 : this.rootME2ReachableAppME.keySet()) {
                if (rootModuleEntry2 == rootModuleEntry || !this.rootME2ReachableAppME.get(rootModuleEntry2).contains(rootModuleEntry)) continue;
                moduleEntriesToRemove.add(rootModuleEntry);
            }
        }
        for (ModuleEntry keyToRemove : moduleEntriesToRemove) {
            this.rootME2ReachableAppME.remove(keyToRemove);
            this.rootME2ReachableME.remove(keyToRemove);
        }
    }

    public Set<AnalysisScope> splitScope() {
        HashSet resScopes = HashSetFactory.make();
        for (Set<ModuleEntry> moduleEntries : this.rootME2ReachableME.values()) {
            resScopes.add(this.createAnalysisScope(moduleEntries));
        }
        return resScopes;
    }

    public Set<AnalysisScope> splitScopeToBuckets() {
        HashSet resScopes = HashSetFactory.make();
        HashSet mesBuckets = HashSetFactory.make();
        HashSet mesBucketToAdd = null;
        for (ModuleEntry rootME : this.rootME2ReachableAppME.keySet()) {
            boolean deferredBusketAdd = true;
            for (Set mesBucket : mesBuckets) {
                Set<ModuleEntry> appMes;
                if (!this.haveCommonElem(mesBucket, appMes = this.rootME2ReachableAppME.get(rootME))) continue;
                mesBucket.addAll(appMes);
                deferredBusketAdd = false;
                break;
            }
            if (!deferredBusketAdd) continue;
            mesBucketToAdd = HashSetFactory.make();
            mesBucketToAdd.addAll((Collection)this.rootME2ReachableAppME.get(rootME));
            mesBuckets.add(mesBucketToAdd);
        }
        for (Set bucket : mesBuckets) {
            resScopes.add(this.createAnalysisScope(bucket));
        }
        return resScopes;
    }

    private boolean haveCommonElem(Set<ModuleEntry> mesBucket, Set<ModuleEntry> appMes) {
        for (ModuleEntry me : mesBucket) {
            if (!appMes.contains(me)) continue;
            return true;
        }
        return false;
    }

    private AnalysisScope createAnalysisScope(Set<ModuleEntry> moduleEntries) {
        AnalysisScope scope = AnalysisScope.createJavaAnalysisScope();
        HashSet scopeModules = HashSetFactory.make();
        for (ModuleEntry me : moduleEntries) {
            scopeModules.add(this.moduleEntryToModule.get(me));
        }
        for (Module m : scopeModules) {
            if (this.applicationModules.contains(m)) {
                scope.addToScope(ClassLoaderReference.Application, m);
                continue;
            }
            if (this.extensionModules.contains(m)) {
                scope.addToScope(ClassLoaderReference.Extension, m);
                continue;
            }
            scope.addToScope(ClassLoaderReference.Primordial, m);
        }
        scope.setExclusions((SetOfClasses)new SplittedScopeExclusions(this.graph.getTypesForModuleEntries(moduleEntries)));
        return scope;
    }
}

